<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cfdi="http://www.sat.gob.mx/cfd/3"
    xmlns:nomina12="http://www.sat.gob.mx/nomina12">
    <xsl:output method="xml" encoding="UTF-8"/>

    <xsl:template match="/data/Emisor">
        <cfdi:Emisor>
            <xsl:attribute name="Rfc">
                <xsl:value-of select="Rfc" />
            </xsl:attribute>
            <xsl:attribute name="Nombre">
                <xsl:value-of select="Nombre" />
            </xsl:attribute>
            <xsl:attribute name="RegimenFiscal">
                <xsl:value-of select="RegimenFiscal" />
            </xsl:attribute>
        </cfdi:Emisor>
    </xsl:template>

    <xsl:template match="/data/Receptor">
        <cfdi:Receptor>
            <xsl:attribute name="Rfc">
                <xsl:value-of select="Rfc" />
            </xsl:attribute>
            <xsl:attribute name="Nombre">
                <xsl:value-of select="Nombre" />
            </xsl:attribute>
            <xsl:attribute name="UsoCFDI">
                <xsl:value-of select="UsoCFDI" />
            </xsl:attribute>
        </cfdi:Receptor>
    </xsl:template>

    <xsl:template match="/data/Conceptos/Concepto">
        <cfdi:Concepto>
            <xsl:attribute name="ClaveUnidad">
                <xsl:text>ACT</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="ClaveProdServ">
                <xsl:value-of select="ClaveProdServ" />
            </xsl:attribute>
            <xsl:attribute name="Cantidad">
                <xsl:text>1</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="Descripcion">
                <xsl:text>Pago de nómina</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="ValorUnitario">
                <xsl:value-of select='format-number(valorUnitario, "0.00")' />
            </xsl:attribute>
            <xsl:attribute name="Importe">
                <xsl:value-of select='format-number(importe, "0.00")' />
            </xsl:attribute>
            <xsl:attribute name="Descuento">
                <xsl:value-of select='format-number(descuento, "0.00")' />
            </xsl:attribute>
        </cfdi:Concepto>
    </xsl:template>

    <xsl:template match="/data/Deducciones">
        <xsl:for-each select="/data/Deducciones/Deduccion">
            <nomina12:Deduccion>
                <xsl:attribute name="TipoDeduccion">
                    <xsl:value-of select="TipoDeduccion" />
                </xsl:attribute>
                <xsl:attribute name="Clave">
                    <xsl:value-of select="Clave" />
                </xsl:attribute>
                <xsl:attribute name="Concepto">
                    <xsl:value-of select="Concepto" />
                </xsl:attribute>
                <xsl:attribute name="Importe">
                    <xsl:value-of select='format-number(Importe, "0.00")' />
                </xsl:attribute>
            </nomina12:Deduccion>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="/data">
        <cfdi:Comprobante xmlns:cfdi="http://www.sat.gob.mx/cfd/3"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns:nomina12="http://www.sat.gob.mx/nomina12" xsi:schemaLocation="http://www.sat.gob.mx/cfd/3 http://www.sat.gob.mx/sitio_internet/cfd/3/cfdv33.xsd http://www.sat.gob.mx/nomina12 http://www.sat.gob.mx/sitio_internet/cfd/nomina/nomina12.xsd" Version="3.3" Serie="RN">
            <xsl:attribute name="Folio">
                <xsl:value-of select="Folio" />
            </xsl:attribute>
            <xsl:attribute name="Fecha">
                <xsl:value-of select="Fecha" />
            </xsl:attribute>
            <xsl:attribute name="Sello" />
            <xsl:attribute name="FormaPago">
                <xsl:value-of select="FormaPago" />
            </xsl:attribute>
            <xsl:attribute name="NoCertificado" />
            <xsl:attribute name="Certificado" />
            <xsl:attribute name="SubTotal">
                <xsl:value-of select='format-number(Subtotal, "0.00")' />
            </xsl:attribute>
            <xsl:attribute name="Descuento">
                <xsl:value-of select='format-number(Descuento, "0.00")' />
            </xsl:attribute>
            <xsl:attribute name="Moneda">
                <xsl:text>MXN</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="Total">
                <xsl:value-of select='format-number(Total, "0.00")' />
            </xsl:attribute>
            <xsl:attribute name="TipoDeComprobante">
                <xsl:text>N</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="MetodoPago">
                <xsl:text>PUE</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="LugarExpedicion">
                <xsl:value-of select="LugarExpedicion" />
            </xsl:attribute>

            <xsl:apply-templates select="Emisor"/>
            <xsl:apply-templates select="Receptor"/>
            <cfdi:Conceptos>
                <xsl:apply-templates select="Conceptos"/>
            </cfdi:Conceptos>

            <cfdi:Complemento>
                <nomina12:Nomina Version="1.2">
                    <xsl:attribute name="TipoNomina">
                        <xsl:value-of select="nomina/tipoNomina" />
                    </xsl:attribute>
                    <xsl:attribute name="FechaPago">
                        <xsl:value-of select="nomina/FechaPago" />
                    </xsl:attribute>
                    <xsl:attribute name="FechaInicialPago">
                        <xsl:value-of select="nomina/FechaInicialPago" />
                    </xsl:attribute>
                    <xsl:attribute name="FechaFinalPago">
                        <xsl:value-of select="nomina/FechaFinalPago" />
                    </xsl:attribute>
                    <xsl:attribute name="NumDiasPagados">
                        <xsl:value-of select="nomina/dias" />
                    </xsl:attribute>
                    <xsl:attribute name="TotalPercepciones">
                        <xsl:value-of select='format-number(nomina/totalPercepciones, "0.00")' />
                    </xsl:attribute>
                    <xsl:attribute name="TotalDeducciones">
                        <xsl:value-of select='format-number(nomina/totalDeducciones, "0.00")' />
                    </xsl:attribute>
                    <xsl:attribute name="TotalOtrosPagos">
                        <xsl:value-of select='format-number(nomina/totalOtrosPagos, "0.00")' />
                    </xsl:attribute>
                    
                    <nomina12:Emisor>
                        <xsl:attribute name="RegistroPatronal">
                            <xsl:value-of select="nomina/registroPatronal" />
                        </xsl:attribute>
                    </nomina12:Emisor>
                    <nomina12:Receptor TipoContrato="01">
                        <xsl:attribute name="Curp">
                            <xsl:value-of select="Receptor/curp" />
                        </xsl:attribute>
                        <xsl:attribute name="NumSeguridadSocial">
                            <xsl:value-of select="nomina/numSeguridadSocial" />
                        </xsl:attribute>
                        <xsl:attribute name="FechaInicioRelLaboral">
                            <xsl:value-of select="nomina/fechaInicioRelLaboral" />
                        </xsl:attribute>
                        <xsl:attribute name="Antigüedad">
                            <xsl:value-of select="nomina/anti" />
                        </xsl:attribute>
                        <xsl:attribute name="TipoRegimen">
                            <xsl:value-of select="nomina/tipoRegimen" />
                        </xsl:attribute>
                        <xsl:attribute name="NumEmpleado">
                            <xsl:value-of select="nomina/numEmpleado" />
                        </xsl:attribute>
                        <xsl:attribute name="RiesgoPuesto">
                            <xsl:value-of select="nomina/RiesgoPuesto" />
                        </xsl:attribute>
                        <xsl:attribute name="PeriodicidadPago">
                            <xsl:value-of select="nomina/periodicidad" />
                        </xsl:attribute>
                        <xsl:attribute name="SalarioDiarioIntegrado">
                            <xsl:value-of select="nomina/salarioDiarioIntegrado" />
                        </xsl:attribute>
                        <xsl:attribute name="ClaveEntFed">
                            <xsl:value-of select="nomina/claveEntFed" />
                        </xsl:attribute>
                    </nomina12:Receptor>
                    
                    <nomina12:Percepciones>
                        <xsl:attribute name="TotalSueldos">
                            <xsl:value-of select='format-number(nomina/totalSueldos, "0.00")' />
                        </xsl:attribute>
                        <xsl:attribute name="TotalGravado">
                            <xsl:value-of select='format-number(nomina/totalGravado, "0.00")' />
                        </xsl:attribute>
                        <xsl:attribute name="TotalExento">
                            <xsl:value-of select='format-number(nomina/totalExento, "0.00")' />
                        </xsl:attribute>

                        <nomina12:Percepcion TipoPercepcion="001" Clave="001" Concepto="Pago nómina">
                            <xsl:attribute name="ImporteGravado">
                                <xsl:value-of select='format-number(nomina/importeGravado, "0.00")' />
                            </xsl:attribute>
                            <xsl:attribute name="ImporteExento">
                                <xsl:value-of select='format-number(nomina/importeExento, "0.00")' />
                            </xsl:attribute>
                        </nomina12:Percepcion>
                    </nomina12:Percepciones>

                    <nomina12:Deducciones>
                        <xsl:attribute name="TotalOtrasDeducciones">
                            <xsl:value-of select='format-number(nomina/totalOtrasDeducciones, "0.00")' />
                        </xsl:attribute>

                        <xsl:if test="nomina/totalImpuestosRetenidos > 0">
                            <xsl:attribute name="TotalImpuestosRetenidos">
                                <xsl:value-of select='format-number(nomina/totalImpuestosRetenidos, "0.00")' />
                            </xsl:attribute>
                        </xsl:if>

                        <xsl:apply-templates select="Deducciones"/>
                    </nomina12:Deducciones>

                    <nomina12:OtrosPagos>
                        <nomina12:OtroPago TipoOtroPago="002" Clave="002" Concepto="Pago nómina">
                            <xsl:attribute name="Importe">
                                <xsl:value-of select='format-number(nomina/totalOtrosPagos, "0.00")' />
                            </xsl:attribute>
                            <nomina12:SubsidioAlEmpleo>
                                <xsl:attribute name="SubsidioCausado">
                                    <xsl:value-of select='format-number(nomina/subsidioCausado, "0.00")' />
                                </xsl:attribute>
                            </nomina12:SubsidioAlEmpleo>
                        </nomina12:OtroPago>
                    </nomina12:OtrosPagos>
                </nomina12:Nomina>
            </cfdi:Complemento>
            
        </cfdi:Comprobante>

    </xsl:template>

</xsl:stylesheet>
