<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cfdi="http://www.sat.gob.mx/cfd/3">
    <xsl:output method="xml" encoding="UTF-8"/>

    <xsl:template match="/data/Emisor">
        <cfdi:Emisor>
            <xsl:attribute name="Rfc">
                <xsl:value-of select="Rfc" />
            </xsl:attribute>
            <xsl:attribute name="Nombre">
                <xsl:value-of select="Nombre" />
            </xsl:attribute>
            <xsl:attribute name="RegimenFiscal">
                <xsl:value-of select="RegimenFiscal" />
            </xsl:attribute>
        </cfdi:Emisor>
    </xsl:template>

    <xsl:template match="/data/Receptor">
        <cfdi:Receptor>
            <xsl:attribute name="Rfc">
                <xsl:value-of select="Rfc" />
            </xsl:attribute>
            <xsl:attribute name="Nombre">
                <xsl:value-of select="Nombre" />
            </xsl:attribute>
            <xsl:attribute name="UsoCFDI">
                <xsl:value-of select="UsoCFDI" />
            </xsl:attribute>
        </cfdi:Receptor>
    </xsl:template>

    <xsl:template match="/data/Conceptos">
        <xsl:for-each select="/data/Conceptos/concepto">
        <cfdi:Concepto>
            <xsl:attribute name="ClaveUnidad">
                <xsl:value-of select="ClaveUnidad" />
            </xsl:attribute>
            <xsl:attribute name="ClaveProdServ">
                <xsl:value-of select="ClaveProdServ" />
            </xsl:attribute>
            <xsl:attribute name="Cantidad">
                <xsl:text>1</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="Descripcion">
                <xsl:value-of select="Descripcion" />
            </xsl:attribute>
            <xsl:attribute name="ValorUnitario">
                <xsl:text>0</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="Importe">
                <xsl:text>0</xsl:text>
            </xsl:attribute>
        </cfdi:Concepto>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="/data/Documentos">
        <xsl:for-each select="/data/Documentos/documento">
        <DoctoRelacionado>
            <xsl:attribute name="IdDocumento">
                <xsl:value-of select="IdDocumento" />
            </xsl:attribute>
            <xsl:attribute name="MonedaDR">
                <xsl:value-of select="MonedaDR" />
            </xsl:attribute>
            <xsl:attribute name="MetodoDePagoDR">
                <xsl:value-of select="MetodoDePagoDR" />
            </xsl:attribute>
            <xsl:attribute name="NumParcialidad">
                <xsl:value-of select="NumParcialidad" />
            </xsl:attribute>
            <xsl:attribute name="ImpSaldoAnt">
                <xsl:value-of select='format-number(ImpSaldoAnt, "0.00")' />
            </xsl:attribute>
            <xsl:attribute name="ImpPagado">
                <xsl:value-of select='format-number(ImpPagado, "0.00")' />
            </xsl:attribute>
            <xsl:attribute name="ImpSaldoInsoluto">
                <xsl:value-of select='format-number(ImpSaldoInsoluto, "0.00")' />
            </xsl:attribute>
        </DoctoRelacionado>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="/data/Complemento">
        <pagos100 Version="1.0">
            <pago100>
                <xsl:attribute name="FechaPago">
                    <xsl:value-of select="FechaPago" />
                </xsl:attribute>
                <xsl:attribute name="FormaDePagoP">
                    <xsl:value-of select="FormaDePagoP" />
                </xsl:attribute>
                <xsl:attribute name="MonedaP">
                    <xsl:value-of select="MonedaP" />
                </xsl:attribute>
                <xsl:attribute name="Monto">
                    <xsl:value-of select='format-number(Monto, "#.00")' />
                </xsl:attribute>
                <xsl:apply-templates select="/data/Documentos"/>
            </pago100>
        </pagos100>
    </xsl:template>

    <xsl:template match="/data">
        <cfdi:Comprobante xmlns:cfdi="http://www.sat.gob.mx/cfd/3" 
            xmlns:pago10="http://www.sat.gob.mx/Pagos"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"            
            xsi:schemaLocation="http://www.sat.gob.mx/cfd/3 http://www.sat.gob.mx/sitio_internet/cfd/3/cfdv33.xsd http://www.sat.gob.mx/Pagos http://www.sat.gob.mx/sitio_internet/cfd/Pagos/Pagos10.xsd"
            Version="3.3">
            <xsl:attribute name="Folio">
                <xsl:value-of select="Folio" />
            </xsl:attribute>
            <xsl:attribute name="Fecha">
                <xsl:value-of select="Fecha" />
            </xsl:attribute>
            <xsl:attribute name="Sello" />
            <xsl:attribute name="NoCertificado" />
            <xsl:attribute name="Certificado" />
            <xsl:attribute name="SubTotal">
                <xsl:text>0</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="Moneda">
                <xsl:text>XXX</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="Total">
                <xsl:text>0</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="TipoDeComprobante">
                <xsl:value-of select="TipoComprobante" />
            </xsl:attribute>
            <xsl:attribute name="LugarExpedicion">
                <xsl:value-of select="lugarExpedicion" />
            </xsl:attribute>

            <xsl:apply-templates select="Emisor"/>
            <xsl:apply-templates select="Receptor"/>

            <cfdi:Conceptos>
                <xsl:apply-templates select="Conceptos"/>
            </cfdi:Conceptos>
    
            <cfdi:Complemento>
                <xsl:apply-templates select="Complemento"/>
            </cfdi:Complemento>
        </cfdi:Comprobante>

    </xsl:template>

</xsl:stylesheet>
