<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cfdi="http://www.sat.gob.mx/cfd/3">
    <xsl:output method="xml" encoding="UTF-8"/>

    <xsl:template match="/data/Emisor">
        <cfdi:Emisor>
            <xsl:attribute name="Rfc">
                <xsl:value-of select="Rfc" />
            </xsl:attribute>
            <xsl:attribute name="Nombre">
                <xsl:value-of select="Nombre" />
            </xsl:attribute>
            <xsl:attribute name="RegimenFiscal">
                <xsl:value-of select="RegimenFiscal" />
            </xsl:attribute>
        </cfdi:Emisor>
    </xsl:template>

    <xsl:template match="/data/Receptor">
        <cfdi:Receptor>
            <xsl:attribute name="Rfc">
                <xsl:value-of select="Rfc" />
            </xsl:attribute>
            <xsl:attribute name="Nombre">
                <xsl:value-of select="Nombre" />
            </xsl:attribute>
            <xsl:attribute name="UsoCFDI">
                <xsl:value-of select="UsoCFDI" />
            </xsl:attribute>
        </cfdi:Receptor>
    </xsl:template>

    <xsl:template match="/data/Conceptos">
        <xsl:for-each select="/data/Conceptos/concepto">
        <cfdi:Concepto>
            <xsl:attribute name="ClaveUnidad">
                <xsl:value-of select="ClaveUnidad" />
            </xsl:attribute>
            <xsl:attribute name="ClaveProdServ">
                <xsl:value-of select="ClaveProdServ" />
            </xsl:attribute>
            <xsl:attribute name="Cantidad">
                <xsl:text>1</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="Descripcion">
                <xsl:value-of select="Descripcion" />
            </xsl:attribute>
            <xsl:attribute name="ValorUnitario">
                <xsl:value-of select='format-number(ValorUnitario, "#.00")' />
            </xsl:attribute>
            <xsl:attribute name="Importe">
                <xsl:value-of select='format-number(Importe, "#.00")' />
            </xsl:attribute>
            <cfdi:Impuestos>
                <cfdi:Traslados>
                    <cfdi:Traslado>
                        <xsl:attribute name="Base">
                            <xsl:value-of select='format-number(Importe, "#.00")' />
                        </xsl:attribute>
                        <xsl:attribute name="Impuesto">
                            <xsl:text>002</xsl:text>
                        </xsl:attribute>
                        <xsl:attribute name="TipoFactor">
                            <xsl:text>Tasa</xsl:text>
                        </xsl:attribute>
                        <xsl:attribute name="TasaOCuota">
                            <xsl:text>0.160000</xsl:text>
                        </xsl:attribute>
                        <xsl:attribute name="Importe">
                            <xsl:value-of select='format-number(Impuesto, "#.00")' />
                        </xsl:attribute>
                    </cfdi:Traslado>
                </cfdi:Traslados>
                <xsl:if test='applyRetention = 1'>
                <cfdi:Retenciones>
                    <cfdi:Retencion>
                        <xsl:attribute name="Base">
                            <xsl:value-of select='format-number(Importe, "#.00")' />
                        </xsl:attribute>
                        <xsl:attribute name="Impuesto">
                            <xsl:text>002</xsl:text>
                        </xsl:attribute>
                        <xsl:attribute name="TipoFactor">
                            <xsl:text>Tasa</xsl:text>
                        </xsl:attribute>
                        <xsl:attribute name="TasaOCuota">
                            <xsl:value-of select='format-number(taxRetention, "0.000000")' />
                        </xsl:attribute>
                        <xsl:attribute name="Importe">
                            <xsl:value-of select='format-number(retention, "#.00")' />
                        </xsl:attribute>
                    </cfdi:Retencion>
                </cfdi:Retenciones>
                </xsl:if>
            </cfdi:Impuestos>
        </cfdi:Concepto>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="/data/Impuestos">
        <cfdi:Impuestos>
            <xsl:if test='applyRetention = 1'>
                <xsl:attribute name="TotalImpuestosRetenidos">
                    <xsl:value-of select='format-number(retention, "#.00")' />
                </xsl:attribute>    
            </xsl:if>
            <xsl:attribute name="TotalImpuestosTrasladados">
                <xsl:value-of select='format-number(Importe, "#.00")' />
            </xsl:attribute>

            <xsl:if test='applyRetention = 1'>
                <cfdi:Retenciones>
                    <cfdi:Retencion>
                        <xsl:attribute name="Impuesto">
                            <xsl:text>002</xsl:text>
                        </xsl:attribute>
                        <xsl:attribute name="Importe">
                            <xsl:value-of select='format-number(retention, "#.00")' />
                        </xsl:attribute>
                    </cfdi:Retencion>
                </cfdi:Retenciones>
            </xsl:if>

            <cfdi:Traslados>
                <cfdi:Traslado>
                    <xsl:attribute name="Impuesto">
                        <xsl:text>002</xsl:text>
                    </xsl:attribute>
                    <xsl:attribute name="TipoFactor">
                        <xsl:text>Tasa</xsl:text>
                    </xsl:attribute>
                    <xsl:attribute name="TasaOCuota">
                        <xsl:text>0.160000</xsl:text>
                    </xsl:attribute>
                    <xsl:attribute name="Importe">
                        <xsl:value-of select='format-number(Importe, "#.00")' />
                    </xsl:attribute>
                </cfdi:Traslado>
            </cfdi:Traslados>
        </cfdi:Impuestos>
    </xsl:template>

    <xsl:template match="/data">
        <cfdi:Comprobante xmlns:cfdi="http://www.sat.gob.mx/cfd/3"
            xmlns:xs="http://www.w3.org/2001/XMLSchema"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"            
            xsi:schemaLocation="http://www.sat.gob.mx/cfd/3 http://www.sat.gob.mx/sitio_internet/cfd/3/cfdv33.xsd"
            Version="3.3">
            <xsl:attribute name="Folio">
                <xsl:value-of select="Folio" />
            </xsl:attribute>
            <xsl:attribute name="Fecha">
                <xsl:value-of select="Fecha" />
            </xsl:attribute>
            <xsl:attribute name="Sello" />
            <xsl:attribute name="FormaPago">
                <xsl:value-of select="FormaPago" />
            </xsl:attribute>
            <xsl:attribute name="NoCertificado" />
            <xsl:attribute name="Certificado" />
            <xsl:attribute name="SubTotal">
                <xsl:value-of select='format-number(Subtotal, "#.00")' />
            </xsl:attribute>
            <xsl:attribute name="Moneda">
                <xsl:text>MXN</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="Total">
                <xsl:value-of select='format-number(Total, "#.00")' />
            </xsl:attribute>
            <xsl:attribute name="TipoDeComprobante">
                <xsl:value-of select="TipoComprobante" />
            </xsl:attribute>
            <xsl:attribute name="MetodoPago">
                <xsl:value-of select="MetodoPago" />
            </xsl:attribute>
            <xsl:attribute name="LugarExpedicion">
                <xsl:value-of select="lugarExpedicion" />
            </xsl:attribute>

            <xsl:apply-templates select="Emisor"/>
            <xsl:apply-templates select="Receptor"/>

            <cfdi:Conceptos>
                <xsl:apply-templates select="Conceptos"/>
            </cfdi:Conceptos>
            <xsl:apply-templates select="Impuestos"/>
        </cfdi:Comprobante>

    </xsl:template>

</xsl:stylesheet>
