<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cfdi="http://www.sat.gob.mx/cfd/3">
    <xsl:output method="xml" encoding="UTF-8"/>

    <xsl:template match="/data/Emisor">
        <cfdi:Emisor>
            <xsl:attribute name="Rfc">
                <xsl:value-of select="Rfc" />
            </xsl:attribute>
            <xsl:attribute name="Nombre">
                <xsl:value-of select="Nombre" />
            </xsl:attribute>
            <xsl:attribute name="RegimenFiscal">
                <xsl:text>601</xsl:text>
            </xsl:attribute>
        </cfdi:Emisor>
    </xsl:template>

    <xsl:template match="/data/Receptor">
        <cfdi:Receptor>
            <xsl:attribute name="Rfc">
                <xsl:value-of select="Rfc" />
            </xsl:attribute>
            <xsl:attribute name="Nombre">
                <xsl:value-of select="Nombre" />
            </xsl:attribute>
            <xsl:attribute name="UsoCFDI">
                <xsl:text>P01</xsl:text>
            </xsl:attribute>
        </cfdi:Receptor>
    </xsl:template>

    <xsl:template match="/data/Conceptos">
        <cfdi:Concepto>
            <xsl:attribute name="ClaveProdServ">
                <xsl:value-of select="ClaveProdServ" />
            </xsl:attribute>
            <xsl:attribute name="Cantidad">
                <xsl:text>1</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="ClaveUnidad">
                <xsl:text>ACT</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="Descripcion">
                <xsl:text>Pago de nómina</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="ValorUnitario">
                <xsl:value-of select='format-number(/data/nomina/subtotal, "#.00")' />
            </xsl:attribute>
            <xsl:attribute name="Importe">
                <xsl:value-of select='format-number(/data/nomina/subtotal, "#.00")' />
            </xsl:attribute>
            <xsl:attribute name="Descuento">
                <xsl:value-of select='format-number(/data/nomina/discount, "#.00")' />
            </xsl:attribute>
        </cfdi:Concepto>
    </xsl:template>

    <xsl:template match="/data">
        <cfdi:Comprobante xmlns:cfdi="http://www.sat.gob.mx/cfd/3"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns:nomina12="http://www.sat.gob.mx/nomina12" xsi:schemaLocation="http://www.sat.gob.mx/cfd/3 http://www.sat.gob.mx/sitio_internet/cfd/3/cfdv33.xsd http://www.sat.gob.mx/nomina12 http://www.sat.gob.mx/sitio_internet/cfd/nomina/nomina12.xsd" Version="3.3" Serie="RN">
            <xsl:attribute name="Folio">
                <xsl:value-of select="Folio" />
            </xsl:attribute>
            <xsl:attribute name="Fecha">
                <xsl:value-of select="Fecha" />
            </xsl:attribute>
            <xsl:attribute name="Sello" />
            <xsl:attribute name="FormaPago">
                <xsl:value-of select="99" />
            </xsl:attribute>
            <xsl:attribute name="NoCertificado" />
            <xsl:attribute name="Certificado" />
            <xsl:attribute name="SubTotal">
                <xsl:value-of select='format-number(nomina/subtotal, "#.00")' />
            </xsl:attribute>
            <xsl:attribute name="Descuento">
                <xsl:value-of select='format-number(nomina/discount, "#.00")' />
            </xsl:attribute>
            <xsl:attribute name="Moneda">
                <xsl:text>MXN</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="Total">
                <xsl:value-of select='format-number(nomina/total, "#.00")' />
            </xsl:attribute>
            <xsl:attribute name="TipoDeComprobante">
                <xsl:text>N</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="MetodoPago">
                <xsl:text>PUE</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="LugarExpedicion">
                <xsl:value-of select="76160" />
            </xsl:attribute>

            <xsl:apply-templates select="Emisor"/>
            <xsl:apply-templates select="Receptor"/>

            <cfdi:Conceptos>
                <xsl:apply-templates select="Conceptos"/>
            </cfdi:Conceptos>

            <cfdi:Complemento>
                <nomina12:Nomina Version="1.2">
                    <xsl:attribute name="TipoNomina">
                        <xsl:value-of select="nomina/tipoNomina" />
                    </xsl:attribute>
                    <xsl:attribute name="FechaPago">
                        <xsl:value-of select="nomina/FechaPago" />
                    </xsl:attribute>
                    <xsl:attribute name="FechaInicialPago">
                        <xsl:value-of select="nomina/FechaInicialPago" />
                    </xsl:attribute>
                    <xsl:attribute name="FechaFinalPago">
                        <xsl:value-of select="nomina/FechaFinalPago" />
                    </xsl:attribute>
                    <xsl:attribute name="NumDiasPagados">
                        <xsl:value-of select="nomina/dias" />
                    </xsl:attribute>

                    <xsl:attribute name="TotalPercepciones">
                        <xsl:value-of select='format-number(nomina/subtotal, "#.00")' />
                    </xsl:attribute>
                    <xsl:attribute name="TotalDeducciones">
                        <xsl:value-of select="nomina/discount" />
                    </xsl:attribute>
                    
                    <nomina12:Emisor/>
                    <nomina12:Receptor TipoContrato="99">
                        <xsl:attribute name="Curp">
                            <xsl:value-of select="Receptor/curp" />
                        </xsl:attribute>
                        <xsl:attribute name="TipoRegimen">
                            <xsl:value-of select="Receptor/TipoRegimen" />
                        </xsl:attribute>
                        <xsl:attribute name="NumEmpleado">
                            <xsl:value-of select="Receptor/NumEmpleado" />
                        </xsl:attribute>
                        <xsl:attribute name="ClaveEntFed">
                            <xsl:value-of select="Receptor/ClaveEntFed" />
                        </xsl:attribute>
                        <xsl:attribute name="PeriodicidadPago">
                            <xsl:value-of select="nomina/periodicidad" />
                        </xsl:attribute>
                    </nomina12:Receptor>
                    <nomina12:Percepciones >
                        <xsl:attribute name="TotalSueldos">
                            <xsl:value-of select='format-number(nomina/subtotal, "#.00")' />
                        </xsl:attribute>
                        <xsl:attribute name="TotalGravado">
                            <xsl:value-of select='format-number(nomina/subtotal, "#.00")' />
                        </xsl:attribute>
                        <xsl:attribute name="TotalExento">
                            <xsl:text>0.00</xsl:text>
                        </xsl:attribute>

                        <nomina12:Percepcion TipoPercepcion="046" Clave="046" Concepto="Pago">
                            <xsl:attribute name="ImporteGravado">
                                <xsl:value-of select='format-number(nomina/subtotal, "#.00")' />
                            </xsl:attribute>
                            <xsl:attribute name="ImporteExento">
                                <xsl:text>0.00</xsl:text>
                            </xsl:attribute>
                        </nomina12:Percepcion>
                    </nomina12:Percepciones>
                    <nomina12:Deducciones>
                        <xsl:attribute name="TotalImpuestosRetenidos">
                            <xsl:value-of select="nomina/discount" />
                        </xsl:attribute>
                        <nomina12:Deduccion TipoDeduccion="002" Clave="201" Concepto="ISR">
                            <xsl:attribute name="Importe">
                                <xsl:value-of select='format-number(nomina/isr, "#.00")' />
                            </xsl:attribute>
                        </nomina12:Deduccion>
                        <nomina12:Deduccion TipoDeduccion="001" Clave="204" Concepto="IMSS">
                            <xsl:attribute name="Importe">
                                <xsl:value-of select='format-number(nomina/imss, "#.00")' />
                            </xsl:attribute>
                        </nomina12:Deduccion>
                        <nomina12:Deduccion TipoDeduccion="003" Clave="271" Concepto="Infonavit">
                            <xsl:attribute name="Importe">
                                <xsl:value-of select='format-number(nomina/infonavit, "#.00")' />
                            </xsl:attribute>
                        </nomina12:Deduccion>
                    </nomina12:Deducciones>
                </nomina12:Nomina>
            </cfdi:Complemento>
        </cfdi:Comprobante>

    </xsl:template>

</xsl:stylesheet>
