<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/*
Route::get('/', function () {
    return view('welcome');
});
*/

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

Route::get('/', 'Auth\LoginController@showLoginForm')->name('login');
Auth::routes();

Route::get('/preview-employees', 'AssimilatedController@previewAssimilatedEmployees');
Route::post('/preview-employees', 'AssimilatedController@loadPreviewEmployees');

Route::group(['middleware' => ['auth']], function () {
    Route::redirect('/', '/index')->name('logout');
    Route::get('/index', 'HomeController@get')->name('home');
    Route::post('/toggleMenu', 'HomeController@toggleMenu');

    Route::get('/client/requests', 'Requests\RequestController@index');
    Route::post('/client/requests/{id}/send-request', 'Requests\RequestController@sendRequest');
    Route::get('/client/requests/create', 'Requests\RequestController@create');
    Route::get('/client/requests/{id}/edit', 'Requests\RequestController@edit');
    Route::post('/client/requests/store', 'Requests\RequestController@store');
    Route::post('/client/requests/add-deposit', 'Requests\RequestDepositController@addDeposit');
    Route::post('/client/requests/remove-deposit/{id}', 'Requests\RequestDepositController@removeDeposit');
    
    Route::post('/client/requests/deposit/{id}/invoice', 'Requests\InvoiceController@showInvoice');
    Route::post('/client/requests/deposit/{id}/invoice/store', 'Requests\InvoiceController@storeInvoiceFromDeposit');
    Route::post('/client/requests/deposit/{id}/invoice/{conceptId}/destroy', 'Requests\InvoiceController@destroyInvoiceFromDeposit');

    Route::get('/client/requests/{id}/invoices', 'Requests\InvoiceController@show');
    Route::post('/client/requests/{id}/invoices/create', 'Requests\InvoiceController@create');
    Route::get('/client/requests/{id}/invoices/{invoiceId}/edit', 'Requests\InvoiceController@edit');
    Route::post('/client/requests/{id}/invoices/store', 'Requests\InvoiceController@store');
    Route::post('/client/requests/{id}/invoices/{invoiceId}/destroy', 'Requests\InvoiceController@destroy');
    Route::post('/client/requests/{id}/invoices/{invoiceId}/concepts/create', 'Requests\InvoiceConceptController@create');
    Route::post('/client/requests/{id}/invoices/{invoiceId}/concepts/{conceptId}/destroy', 'Requests\InvoiceConceptController@destroy');
    Route::get('/client/requests/{id}/scatter', 'Requests\ScatterController@show');
    Route::post('/client/requests/{id}/scatter/store', 'Requests\ScatterController@store');

    Route::get('/client/requests/{id}/summary', 'Requests\SummaryController@show');

    Route::get('/client/business', 'ClientBusiness\BusinessController@index');
    Route::get('/client/business/{id}/edit', 'ClientBusiness\BusinessController@edit');
    Route::get('/client/business/create', 'ClientBusiness\BusinessController@create');
    Route::post('/client/business/{id}/send', 'ClientBusiness\BusinessController@sendBusiness');
    Route::get('/client/business/{id}/employees', 'Employee\EmployeeController@index');
    Route::get('/client/business/{id}/employees/create', 'Employee\EmployeeController@create');
    Route::post('/client/business/{id}/employees/store', 'Employee\EmployeeController@store');
    Route::get('/client/business/{id}/employees/{employeeId}/edit', 'Employee\EmployeeController@edit');
    Route::post('/client/business/{id}/employees/{employeeId}/send', 'Employee\EmployeeController@send');
    Route::post('/client/business/store', 'ClientBusiness\BusinessController@store');
    Route::get('/client/business/{id}/download-files', 'ClientBusiness\DownloadController@downloadFiles');
    Route::get('/client/business/{id}/download-employees', 'Employee\EmployeeController@downloadTemplate');

    Route::get('/client/employees', 'ClientBusiness\EmployeeController@index');
    Route::get('/client/employees/{id}/edit', 'ClientBusiness\EmployeeController@edit');
    Route::get('/client/employees/create', 'ClientBusiness\EmployeeController@create');
    Route::post('/client/employees/store', 'ClientBusiness\EmployeeController@store');
    Route::post('/client/employees/{id}/send', 'ClientBusiness\EmployeeController@send');

    Route::get('/requests/scatters', 'AdminRequests\RequestController@index');
    Route::post('/requests/scatters/{id}', 'AdminRequests\RequestController@command');
    Route::get('/requests/scatters/{id}/download', 'AdminRequests\RequestController@download');
    Route::get('/requests/scatters/{id}/scatter', 'AdminRequests\RequestController@downloadScatter');
    Route::get('/requests/scatters/{id}/approve', 'AdminRequests\RequestController@approve');
    Route::get('/requests/scatters/{id}/reject', 'AdminRequests\RequestController@reject');
    Route::get('/requests/scatters/{id}/show', 'AdminRequests\RequestController@show');

    Route::get('/requests/scatters/{id}/create', 'AdminRequests\PayrollController@create');
    Route::post('/requests/scatters/{id}/save', 'AdminRequests\PayrollController@save');
    Route::get('/requests/scatters/{id}/preview-payroll', 'AdminRequests\PayrollController@preview');
    Route::post('/requests/scatters/{id}/calc-payroll', 'AdminRequests\PayrollController@calcPayroll');
    Route::post('/requests/scatters/{id}/create-payrolls', 'AdminRequests\PayrollController@createPayrolls');
    Route::post('/requests/scatters/{id}/search', 'AdminRequests\PayrollController@createPayrolls');
    Route::get('/requests/scatters/{id}/create-payrolls', 'AdminRequests\PayrollController@createPayrolls');
    Route::get('/requests/scatters/{code}/payrolls', 'AdminRequests\PayrollController@listPayrolls');
    Route::get('/requests/scatters/{id}/receipt', 'AdminRequests\PayrollController@editReceipt');    
    Route::post('/requests/scatters/{id}/save-receipt', 'AdminRequests\PayrollController@saveReceipt');
    Route::post('/requests/scatters/{id}/cancel', 'AdminRequests\PayrollController@cancel');
    Route::post('/requests/scatters/{id}/remove-reduction', 'AdminRequests\WorkerReductionController@destroy');

    Route::post('/requests/scatters/{id}/stamp', 'AdminRequests\StampController@stampPayroll');
    Route::post('/requests/scatters/{id}/package', 'AdminRequests\DownloadController@packagePayroll');

    Route::get('/requests/approved-scatters', 'AdminRequests\ApprovedRequestController@index');
    Route::post('/requests/approved-scatters/export-as', 'AdminRequests\ApprovedRequestController@exportAs');
    Route::post('/requests/scatters/{id}/invoice/store', 'AdminRequests\ApprovedRequestController@store');
    Route::post('/requests/scatters/{id}/voucher/store', 'AdminRequests\ApprovedRequestController@storeVoucher');
    Route::post('/requests/scatters/{id}/voucher/{file}/remove', 'AdminRequests\ApprovedRequestController@removeVoucher');
    Route::post('/requests/scatters/{id}/invoice/{invoiceId}/destroy', 'AdminRequests\ApprovedRequestController@destroy');
    Route::get('/requests/scatters/{id}/invoice/download', 'AdminRequests\ApprovedRequestController@downloadInvoices');

    Route::post('/requests/scatters/{id}/store-voucher', 'AdminRequests\RequestVoucherController@store');
    Route::post('/requests/scatters/{id}/edit-voucher', 'AdminRequests\RequestVoucherController@edit');
    Route::post('/requests/scatters/{id}/destroy-voucher', 'AdminRequests\RequestVoucherController@destroy');
    Route::post('/requests/scatters/{id}/voucher/download/employeeScatter', 'AdminRequests\RequestVoucherController@downloadEmployeeScatter');
    
    Route::post('/requests/scatters/{id}/approve-scatter-detail', 'AdminRequests\ScatterDetailController@approve');
    Route::post('/requests/scatters/{id}/approve-scatter-details', 'AdminRequests\ScatterDetailController@approveAll');

    Route::get('/requests/business', 'AdminRequests\BusinessController@index');
    Route::get('/requests/business/{id}/download', 'AdminRequests\BusinessController@download');
    Route::get('/requests/business/{id}/approve', 'AdminRequests\BusinessController@approve');
    Route::get('/requests/business/{id}/reject', 'AdminRequests\BusinessController@reject');

    Route::post('/requests/workers/{id}/command', 'AdminRequests\WorkerController@command');
    Route::get('/requests/workers', 'AdminRequests\WorkerController@index');
    Route::get('/requests/workers/{id}/edit', 'AdminRequests\WorkerController@edit');
    Route::get('/requests/workers/{id}/download', 'AdminRequests\WorkerController@download');
    Route::get('/requests/workers/{id}/approve', 'AdminRequests\WorkerController@approve');
    Route::get('/requests/workers/{id}/reject', 'AdminRequests\WorkerController@reject');

    Route::post('/requests/collaborators/{id}/command', 'AdminRequests\CollaboratorController@command');
    Route::get('/requests/collaborators', 'AdminRequests\CollaboratorController@index');
    Route::get('/requests/collaborators/{id}/edit', 'AdminRequests\CollaboratorController@edit');
    Route::get('/requests/collaborators/{id}/download', 'AdminRequests\CollaboratorController@download');
    Route::get('/requests/collaborators/{id}/approve', 'AdminRequests\CollaboratorController@approve');
    Route::get('/requests/collaborators/{id}/reject', 'AdminRequests\CollaboratorController@reject');

    Route::get('/admin/external-business-clients', 'Partnership\BusinessController@index');
    Route::post('/admin/external-business-clients', 'Partnership\BusinessController@index');
    Route::get('/admin/external-business-clients/create', 'Partnership\BusinessController@create');
    Route::get('/admin/external-business-clients/{id}/edit', 'Partnership\BusinessController@edit');
    Route::post('/admin/external-business-clients/store', 'Partnership\BusinessController@store');
    Route::post('/admin/external-business-clients/destroy', 'Partnership\BusinessController@destroy');

    Route::post('/admin/partnerships', 'Partnership\PartnershipController@index');
    Route::get('/admin/partnerships', 'Partnership\PartnershipController@index');
    Route::get('/admin/partnerships/create', 'Partnership\PartnershipController@create');
    Route::get('/admin/partnerships/{id}/edit', 'Partnership\PartnershipController@edit');
    Route::get('/admin/partnerships/{id}/edit/{conceptTab}', 'Partnership\PartnershipController@editTab');
    Route::post('/admin/partnerships/store', 'Partnership\PartnershipController@store');
    Route::post('/admin/partnerships/destroy', 'Partnership\PartnershipController@destroy');

    Route::get('/admin/partnership-contacts/create/{id}', 'Partnership\PartnershipContactController@create');
    Route::get('/admin/partnership-contacts/{id}/edit', 'Partnership\PartnershipContactController@edit');
    Route::post('/admin/partnership-contacts/store', 'Partnership\PartnershipContactController@store');
    Route::post('/admin/partnership-contacts/destroy', 'Partnership\PartnershipContactController@destroy');

    Route::get('/admin/partnership-contacts/create-user/{id}', 'Auth\UserController@createUserFromContact');
    Route::get('/admin/partnership-contacts/{id}/edit-contact-user', 'Auth\UserController@editContactUser');

    Route::get('/admin/partnership-concepts/create/{id}/{clientId}', 'Partnership\PartnershipConceptController@create');
    Route::get('/admin/partnership-concepts/{id}/edit', 'Partnership\PartnershipConceptController@edit');
    Route::post('/admin/partnership-concepts/store', 'Partnership\PartnershipConceptController@store');
    Route::post('/admin/partnership-concepts/{id}/destroy', 'Partnership\PartnershipConceptController@destroy');
    Route::post('/admin/partnership-concepts/{id}/active/{clientId}', 'Partnership\PartnershipConceptController@active');
    Route::post('/admin/partnership-concepts/{id}/desactive/{clientId}', 'Partnership\PartnershipConceptController@desactive');

    Route::get('/payroll/assimilated-employees', 'AssimilatedController@index');
    Route::post('/payroll/assimilated-employees', 'AssimilatedController@command');
    Route::get('/payroll/assimilated-employees/create', 'AssimilatedController@create');
    Route::post('/payroll/assimilated-employees/{importCode}', 'AssimilatedController@receiptCommand');
    Route::get('/payroll/assimilated-employees/{importCode}', 'AssimilatedController@show');
    Route::get('/payroll/assimilated-employees/{id}/edit', 'AssimilatedController@editReceipt');
    
    Route::get('/payroll/assimilated/receipt/{id}/edit', 'Assimilated\ReceiptController@edit');
    Route::post('/payroll/assimilated/receipt', 'Assimilated\ReceiptController@store');
    Route::post('/payroll/assimilated/stamp/{importCode}', 'Assimilated\StampController@stampPayroll');
    Route::post('/payroll/assimilated/{id}/cancel', 'Assimilated\StampController@cancel');
    Route::post('/payroll/assimilated/package/{importCode}', 'Assimilated\DownloadController@packagePayroll');

    Route::get('/tax-documents/download-receipts', 'Bills\DownloadPayrollController@index');
    Route::post('/tax-documents/download-receipts', 'Bills\DownloadPayrollController@index');
    Route::post('/tax-documents/download-receipts/export', 'Bills\DownloadPayrollController@export');

    Route::get('/invoices/{id}/xml', 'DownloadController@downloadXML');
    Route::get('/invoices/{id}/pdf', 'DownloadController@downloadPDF');
    Route::get('/receipts', 'DownloadController@downloadReceipt');
    Route::get('/sys/{id}/xml', 'DownloadController@downloadSysXML');
    Route::get('/sys/{id}/pdf', 'DownloadController@downloadSysPDF');
    
    Route::post('/admin/internal-business-clients', 'InternalClient\BusinessClientController@index');
    Route::get('/admin/internal-business-clients', 'InternalClient\BusinessClientController@index');
    Route::get('/admin/internal-business-clients/create', 'InternalClient\BusinessClientController@create');
    Route::get('/admin/internal-business-clients/{id}/edit', 'InternalClient\BusinessClientController@edit');
    Route::post('/admin/internal-business-clients/store', 'InternalClient\BusinessClientController@store');
    Route::post('/admin/internal-business-clients/destroy', 'InternalClient\BusinessClientController@destroy');

    Route::get('/admin/business-concepts/create/{id}', 'InternalClient\BusinessClientConceptController@create');
    Route::get('/admin/business-concepts/{id}/edit', 'InternalClient\BusinessClientConceptController@edit');
    Route::post('/admin/business-concepts/store', 'InternalClient\BusinessClientConceptController@store');
    Route::post('/admin/business-concepts/destroy', 'InternalClient\BusinessClientConceptController@destroy');
    
    Route::get('/admin/business-branches/create/{id}', 'InternalClient\BusinessClientBranchController@create');
    Route::get('/admin/business-branches/{id}/edit', 'InternalClient\BusinessClientBranchController@edit');
    Route::post('/admin/business-branches/store', 'InternalClient\BusinessClientBranchController@store');
    Route::post('/admin/business-branches/destroy', 'InternalClient\BusinessClientBranchController@destroy');

    Route::post('/admin/employees', 'EmployeeController@command');
    Route::get('/admin/employees', 'EmployeeController@index');
    Route::get('/admin/employees/{id}/edit', 'EmployeeController@edit');
    Route::post('/admin/employees/{id}/store', 'EmployeeController@storeEmployee');
    Route::post('/admin/employees/{id}/change-partnership', 'EmployeeController@changePartnership');
    Route::get('/admin/employees/create', 'EmployeeController@create');
    Route::get('/admin/employees/{id}/external-business-export', 'EmployeeController@exportFromExternalBusiness');

    Route::post('/admin/users', 'Auth\UserController@command');
    Route::get('/admin/users', 'Auth\UserController@index');
    Route::get('/admin/users/{id}/edit', 'Auth\UserController@edit');
    Route::get('/admin/users/create', 'Auth\UserController@create');

    Route::post('/admin/isr-periods', 'ISRPeriodController@command');
    Route::get('/admin/isr-periods', 'ISRPeriodController@index');
    Route::get('/admin/isr-periods/{id}/edit', 'ISRPeriodController@edit');
    Route::get('/admin/isr-periods/create', 'ISRPeriodController@create');

    Route::post('/tax-documents/invoices', 'Bills\InvoiceController@command');
    Route::post('/tax-documents/invoices/list', 'Bills\InvoiceController@index');
    Route::get('/tax-documents/invoices', 'Bills\InvoiceController@index');
    Route::get('/tax-documents/invoices/create', 'Bills\InvoiceController@create');
    Route::get('/tax-documents/invoices/{id}/edit', 'Bills\InvoiceController@edit');
    Route::get('/tax-documents/invoices/concepts/{id}/destroy', 'Bills\InvoiceController@destroyConcept');
    Route::get('/tax-documents/invoices/payments/{id}/destroy', 'Bills\InvoiceController@destroyPayment');

    Route::post('/tax-documents/invoice-payments/{id}', 'Bills\InvoicePaymentController@command');
    Route::get('/tax-documents/invoice-payments/create/{id}', 'Bills\InvoicePaymentController@create');
    Route::get('/tax-documents/invoice-payments/{id}/edit', 'Bills\InvoicePaymentController@edit');
    Route::post('/tax-documents/invoice-payments/{id}/add-document', 'Bills\InvoicePaymentController@addDocument');
    Route::post('/tax-documents/invoice-payments/{id}/remove-document', 'Bills\InvoicePaymentController@removeDocument');

    Route::get('/tax-documents/invoices/{id}/xml', 'DownloadController@downloadInvoiceXML');
    Route::get('/tax-documents/invoices/{id}/pdf', 'DownloadController@downloadInvoicePDF');
    Route::get('/tax-documents/invoice-payments/{id}/xml', 'DownloadController@downloadInvoicePaymentXML');
    Route::get('/tax-documents/invoice-payments/{id}/pdf', 'DownloadController@downloadInvoicePaymentPDF');

    Route::get('/downloads', 'ProcessRequestController@loadPayrollDownloads');
    Route::get('/downloads/delete/{id}', 'ProcessRequestController@delete');
    Route::post('/downloads', 'ProcessRequestController@command');
    Route::get('/downloads/send-email/{id}', 'ProcessRequestController@sendEmail');

    Route::get('/stampeds', 'ProcessRequestController@loadStampedDownloads');
    Route::get('/sys-stampings', 'ProcessRequestController@loadSysStampedDownloads');
    Route::get('/sys-downloads', 'ProcessRequestController@loadSysPayrollDownloads');
    
});

Route::get('download/{code}', 'AssimilatedController@downloadPackage');
