<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

/*Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});*/

Route::post('/business-client', 'ModelController@saveBusinessClient');
Route::get('/business-client/list', 'ModelController@listBusinessClient');
Route::post('/business-client/cancel', 'ModelController@cancelBusinessClient');

Route::post('/branch', 'ModelController@saveBranch');
Route::get('/branch/list', 'ModelController@listBranchs');
Route::post('/branch/delete', 'ModelController@deleteBranch');

Route::post('/department', 'ModelController@saveDepartment');
Route::get('/department/list', 'ModelController@listDepartments');
Route::post('/department/delete', 'ModelController@deleteDepartment');

Route::post('/period', 'ModelController@savePeriod');
Route::get('/period/list', 'ModelController@listPeriods');
Route::post('/period/delete', 'ModelController@deletePeriod');

Route::post('/payroll', 'ModelController@savePayroll');
Route::get('/payroll/list', 'ModelController@listPayrolls');
Route::post('/payroll/cancel', 'ModelController@cancelPayroll');

Route::post('/payroll-receipt', 'ModelController@savePayrollReceipt');
Route::get('/payroll-receipt/list', 'ModelController@listPayrollReceipts');
Route::post('/payroll-receipt/cancel', 'ModelController@cancelPayrollReceipt');

Route::post('/import-employees', 'ModelController@importEmployees');
Route::post('/import-employee-accounts', 'ModelController@importEmployeeAccounts');
Route::get('/employees/list', 'ModelController@listEmployees');

Route::get('/log/{fileName}', 'ModelController@showLog');
Route::get('/count-bills/{strFrom}/{strTo}', 'ModelController@countBills');

Route::post('/configcode', 'ModelController@saveConfigCode');
Route::get('/configcode/list', 'ModelController@listConfigCodes');

Route::post('/processRequest', 'ModelController@saveProcessRequest');
Route::get('/processRequest/list', 'ModelController@listProcessRequest');

Route::post('/banks', 'ModelController@saveBank');
Route::get('/banks/list', 'ModelController@listBanks');
Route::post('/banks/delete', 'ModelController@deleteBank');

Route::get('/process-request/list', 'ProcessRequestController@list');
