<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Trabajadores en espera
            @endslot
        @endcomponent
        <form action="/admin/business" method="POST" class="container-fluid">
            {{ csrf_field() }}
            @include('components.messages')
            <table class="table border">
                <thead class="thead-light">
                    <tr>
                        <th scope="col">Consorcio</th>
                        <th scope="col">Tipo de empleado</th>
                        <th scope="col">Nombre</th>
                        <th scope="col">RFC</th>
                        <th scope="col">Documentos</th>
                        <th scope="col">Estado</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($data as $i)
                    <tr>
                        <td>{{ $i->partnership->code }}</td>
                        <td>{{ $i->getType() }}</td>
                        <td><a href="/requests/workers/{{ $i->id }}/edit">{{ $i->getFullName() }}</a></td>
                        <td>{{ $i->rfc }}</td>
                        <td><a href="/requests/workers/{{ $i->id }}/download">Descargar</a></td>
                        <td class="{{ $i->status == 'F' ? 'text-danger' : '' }}">{{ $i->status == 'F' ? 'Rechazado' : 'Pendiente' }}</td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="thead-light">
                    <tr>
                        <th scope="col" colspan="7">
                            <div class="btn-toolbar d-flex justify-content-end" role="toolbar">
                                <div class="btn-group" role="group">
                                    @foreach ($pages as $i)
                                        <button name="action" value="search-page" type="submit" class="btn btn-secondary {{ $i === $page ? 'active' : '' }}"
                                            onclick="$('#page-index').val({{ $i }})">{{ $i + 1 }}</button>
                                    @endforeach
                                    <input type="hidden" id="page-index" name="page-index" value="{{ $page }}">
                                </div>
                            </div>
                        </th>
                    </tr>
                </tfoot>
            </table>
        </form>
        @include('components.footer')
        <script src="/js/master-detail.js"></script>
    </body>
</html>
