<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                solicitudes en espera
            @endslot
        @endcomponent
        <form action="/admin/requests" method="POST" class="container-fluid">
            {{ csrf_field() }}
            @include('components.messages')
            <table class="table border">
                <thead class="thead-light">
                    <tr>
                        <th scope="col"><input id="select-all" type="checkbox"></th>
                        <th scope="col">Dispersión</th>
                        <th scope="col">Consorcio</th>
                        <th scope="col">Fecha de solicitud</th>
                        <th scope="col">Total</th>
                        <th scope="col">Operación</th>
                        <th scope="col">Solicitado</th>
                        <th scope="col">Facturación</th>
                        <th scope="col">Banco</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($requests as $i)
                    <tr>
                        <th>
                            <input type="checkbox" name="selected[]" value="{{ $i->id }}">
                        </th>
                        <td><a href="/requests/scatters/{{ $i->id }}/show">{{ $i->code }}</a></td>
                        <td>{{ $i->businessClient->partnership->code }}</td>
                        <td>{{ $i->released_at->format('Y-m-d H:m') }}</td>
                        <td>{{ '$ ' . number_format($i->total, 2) }}</td>
                        <td>{{ '$ ' . number_format($i->operation, 2) }}</td>
                        <td>{{ '$ ' . number_format($i->getRequested(), 2) }}</td>
                        <td class="{{ (!$i->fac_status ? 'text-secondary' : ($i->fac_status == 'F' ? 'text-danger' : 'text-success')) }}">{{ (!$i->fac_status ? 'Pendiente' : ($i->fac_status == 'F' ? 'Rechazado' : 'Aprobado')) }}</td>
                        <td class="{{ (!$i->bank_status ? 'text-secondary' : ($i->bank_status == 'F' ? 'text-danger' : 'text-success')) }}">{{ (!$i->bank_status ? 'Pendiente' : ($i->bank_status == 'F' ? 'Rechazado' : 'Aprobado')) }}</td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="thead-light">
                    <tr>
                        <th scope="col" colspan="9">
                            <div class="btn-toolbar d-flex justify-content-end" role="toolbar">
                                <div class="btn-group" role="group">
                                    @foreach ($pages as $i)
                                        <button name="action" value="search-page" type="submit" class="btn btn-secondary {{ $i === $page ? 'active' : '' }}"
                                            onclick="$('#page-index').val({{ $i }})">{{ $i + 1 }}</button>
                                    @endforeach
                                    <input type="hidden" id="page-index" name="page-index" value="{{ $page }}">
                                </div>
                            </div>
                        </th>
                    </tr>
                </tfoot>
            </table>
        </form>
        @include('components.footer')
        <script src="/js/master-detail.js"></script>
    </body>
</html>
