<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Solicitudes aprobadas
            @endslot
        @endcomponent
        <form action="/requests/approved-scatters" method="GET" class="container-fluid">
            {{ csrf_field() }}
            @include('components.messages')
            <table class="table border">
                <thead class="thead-light">
                    <tr>
                        <th scope="col" colspan="7">
                            @if ($userType == 'BI')
                            <button formmethod="POST" formaction="/requests/approved-scatters/export-as" value="{{ Session::token() }}" type="submit" data-toggle="modal" class="btn btn-sm btn-success back mr-5" name="action" value="export">
                                <i class="fa fa-file-excel mr-2"></i>Dispersión de nómina para AS
                            </button>
                            @endif
                        </th>
                        <th scope="col" colspan="4" class="text-right">
                            Número de solicitudes: <strong>{{ $total }}</strong>
                        </th>
                    </tr>
                    <tr>
                        <th scope="col" colspan=11">
                            <span class="d-flex">
                                <div class="form-group mr-4">
                                    <label for="partnership"><small class="form-text text-muted">Consorcio</small></label>
                                    <select name="partnership" class="custom-select" id="partnership">
                                        <option value="T" selected>Todos</option>
                                        @foreach ($partnerships as $partnership)
                                            <option value="{{ $partnership->id }}" {{ old('partnership', $partnershipId) == $partnership->id ? "selected":"" }}>{{ $partnership->name }}</option>    
                                        @endforeach
                                    </select>
                                </div>
                            </span>
                            <div class="d-flex">
                                <input type="search" name="filter" class="form-control" placeholder="Buscar ..." value="{{ old('filter', $filter) }}">
                                <button name="action" value="search" type="submit" class="btn btn-primary ml-2"><i class="fa fa-search"></i></button>
                            </div>
                        </th>
                    </tr>
                </thead>
                <thead class="thead-light">
                    <tr>
                        <th scope="col"><input id="select-all" type="checkbox"></th>
                        <th scope="col">Dispersión</th>
                        <th scope="col">Consorcio</th>
                        <th scope="col">Cliente</th>
                        <th scope="col">Fecha de solicitud</th>
                        <th scope="col">Total</th>
                        <th scope="col">Operación</th>
                        <th scope="col">AS</th>
                        <th scope="col">SYS</th>
                        <th scope="col">Factura</th>
                        <th scope="col">Comprobantes</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($requests as $i)
                    <tr>
                        <th>
                            <input type="checkbox" name="selected[]" value="{{ $i->id }}">
                        </th>
                        <td><a href="/requests/scatters/{{ $i->id }}/show">{{ $i->code }}</a></td>
                        <td>{{ $i->businessClient->partnership->code }}</td>
                        <td>{{ $i->businessClient->name }}</td>
                        <td>{{ $i->released_at->format('Y-m-d H:m') }}</td>
                        <td>{{ '$ ' . number_format($i->total, 2) }}</td>
                        <td>{{ '$ ' . number_format($i->operation, 2) }}</td>
                        <td>{{ $i->getPayrollWorker() ? '$ ' . number_format($i->getPayrollWorker()->as, 2) : '-' }}</td>
                        <td>{{ $i->getPayrollWorker() ? '$ ' . number_format($i->getPayrollWorker()->sys, 2) : '-' }}</td>
                        <td class="text-center"> 
                            @if ( count($i->invoices) > 0 )
                                <i class="fas fa-check text-success"></i>  
                            @endif
                        </td>
                        <td class="text-center"> 
                            @if ( $i->hasEmployeeFiles() )
                                <i class="fas fa-check text-success"></i>  
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="thead-light">
                    <tr>
                        <th scope="col" colspan="11">
                            <div class="btn-toolbar d-flex justify-content-end" role="toolbar">
                                <div class="btn-group" role="group">
                                    @foreach ($pages as $i)
                                        <button name="action" value="search-page" type="submit" class="btn btn-secondary {{ $i === $page ? 'active' : '' }}"
                                            onclick="$('#page-index').val({{ $i }})">{{ $i + 1 }}</button>
                                    @endforeach
                                    <input type="hidden" id="page-index" name="page-index" value="{{ $page }}">
                                </div>
                            </div>
                        </th>
                    </tr>
                </tfoot>
            </table>
        </form>
        @include('components.footer')
        <script src="/js/master-detail.js"></script>
    </body>
</html>
