<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                <strong>Folio: </strong>{{ $payroll->code }}, Fecha de importación: {{ $payroll->created_at->format('Y-m-d H:m') }}
            @endslot
        @endcomponent
        <form action="/payroll/assimilated-employees/{{ $payroll->import_code }}" method="POST" class="container-fluid">
            {{ csrf_field() }}
            @include('components.messages')
            <table class="table border rounded table-hover">
                <thead class="thead-light">
                    <tr>
                        <th scope="col" colspan="6">
                            <span>
                                @if ($payroll->request->HasStampReceipts()) 
                                    <a href="/requests/scatters/{{ $payroll->request_id }}/show" class="btn btn-sm btn-outline-secondary"><i class="fa fa-chevron-left mr-2"></i>Regresar</a>
                                @else
                                    <a href="/requests/scatters/{{ $payroll->request_id }}/create" class="btn btn-sm btn-outline-secondary"><i class="fa fa-chevron-left mr-2"></i>Regresar</a>
                                @endif

                                <button formmethod="POST" formaction="/requests/scatters/{{ $payroll->id }}/stamp" name="action" value="{{ Session::token() }}" type="submit" data-toggle="modal" class="btn btn-sm btn-primary back">
                                    <i class="fa fa-stamp mr-2"></i>Timbrar
                                </button>
                                <button formmethod="POST" formaction="/requests/scatters/{{ $payroll->id }}/package" name="action" value="{{ Session::token() }}" type="submit" data-toggle="modal" class="btn btn-sm btn-success back mr-5" value="package-receipts">
                                    <i class="fa fa-download mr-2"></i>Descargar
                                </button>
                                <button type="submit" data-toggle="modal" class="btn btn-sm btn-danger back" name="action" value="remove-receipt" disabled>
                                    <i class="fa fa-trash mr-2"></i>Remover recibos
                                </button>
                            </span>
                        </th>
                        <th scope="col" colspan="3" class="text-right">
                            Número de recibos: <strong>{{ $totalReceipts }}</strong>
                        </th>
                    </tr>
                    <tr>
                        <th scope="col" colspan="9">
                            <span class="d-flex">
                                <div class="form-group mr-4">
                                    <label for="client-name"><small class="form-text text-muted">Cliente</small></label>
                                    <input type="text" class="form-control" id="client-name" name="client-name" value="{{ $record->businessClient->name }}" disabled>
                                </div>
                                <div class="form-group mr-4">
                                    <label for="status"><small class="form-text text-muted">Timbrado</small></label>
                                    <select name="status" class="custom-select" id="status">
                                        <option value="A" {{ old('status', $statusId) == 'T' ? "selected":"" }}>Todos</option>
                                        <option value="D" {{ old('status', $statusId) == 'D' ? "selected":"" }}>Vigentes</option>
                                        <option value="M" {{ old('status', $statusId) == 'M' ? "selected":"" }}>No timbrados</option>
                                        <option value="C" {{ old('status', $statusId) == 'C' ? "selected":"" }}>Cancelados</option>
                                    </select>
                                </div>
                            </span>
                            <div class="d-flex">
                                <input type="search" name="filter" class="form-control" id="filter" placeholder="Buscar ..." value="{{ old('filter', $filter) }}">
                                <button formmethod="POST" formaction="/requests/scatters/{{ $payroll->request_id }}/search" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-primary ml-2">
                                    <i class="fa fa-search"></i>
                                </button>
                            </div>
                        </th>
                    </tr>
                </thead>
                <thead class="thead-light">
                    <tr>
                        <th scope="col" style="width: 50px;"><input id="select-all" type="checkbox"></th>
                        <th scope="col">Empleado</th>
                        <th scope="col" style="width: 200px;">RFC</th>
                        <th scope="col" style="width: 150px;">Dias laborados</th>
                        <th scope="col" style="width: 105px;">SYS</th>
                        <th scope="col" style="width: 105px;">AS</th>
                        <th scope="col" style="width: 150px;">Total Neto a pagar</th>
                        <th scope="col" style="width: 150px;">Timbrado</th>
                        <th scope="col" style="width: 100px;">Descargar</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($payrollReceipts as $i)
                    <tr>
                        <td> <input type="checkbox" name="selected[]" value="{{ $i->id }}"> </td>
                        <td> 
                            @if ($i->employee->type == 'W')
                            @if ($i->log && strlen($i->log) > 0)
                                <i class="fas fa-bug mr-2 text-danger"></i>
                            @endif
                            <a href="/requests/scatters/{{ $i->id }}/receipt">{{ $i->full_name }}</a>
                            @else
                                {{ $i->full_name }}
                            @endif
                        </td>
                        <td>{{ $i->rfc }}</td>
                        <td class="text-right">{{ $i->work_days }}</td>
                        <td class="text-right">{{ '$' . number_format($i->total, 2) }}</td>
                        <td class="text-right">{{ '$' . number_format($i->remaining_salary, 2) }} </td>
                        <td class="text-right">{{ '$' . number_format($i->employeeScatter->amount, 2) }}</td>
                        <td>
                            @if ($i->canceled_at)
                                <i class="text-danger mr-2">Cancelado</i>
                            @elseif ($i->isStamped())
                                <i class="text-success mr-2">Vigente</i>
                            @else
                                <i class="text-secondary mr-2">No timbrado</i>
                            @endif
                        </td>
                        <td>
                            @if ($i->employee->type == 'W')
                            <a href="/sys/{{ $i->id }}/xml" class="btn btn-sm btn-success" title="Formato XML"><i class="fa fa-file-code"></i></a>
                            <a href="/sys/{{ $i->id }}/pdf" target="_blank" class="btn btn-sm btn-danger" title="Formato pdf"><i class="fa fa-file-pdf"></i></a>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="thead-light">
                    <tr>
                        <th scope="col" colspan="9">
                            <div class="btn-toolbar d-flex justify-content-end" role="toolbar">
                                <div class="btn-group" role="group">
                                    @foreach ($pages as $i)
                                        <button formmethod="POST" formaction="/requests/scatters/{{ $payroll->request_id }}/create-payrolls?page={{$i}}" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-secondary {{ $i === $page ? 'active' : '' }}">{{ $i + 1 }}</button>
                                    @endforeach
                                </div>
                            </div>
                        </th>
                    </tr>
                </tfoot>
            </table>
        </form>
        @include('components.footer')
        <script src="/js/master-detail.js"></script>
    </body>
</html>
