<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
@include('components.head')
<body class="bg-light">
    @component('components.nav')
        @slot('title')
            Generar nómina para sueldos y salarios
        @endslot
    @endcomponent
    <form action="/payroll/assimilated-employees" method="POST" encType="multipart/form-data">
        @csrf
        <!-- Image and text -->
        <input type="hidden" id="id" name="id" value="{{ $payroll->id }}">
        <div class="container">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Datos del emisor</h5>
                </div>
                <div class="card-body">
                    <table class="table">
                        <thead>
                            <tr>
                            <th scope="col">Cliente</th>
                            <th scope="col">Solicitud</th>
                            <th scope="col">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                            <th scope="row">{{ $record->businessClient->name }}</th>
                            <td>{{ $record->id }}</td>
                            <td>{{ '$ ' . number_format($record->operation, 2) }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title">Fechas de pago de nómina</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="pay-date">Fecha de pago</label>
                                <input type="date" name="payed-at" class="form-control" id="payed-at" value="{{ old('payed-at', $payroll->payed_at->format('Y-m-d')) }}" required>
                                {!!$errors->first('payed-at', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="pay-init">Fecha inicial de pago</label>
                                <input type="date" name="pay-init" class="form-control" id="pay-init" value="{{ old('pay-init', $payroll->pay_init->format('Y-m-d'))}}" required>
                                {!!$errors->first('pay-init', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="pay-end">Fecha final de pago</label>
                                <input type="date" name="pay-end" class="form-control" id="pay-end" value="{{ old('pay-end', $payroll->pay_end->format('Y-m-d'))}}" required>
                                {!!$errors->first('pay-end', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="invoice-date">Fecha de emisión</label>
                                <input type="datetime-local" name="invoiced-at" class="form-control" id="invoiced-at" value="{{ old('invoiced-at', $payroll->invoiced_at->format('Y-m-d\TH:i')) }}" required>
                                {!!$errors->first('invoiced-at', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="pay-period">Periodo isr</label>
                                <select name="isr-period" class="custom-select" id="isr-period">
                                    @foreach ($isrPeriods as $period)
                                        <option value="{{ $period->id }}" {{ old("isr-period", $period->id) == $payroll->isr_period_id ? "selected":"" }} >{{ $period->name }}</option>    
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title">Otros datos</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="sdi">Salario minimo</label>
                                <input type="number" class="form-control" id="salary-min" name="salary-min" value="{{ old('salary-min', round($payroll->salary_min, 3)) }}" step="0.001" min="0" max="1000000"} required>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="sdi">UMI</label>
                                <input type="number" class="form-control" id="umi" name="umi" value="{{ old('umi', round($payroll->umi, 3)) }}" step="0.001" min="0" max="1000000"} required>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="sdi">Seguro infonavit</label>
                                <input type="number" class="form-control" id="insurance" name="insurance" value="{{ old('insurance', round($payroll->insurance, 3)) }}" step="0.01" min="0" max="10000"} required>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer d-flex justify-content-between">
                <a href="/requests/scatters/{{ $record->id }}/show" class="btn btn-sm btn-outline-secondary mr-2"><i class="fa fa-chevron-left mr-2"></i>Regresar</a>
                <span>
                    <button formmethod="POST" formaction="/requests/scatters/{{ $record->id }}/save" name="action" value="{{ Session::token() }}" type="submit" data-toggle="modal" class="btn btn-sm btn-primary back">
                        <i class="fa fa-file-import mr-2"></i>Vista previa
                    </button>
                </span>
            </div>
        </div>
    </form>
    <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
    <script src="/js/master-detail.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bs-custom-file-input/dist/bs-custom-file-input.js" crossorigin="anonymous"></script>
    <script type="text/javascript">
        $(function() {
            bsCustomFileInput.init();
        });
    </script>
</body>

</html>
