<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Recibo de nómina
            @endslot
        @endcomponent
        <form action="/requests/scatters/save-receipt" method="POST" class="container">
            @include('components.messages')
            {{ csrf_field() }}

            <div class="card">
                <div class="card-header">
                    <input type="hidden" id="id" name="id" value="{{ $payrollReceipt->id }}">
                    <div class="card-header">
                        <table width="100%">
                            <tr>
                                <td>
                                    <h5>Recibo {{ $payrollReceipt->code }}</h5>
                                </td>
                                <td>
                                    <div class="d-flex justify-content-end">
                                        <a href="/sys/{{ $payrollReceipt->id }}/xml" class="btn btn-sm btn-secondary mr-2" title="Formato XML"><i class="fa fa-file-code"></i>Descargar XML</a>
                                        <a href="/sys/{{ $payrollReceipt->id }}/pdf" target="_blank" class="btn btn-sm btn-secondary mr-2" title="Formato pdf"><i class="fa fa-file-pdf"></i>Descargar PDF</a>

                                        @if ($payrollReceipt->isStamped()) 
                                            <button formmethod="POST" formaction="/requests/scatters/{{ $payrollReceipt->id }}/cancel" name="action" value="{{ Session::token() }}" type="submit" data-toggle="modal" class="btn btn-sm btn-danger back" {{ $payrollReceipt->isStamped() && !$payrollReceipt->canceled_at ? '' : 'disabled' }}>
                                                <i class="fa fa-stamp mr-2"></i>Cancelar recibo
                                            </button>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="rfc">RFC</label>
                                <input class="form-control" id="rfc" name="rfc" maxlength="13" value="{{ old('rfc', $payrollReceipt->rfc) }}" autofocus required>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="curp">Curp</label>
                                <input class="form-control" id="curp" name="curp" maxlength="18" value="{{ old('curp', $payrollReceipt->curp) }}" maxlength="20" required>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-2">
                            <div class="form-group">
                                <label for="status">Estado</label>
                                <input class="form-control" id="status" name="status" disabled
                                    value="{{ $payrollReceipt->canceled_at ? 'Cancelado' : ($payrollReceipt->isStamped() ? 'Vigente' : 'Por timbrar') }}" >
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="isr-period">Periodo isr</label>
                                <select name="isr-period" class="custom-select" id="isr-period">
                                    @foreach ($isrPeriods as $period)
                                        <option value="{{ $period->id }}" {{ old("isr-period", $period->id) == $payrollReceipt->isr_period_id ? "selected":"" }} >{{ $period->name }}</option>    
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="num-empleado">No. Empleado</label>
                                <input class="form-control" id="num-empleado" name="num-empleado" value="{{ old('num-empleado', $payrollReceipt->employee->employee_number) }}" maxlength="10" disabled>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="name">Nombre</label>
                                <input class="form-control" id="name" name="name" value="{{ old('name', $payrollReceipt->first_name) }}" maxlength="50" required>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="last-name">Apellido paterno</label>
                                <input class="form-control" id="last-name" name="last-name" value="{{ old('last-name', $payrollReceipt->middle_name) }}" maxlength="50" required>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="last-name2">Apellido materno</label>
                                <input class="form-control" id="last-name2" name="last-name2" value="{{ old('last-name2', $payrollReceipt->last_name) }}" maxlength="50">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="folio">Dias laborados</label>
                                <input type="number" class="form-control" id="work_days" name="work_days" value="{{ old('work_days', $payrollReceipt->work_days) }}" step="1" max="31" required>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="serie">Salario diario</label>
                                <input class="form-control" id="isr" name="isr" value="{{ $payrollReceipt->salary_day }}" disabled>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="serie">Importe</label>
                                <input class="form-control" id="salary_total" name="salary_total" value="{{ number_format($payrollReceipt->salary_total, 2) }}" disabled>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="serie">Subsidio</label>
                                <input class="form-control" id="subsidy" name="subsidy" value="{{ number_format($payrollReceipt->subsidy, 2) }}" disabled>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="serie">Subsidio Causado</label>
                                <input class="form-control" id="subsidy" name="subsidy" value="{{ number_format($payrollReceipt->subsidy_c, 2) }}" disabled>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="serie">Total</label>
                                <input class="form-control" id="total" name="total" value="{{ number_format($payrollReceipt->subsidy + $payrollReceipt->salary_total, 2) }}" disabled>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="serie">ISR</label>
                                <input class="form-control" id="isr" name="isr" value="{{ number_format($payrollReceipt->isr, 2) }}" disabled>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="serie">Infonavit</label>
                                <input class="form-control" id="infonavit" name="infonavit" value="{{ number_format($payrollReceipt->infonavit, 2) }}" disabled>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="serie">IMSS</label>
                                <input class="form-control" id="imss" name="imss" value="{{ number_format($payrollReceipt->imss, 2) }}" disabled>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="serie">Total</label>
                                <input class="form-control" id="total" name="total" value="{{ number_format($payrollReceipt->total, 2) }}" disabled>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-12 mt-3">
                    @include('requests/payrolls/deductions')
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-12">
                            <div class="form-group">
                                <label for="serie">Error al timbrar</label>
                                <textarea class="form-control" id="log" rows="3" disabled>{{ $payrollReceipt->log }}</textarea>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-footer d-flex justify-content-between">
                    <a href="/requests/scatters/{{ $payrollReceipt->payrollWorker->request_id }}/create-payrolls" class="btn btn-sm btn-outline-secondary"><i class="fa fa-chevron-left mr-2"></i>Regresar</a>
                    <button formmethod="POST" formaction="/requests/scatters/{{ $payrollReceipt->id }}/save-receipt" name="action" value="{{ Session::token() }}" type="submit" data-toggle="modal" class="btn btn-sm btn-success ml-2">
                        <i class="fa fa-check mr-2"></i>Confirmar
                    </button>
                </div>
            </div>
        </form>
        @include('components.footer')
        
    </body>
</html>
