<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                <strong>Folio: </strong>{{ $record->code }}, Fecha de generación: {{ $record->created_at }}
            @endslot
        @endcomponent
        <form action="/payroll/assimilated-employees/0" method="POST" class="container-fluid">
            {{ csrf_field() }}
            @include('components.messages')
            <table class="table border rounded table-hover">
                <thead class="thead-light">
                    <tr>
                        <th scope="col" colspan="9">
                            <span>
                                {{--
                                <button formmethod="POST" formaction="/requests/scatters/{{ $record->id }}/create" name="action" value="{{ Session::token() }}" type="submit" data-toggle="modal" class="btn btn-sm btn-primary back">
                                    <i class="fa fa-stamp mr-2"></i>Generar nómina para sueldos y salarios
                                </button>
                                --}}
                                <a href="/requests/scatters/{{ $record->request_id }}/create-payrolls" class="btn btn-sm btn-outline-secondary mr-2"><i class="fa fa-chevron-left mr-2"></i>Regresar</a>

                                <button formmethod="POST" formaction="/requests/scatters/{{$record->request_id}}/create-payrolls" name="action" value="{{ Session::token() }}" type="submit" data-toggle="modal" class="btn btn-sm btn-success back">
                                    <i class="fa fa-money-check-alt mr-2"></i>Generar nómina
                                </button>
                            </span>
                        </th>
                        <th scope="col" colspan="3" class="text-right">
                            Número de empleados: <strong>{{ $totalEmployees }}</strong>
                        </th>
                    </tr>
                    <tr>
                        <th scope="col" colspan="12">
                            <div class="d-flex">
                                <input type="search" name="filter" class="form-control" id="filter" placeholder="Buscar ..." value="{{ old('filter', $filter) }}">
                                <button type="submit" name="action" class="btn btn-primary ml-2" value="search"><i class="fa fa-search"></i></button>
                            </div>
                        </th>
                    </tr>
                </thead>
                <thead class="thead-light">
                    <tr>
                        <th scope="col" style="width: 50px;"><input id="select-all" type="checkbox"></th>
                        <th scope="col" style="width: 200px;">RFC</th>
                        <th scope="col">Empleado</th>
                        <th scope="col" style="width: 150px;">Días laborados</th>
                        <th scope="col" style="width: 150px;">Salario diario</th>
                        <th scope="col" style="width: 105px;">Importe</th>
                        <th scope="col" style="width: 105px;">Subsidio</th>
                        <th scope="col" style="width: 105px;">Total</th>
                        <th scope="col" style="width: 105px;">ISR</th>
                        <th scope="col" style="width: 105px;">Infonavit</th>
                        <th scope="col" style="width: 105px;">IMSS</th>
                        <th scope="col" style="width: 105px;">Total a pagar</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($receipts as $i)
                    <tr>
                        <td> <input type="checkbox" name="selected[]" value="{{ $i->id }}"> </td>
                        <td>{{ $i->employee->rfc }}</td>
                        <td>{{ $i->employee->full_name }}</td>
                        <td>
                            <input type="number" class="form-control" name="work_days-{{ $i->employee_id }}" id="work_days-{{ $i->employee_id }}" value="{{ old(('work_days-' . $i->employee_id), $i->work_days) }}" step="1" min="0" max="31" disabled>
                        </td>
                        <td class="text-right">{{ '$' . number_format($i->salary_day, 2) }}</td>
                        <td class="text-right">{{ '$' . number_format($i->salary_total, 2) }}</td>
                        <td class="text-right">{{ '$' . number_format($i->subsidy, 2) }}</td>
                        <td class="text-right">{{ '$' . number_format($i->subsidy + $i->salary_total, 2) }}</td>
                        <td class="text-right">{{ '$' . number_format($i->isr, 2) }}</td>
                        <td class="text-right">{{ '$' . number_format($i->infonavit, 2) }}</td>
                        <td class="text-right">{{ '$' . number_format($i->imss, 2) }}</td>
                        <td class="text-right">{{ '$' . number_format($i->total, 2) }}</td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="thead-light">
                    <tr>
                        <th scope="col" colspan="12">
                            <div class="btn-toolbar d-flex justify-content-end" role="toolbar">
                                <div class="btn-group" role="group">
                                    @foreach ($pages as $i)
                                        <button name="action" value="search-page" type="submit" class="btn btn-secondary {{ $i === $page ? 'active' : '' }}"
                                            onclick="$('#page-index').val({{ $i }})">{{ $i + 1 }}</button>
                                    @endforeach
                                    <input type="hidden" id="page-index" name="page-index" value="{{ $page }}">
                                </div>
                            </div>
                        </th>
                    </tr>
                </tfoot>
            </table>
        </form>
        @include('components.footer')
        <script src="/js/master-detail.js"></script>
    </body>
</html>
