<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Validar colaborador
            @endslot
        @endcomponent
        <form action="/requests/collaborators/{{ $record->id }}/command" method="POST" action="save" class="container" encType="multipart/form-data">
            @csrf
            @include('components.messages')
            <div class="card-header">
                <h5>
                    @if ($record->id)
                    <input type="hidden" name="id" value="{{ $record->id }}">
                    @endif
                    <span>Nuevo colaborador</span>
                </h5>
            </div>
            
            @include('client/components/data-employee')

            <div class="card-footer d-flex justify-content-between">
                <a href="/requests/workers" class="btn btn-sm btn-secondary">
                    <i class="fas fa-chevron-left mr-2"></i>
                    <span>Regresar</span>
                </a>
                <span>
                    @if ($record->status == 'P')
                    <button type="button" data-toggle="modal" data-target="#emailModal" onclick="$('#email').val('{{ '' }}'); $('input[name=id-email]:hidden').val('{{ $record->id }}');"
                        class="btn btn-sm btn-danger mr-5" title="Enviar correo">
                        <i class="fa fa-trash mr-2"></i>Rechazar
                    </button>
                    {{-- <a href="/requests/collaborators/{{ $record->id }}/reject" class="btn btn-sm btn-danger ml-2 mr-4"><i class="fa fa-share-square mr-2"></i>Rechazar</a> --}}
                    <a href="/requests/collaborators/{{ $record->id }}/approve" class="btn btn-sm btn-success ml-2"><i class="fa fa-check mr-2"></i>Aprobar</a>
                    @endif
                </span>
            </div>
        </form>
        @include('components.footer')
    </body>
</html>
