<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Procesos de timbrado para SYS
            @endslot
        @endcomponent
        <form action="/downloads" method="POST" class="container-fluid">
            {{ csrf_field() }}
            @include('components.messages')
            <div class="">
                <table class="table border rounded table-hover">
                    <thead class="thead-light">
                        <tr>
                            <th scope="col">Folio</th>
                            <th scope="col">Solicitado por</th>
                            <th scope="col">Descripción</th>
                            <th scope="col">Progreso</th>
                            <th scope="col">Fecha de solicitud</th>
                            <th scope="col">Expira</th>
                            <th scope="col"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($process as $i) 
                        <tr>
                            <td><a href="/requests/scatters/{{ $i->getOptionValue('--payroll') }}/payrolls">{{ $i->getOptionValue('--payroll') }}</a></td>
                            <td>{{ $i->requestBy->name }}</td>
                            <td>{!! $i->description !!}</td>
                            <td>
                            @if ($i->status == 'P')
                                <div class="progress" style="width:100px">
                                    <div data-id="{{ $i->id }}" class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100" 
                                        style="width: {{ $i->progress }}%">{{ $i->progress }}%</div>
                                </div>
                            @else
                                <div class="progress" style="width:100px">
                                    <div class="progress-bar bg-success" role="progressbar" style="width: 100%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100">100%</div>
                                </div>
                            @endif
                                
                            </td>
                            <td>{{ $i->created_at->format('d/m/Y H:i') }}</td>
                            <td>{{ $i->expired_at->format('d/m/Y') }}</td>
                            <td>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                    <tfoot class="thead-light">
                        <tr>
                            <th scope="col" colspan="9">
                                <div class="btn-toolbar d-flex justify-content-end" role="toolbar">
                                    <div class="btn-group" role="group">
                                        @foreach ($pages as $i)
                                            <button name="action" value="search-page" type="submit" class="btn btn-secondary {{ $i === $page ? 'active' : '' }}"
                                                onclick="$('#page-index').val({{ $i }})">{{ $i + 1 }}</button>
                                        @endforeach
                                        <input type="hidden" id="page-index" name="page-index" value="{{ $page }}">
                                    </div>
                                </div>
                            </th>
                        </tr>
                    </tfoot>
                </table>

                @include('components.email')
            </div>
        </form>
        @include('components.footer')
        <script src="/js/download-update.js"></script>
    </body>
</html>
