<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
@include('components.head')
<body class="bg-light">
    <form action="/preview-employees" method="POST" encType="multipart/form-data">
        @csrf
        <!-- Image and text -->
        <div class="container">
            <div class="card mt-4">
                <div class="card-header">
                    <div class="mt-4 d-flex justify-content-between">
                        <h5 class="card-title">Cotización</h5>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="isr-period">Periodo isr</label>
                                <select name="isr-period" class="custom-select" id="isr-period" autofocus>
                                    @foreach ($periods as $period)
                                        <option value="{{ $period->id }}" {{ old("isr-period", $periodId) == $period->id ? "selected":"" }} >{{ $period->name }}</option>    
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="pay-period">Comisión</label>
                                <select name="comission" class="custom-select" id="pay-period">
                                    <option value="0" selected>0 %</option>
                                    <option value="1" {{ old('comission', $comission) === '1' ? 'selected' : '' }}>1 %</option>
                                    <option value="2" {{ old('comission', $comission) === '2' ? 'selected' : '' }}>2 %</option>
                                    <option value="3" {{ old('comission', $comission) === '3' ? 'selected' : '' }}>3 %</option>
                                    <option value="4" {{ old('comission', $comission) === '4' ? 'selected' : '' }}>4 %</option>
                                    <option value="5" {{ old('comission', $comission) === '5' ? 'selected' : '' }}>5 %</option>
                                    <option value="6" {{ old('comission', $comission) === '6' ? 'selected' : '' }}>6 %</option>
                                    <option value="7" {{ old('comission', $comission) === '7' ? 'selected' : '' }}>7 %</option>
                                    <option value="8" {{ old('comission', $comission) === '8' ? 'selected' : '' }}>8 %</option>
                                    <option value="9" {{ old('comission', $comission) === '9' ? 'selected' : '' }}>9 %</option>
                                    <option value="10" {{ old('comission', $comission) === '10' ? 'selected' : '' }}>10 %</option>
                                    <option value="11" {{ old('comission', $comission) === '11' ? 'selected' : '' }}>11 %</option>
                                    <option value="12" {{ old('comission', $comission) === '12' ? 'selected' : '' }}>12 %</option>
                                    <option value="13" {{ old('comission', $comission) === '13' ? 'selected' : '' }}>13 %</option>
                                    <option value="14" {{ old('comission', $comission) === '14' ? 'selected' : '' }}>14 %</option>
                                    <option value="15" {{ old('comission', $comission) === '15' ? 'selected' : '' }}>15 %</option>
                                    <option value="16" {{ old('comission', $comission) === '16' ? 'selected' : '' }}>16 %</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="pay-period">Monto neto a dispersar</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="inputGroupPrepend">$</span>
                                    </div>
                                    <input type="number" class="form-control" id="amount" name="amount" value="{{ old('amount', $amount) }}" step="0.01">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-2">
                            <label for="pay-period"></label>
                                <div class="input-group">
                            </label>
                            <div class="input-group">
                                <button name="action" value="load-preview-employees" type="submit" class="btn btn-primary ml-2"><i class="fa fa-file-import mr-2"></i>Calcular</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container">
            <table class="table border rounded table-hover">
                <thead class="thead-light">
                    <tr>
                        <th scope="col">Monto a dispersar</th>
                        <th scope="col" >ISR retenido</th>
                        <th scope="col" >Subtotal</th>
                        <th scope="col" >Comision {{ $comission }} %</th>
                        <th scope="col" >Total a depositar</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="text-left">{{ '$' . number_format($amount, 2) }}</td>
                        <td class="text-left">{{ '$' . number_format($isr, 2) }}</td>
                        <td class="text-left">{{ '$' . number_format($subtotal, 2) }}</td>
                        <td class="text-left">{{ '$' . number_format($comissionTotal, 2) }}</td>
                        <td class="text-left"><strong>{{ '$' . number_format($total, 2) }}</strong></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </form>
    <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
    <script src="/js/master-detail.js"></script>
</body>

</html>
