<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                <strong>Folio: </strong>{{ $payroll->import_code }}, Fecha de importación: {{ $payroll->created_at->format('Y-m-d H:m') }}
            @endslot
        @endcomponent
        <form action="/payroll/assimilated-employees/{{ $payroll->import_code }}" method="POST" class="container-fluid">
            {{ csrf_field() }}
            @include('components.messages')
            <table class="table border rounded table-hover">
                <thead class="thead-light">
                    <tr>
                        <th scope="col" colspan="7">
                            <span>
                                <button formmethod="POST" formaction="/payroll/assimilated/stamp/{{ $payroll->import_code }}" name="action" value="{{ Session::token() }}" type="submit" data-toggle="modal" class="btn btn-sm btn-primary back" {{ !$payroll->businessClient->hasFilesForStamp() ? 'disabled' : ''}}>
                                    <i class="fa fa-stamp mr-2"></i>Timbrar
                                </button>

                                <button formmethod="POST" formaction="/payroll/assimilated/package/{{ $payroll->import_code }}" name="action" value="{{ Session::token() }}" type="submit" data-toggle="modal" class="btn btn-sm btn-success back mr-5" value="package-receipts">
                                    <i class="fa fa-download mr-2"></i>Descargar
                                </button>
                                <button type="submit" data-toggle="modal" class="btn btn-sm btn-danger back" name="action" value="remove-receipt">
                                    <i class="fa fa-trash mr-2"></i>Remover recibos
                                </button>
                            </span>
                        </th>
                        <th scope="col" colspan="2" class="text-right">
                            Número de recibos: <strong>{{ $totalReceipts }}</strong>
                        </th>
                    </tr>
                    <tr>
                        <th scope="col" colspan="9">
                            <span class="d-flex">
                                <div class="form-group mr-4">
                                    <label for="client-name"><small class="form-text text-muted">Cliente</small></label>
                                    <input type="text" class="form-control" id="client-name" name="client-name" value="{{ $payroll->businessClient->name }}" disabled>
                                </div>
                                <div class="form-group mr-4">
                                    <label for="partnership"><small class="form-text text-muted">Consorcio</small></label>
                                    <select name="partnership" class="custom-select" id="partnership">
                                        @foreach ($partnerships as $partnership)
                                            <option value="{{ $partnership->code }}" {{ old('partnership', $partnershipCode) == $partnership->code ? "selected":"" }}>
                                                {{ $partnership->code }}-{{ $partnership->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group mr-4">
                                    <label for="status"><small class="form-text text-muted">Timbrado</small></label>
                                    <select name="status" class="custom-select" id="status">
                                        <option value="A" {{ old('status', $statusId) == 'T' ? "selected":"" }}>Todos</option>
                                        <option value="D" {{ old('status', $statusId) == 'D' ? "selected":"" }}>Vigentes</option>
                                        <option value="M" {{ old('status', $statusId) == 'M' ? "selected":"" }}>No timbrados</option>
                                        <option value="C" {{ old('status', $statusId) == 'C' ? "selected":"" }}>Cancelados</option>
                                    </select>
                                </div>
                            </span>
                            <div class="d-flex">
                                <input type="search" name="filter" class="form-control" id="filter" placeholder="Buscar ..." value="{{ old('filter', $filter) }}">
                                <button type="submit" name="action" class="btn btn-primary ml-2" value="search"><i class="fa fa-search"></i></button>
                            </div>
                        </th>
                    </tr>
                </thead>
                <thead class="thead-light">
                    <tr>
                        <th scope="col" style="width: 50px;"><input id="select-all" type="checkbox"></th>
                        <th scope="col" style="width: 150px;">Consorcio</th>
                        <th scope="col">Empleado</th>
                        <th scope="col" style="width: 200px;">RFC</th>
                        <th scope="col" style="width: 105px;">Total</th>
                        <th scope="col" style="width: 105px;">ISR</th>
                        <th scope="col" style="width: 150px;">Neto a pagar</th>
                        <th scope="col" style="width: 150px;">Timbrado</th>
                        <th scope="col" style="width: 100px;">Descargar</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($payrollReceipts as $i)
                    <tr>
                        <td> <input type="checkbox" name="selected[]" value="{{ $i->id }}"> </td>
                        <td>{{ $i->department }}</td>
                        <td> 
                            @if ($i->log && strlen($i->log) > 0)
                                <i class="fas fa-bug mr-2 text-danger"></i>
                            @endif
                            <a href="/payroll/assimilated/receipt/{{ $i->id }}/edit">{{ $i->getFullName() }}</a>
                        </td>
                        <td>{{ $i->rfc }}</td>
                        <td class="text-right">{{ '$' . number_format($i->subtotal, 2) }}</td>
                        <td class="text-right">{{ '$' . number_format($i->isr, 2) }}</td>
                        <td class="text-right">{{ '$' . number_format($i->total, 2) }}</td>
                        <td>
                            @if ($i->canceled_at)
                                <i class="text-danger mr-2">Cancelado</i>
                            @elseif ($i->isStamped())
                                <i class="text-success mr-2">Vigente</i>
                            @else
                                <i class="text-secondary mr-2">No timbrado</i>
                            @endif
                        </td>
                        <td>
                            <a href="/invoices/{{ $i->id }}/xml" class="btn btn-sm btn-success" title="Formato XML"><i class="fa fa-file-code"></i></a>
                            <a href="/invoices/{{ $i->id }}/pdf" target="_blank" class="btn btn-sm btn-danger" title="Formato pdf"><i class="fa fa-file-pdf"></i></a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="thead-light">
                    <tr>
                        <th scope="col" colspan="9">
                            <div class="btn-toolbar d-flex justify-content-end" role="toolbar">
                                <div class="btn-group" role="group">
                                    @foreach ($pages as $i)
                                        <button name="action" value="search-page" type="submit" class="btn btn-secondary {{ $i === $page ? 'active' : '' }}"
                                            onclick="$('#page-index').val({{ $i }})">{{ $i + 1 }}</button>
                                    @endforeach
                                    <input type="hidden" id="page-index" name="page-index" value="{{ $page }}">
                                </div>
                            </div>
                        </th>
                    </tr>
                </tfoot>
            </table>
        </form>
        @include('components.footer')
        <script src="/js/master-detail.js"></script>
    </body>
</html>
