<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Recibo de nómina
            @endslot
        @endcomponent
        <form action="/payroll/assimilated-employees/{{ $payrollReceipt->payroll->import_code }}" method="POST" class="container">
            @include('components.messages')
            {{ csrf_field() }}

            @if (!empty($invoice->id))
                <input type="hidden" name="id" value="{{$invoice->id}}">
            @endif
            <div class="card">
                <div class="card-header">
                    <input type="hidden" id="id" name="id" value="{{ $payrollReceipt->id }}">
                    <div class="card-header">
                        <table width="100%">
                            <tr>
                                <td>
                                    <h5>Recibo {{ $payrollReceipt->code }}</h5>
                                </td>
                                <td>
                                    <div class="d-flex justify-content-end">
                                        <a href="/invoices/{{ $payrollReceipt->id }}/xml" class="btn btn-sm btn-secondary mr-2" title="Formato XML"><i class="fa fa-file-code mr-2"></i>Descargar XML</a>
                                        <a href="/invoices/{{ $payrollReceipt->id }}/pdf" target="_blank" class="btn btn-sm btn-secondary mr-5" title="Formato pdf"><i class="fa fa-file-pdf mr-2"></i>Descargar PDF</a>

                                        <button formmethod="POST" formaction="/payroll/assimilated/{{ $payrollReceipt->id }}/cancel" name="action" value="{{ Session::token() }}" type="submit" data-toggle="modal" class="btn btn-sm btn-danger back"  value="cancel-stamp" {{ $payrollReceipt->isStamped() && !$payrollReceipt->canceled_at ? '' : 'disabled' }}>
                                            <i class="fa fa-stamp mr-2"></i>Cancelar recibo
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="serie">Cliente</label>
                                <input class="form-control" id="business" name="business" value="{{ $business->name }}" disabled>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-8">
                            <div class="form-group">
                                <label for="partnership">Consorcio</label>
                                <select name="partnership" class="custom-select" id="partnership" required disabled>
                                    @foreach ($partnerships as $partnership)
                                        <option value="{{ $partnership->id }}" {{ $partnership->code === $payrollReceipt->department ? "selected":"" }}>{{ $partnership->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="rfc">RFC</label>
                                <input class="form-control" id="rfc" name="rfc" maxlength="13" value="{{ old('rfc', $payrollReceipt->rfc) }}" autofocus required>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="curp">Curp</label>
                                <input class="form-control" id="curp" name="curp" maxlength="18" value="{{ old('curp', $payrollReceipt->curp) }}" maxlength="20" required>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="status">Estado</label>
                                <input class="form-control" id="status" name="status" disabled
                                    value="{{ $payrollReceipt->canceled_at ? 'Cancelado' : ($payrollReceipt->isStamped() ? 'Vigente' : 'Por timbrar') }}" >
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="num-empleado">No. Empleado</label>
                                <input class="form-control" id="num-empleado" name="num-empleado" value="{{ old('num-empleado', $payrollReceipt->num_empleado) }}" maxlength="10" required>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="name">Nombre</label>
                                <input class="form-control" id="name" name="name" value="{{ old('name', $payrollReceipt->name) }}" maxlength="50" required>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="last-name">Apellido paterno</label>
                                <input class="form-control" id="last-name" name="last-name" value="{{ old('last-name', $payrollReceipt->last_name) }}" maxlength="50" required>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="last-name2">Apellido materno</label>
                                <input class="form-control" id="last-name2" name="last-name2" value="{{ old('last-name2', $payrollReceipt->last_name2) }}" maxlength="50">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="folio">Neto a pagar</label>
                                <input type="number" class="form-control" id="total" name="total" value="{{ old('total', $payrollReceipt->total) }}" step="0.01" required {{ count($scatters) > 0 ? 'disabled' : '' }}>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="serie">ISR</label>
                                <input class="form-control" id="isr" name="isr" value="{{ $payrollReceipt->isr }}" disabled>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="serie">Total</label>
                                <input class="form-control" id="subtotal" name="subtotal" value="{{ $payrollReceipt->subtotal }}" disabled>
                            </div>
                        </div>                        
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-12">
                            <div class="form-group">
                                <label for="serie">Error al timbrar</label>
                                <textarea class="form-control" id="log" rows="3" disabled>{{ $payrollReceipt->log }}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-12 col-md-12">
                            <div id="div-business-clients" class="tab-pane fade show active">
                                <div class="border rounded">
                                    <table class="table table-sm table-striped table-hover">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>Solicitud</th>
                                                <th class="text-right">SYS</th>
                                                <th class="text-right">AS</th>
                                                <th class="text-right">Total</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($scatters as $scatter)
                                            <tr>
                                                <th scope="row">
                                                    <a href="/requests/scatters/{{ $scatter->employeeScatter->request_id }}/show">{{ $scatter->employeeScatter->request->code }}</a>
                                                </th>
                                                <td class="text-right">{{ '$' . number_format($scatter->employeeScatter->sys, 2) }}</td>
                                                <td class="text-right">{{ '$' . number_format($scatter->employeeScatter->as, 2) }}</td>
                                                <td class="text-right">{{ '$' . number_format($scatter->employeeScatter->amount, 2) }}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex justify-content-between">
                    <a href="/payroll/assimilated-employees/{{ $payrollReceipt->payroll->import_code }}" class="btn btn-sm btn-outline-secondary"><i class="fa fa-chevron-left mr-2"></i>Regresar</a>
                    
                    <button formmethod="POST" formaction="/payroll/assimilated/receipt" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-success ml-2"><i class="fa fa-check mr-2"></i>Confirmar</button>
                </div>
            </div>
        </form>
        @include('components.footer')
    </body>
</html>
