<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Nómina de asimilados
            @endslot
        @endcomponent
        <form action="/payroll/assimilated-employees" method="POST" class="container-fluid">
            {{ csrf_field() }}
            @include('components.messages')
            <table class="table border rounded table-hover">
                <thead class="thead-light">
                    <tr>
                        <th scope="col" colspan="5">
                            <span>
                                <a href="/payroll/assimilated-employees/create" class="btn btn-sm btn-primary back mr-5" role="button">
                                    <i class="fa fa-plus mr-2"></i>cargar nómina</a>
                                <button type="submit" data-toggle="modal" class="btn btn-sm btn-danger back" name="action" value="destroy">
                                    <i class="fa fa-trash mr-2"></i>Cancelar nómina
                                </button>
                            </span>
                        </th>
                        <th scope="col" colspan="2" class="text-right">
                            Número de nóminas: <strong>{{ $total }}</strong>
                        </th>
                    </tr>
                    <tr>
                        <th scope="col" colspan="7">
                            <span class="d-flex">
                                <div class="form-group mr-4">
                                    <label for="client"><small class="form-text text-muted">Cliente</small></label>
                                    <select name="client" class="custom-select" id="client">
                                        <option value="T" selected>Todos</option>
                                        @foreach ($clients as $client)
                                            <option value="{{ $client->id }}" {{ old('client', $clientId) == $client->id ? "selected":"" }}>{{ $client->name }}</option>    
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group mr-4">
                                    <label for="branch"><small class="form-text text-muted">Lugar de expedición</small></label>
                                    <select name="branch" class="custom-select" id="branch">                                         
                                    </select>
                                    <datalist id="available-expeditions" add-all>
                                        @foreach ($branches as $branch)
                                            <option data-client="{{ $branch->business_client_id }}" value="{{ $branch->id }}" {{ old('branch', $branchId) == $branch->id ? "selected":"" }}>{{ $branch->name }}</option>
                                        @endforeach
                                    </datalist>
                                </div>
                                <div class="form-group mr-2">
                                    <label for="imported-from"><small class="form-text text-muted">Importados desde</small></label>
                                    @if (isset($importedFrom))
                                        <input type="date" class="form-control" id="imported-from" name="imported-from" value="{{ $importedFrom->format('Y-m-d') }}">
                                    @else
                                        <input type="date" class="form-control" id="imported-from" name="imported-from">
                                    @endif
                                </div>
                                <div class="form-group mr-2">
                                    <label for="imported-to"><small class="form-text text-muted">Importados hasta</small></label>
                                    @if (isset($importedTo))
                                        <input type="date" class="form-control" id="imported-to" name="imported-to" value="{{ $importedTo->format('Y-m-d') }}">
                                    @else
                                    <input type="date" class="form-control" id="imported-to" name="imported-to">
                                    @endif
                                </div>
                                <div class="form-group mr-4">
                                    <label for="created-by"><small class="form-text text-muted">Creado por</small></label>
                                    <select name="created-by" class="custom-select" id="created-by">
                                    @foreach ($users as $user)
                                        <option value="{{ $user->id }}" {{ old('created-by', $userId) == $user->id ? 'selected':'' }}>{{ $user->user_name }}</option>
                                    @endforeach
                                    </select>
                                </div>
                            </span>
                            <span class="d-flex">
                                <input type="search" name="filter" class="form-control" placeholder="Buscar ..." value="{{ old('filter', $filter) }}">
                                <button name="action" value="search" type="submit" class="btn btn-primary ml-2"><i class="fa fa-search"></i></button>
                            </span>
                        </th>
                    </tr>
                </thead>
                <thead class="thead-light">
                    <tr>
                        <th scope="col"><input id="select-all" type="checkbox"></th>
                        <th scope="col">Folio</th>
                        <th scope="col">Cliente</th>
                        <th scope="col">Lugar de expedición</th>
                        <th scope="col">Fecha de importación</th>
                        <th scope="col">Perido ISR</th>
                        <th scope="col">Estatus</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($payrolls as $i)
                    <tr>
                        <th>
                            <input type="checkbox" name="selected[]" value="{{ $i->id }}" {{ $i->hasStampedReceipts() ? 'disabled' : '' }}>
                        </th>
                        <td><a href="/payroll/assimilated-employees/{{ $i->import_code }}">{{ $i->import_code }}</a></td>
                        <td>{{ $i->name }}</td>
                        <td>{{ $i->businessBranch->name }}</td>
                        <td>{{ $i->created_at->format('Y-m-d H:m') }}</td>
                        <td>{{ $i->isrPeriod->name }}</td>
                        <td>{{ $i->calcStatus() }}</td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="thead-light">
                    <tr>
                        <th scope="col" colspan="7">
                            <div class="btn-toolbar d-flex justify-content-end" role="toolbar">
                                <div class="btn-group" role="group">
                                    @foreach ($pages as $i)
                                        <a href="?page={{$i . (empty($filter) ? '' : '&filter=' . $filter) }}" class="btn btn-secondary {{ $i === $page ? 'active' : '' }}">{{ $i + 1 }}</a>
                                    @endforeach
                                </div>
                            </div>
                        </th>
                    </tr>
                </tfoot>
            </table>
        </form>
        @include('components.footer')
        <script src="/js/master-detail.js"></script>
    </body>
</html>
