<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
@include('components.head')
<body class="bg-light">
    @component('components.nav')
        @slot('title')
            Cargar nómina para asimilados
        @endslot
    @endcomponent
    <form action="/payroll/assimilated-employees" method="POST" encType="multipart/form-data">
        @csrf
        <!-- Image and text -->
        <div class="container">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Datos del emisor</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="client">Cliente</label>
                                <select name="client" class="custom-select" id="client">
                                    @foreach ($clients as $client)
                                        <option value="{{ $client->id }}" {{ old("client") == $client->id ? "selected":"" }}>{{ $client->name }}</option>    
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-8">
                            <div class="form-group">
                                <label for="branch">Lugar de expedición</label>
                                <select name="branch" class="custom-select" id="branch">
                                    
                                </select>
                                <datalist id="available-expeditions">
                                    @foreach ($branches as $branch)
                                        <option data-client="{{ $branch->business_client_id }}" value="{{ $branch->id }}" {{ old("branch") == $branch->id ? "selected":"" }}>{{ $branch->name }}</option>    
                                    @endforeach
                                </datalist>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title">Fechas de pago de nómina</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="pay-date">Fecha de pago</label>
                                <input type="date" name="pay_date" class="form-control" id="pay-date" value="{{ old('pay_date', $now->format('Y-m-d')) }}" required>
                                {!!$errors->first('pay_date', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="pay-init">Fecha inicial de pago</label>
                                <input type="date" name="pay_init" class="form-control" id="pay-init" value="{{ old('pay_init', $startDay->format('Y-m-d'))}}" required>
                                {!!$errors->first('pay_init', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="pay-end">Fecha final de pago</label>
                                <input type="date" name="pay_end" class="form-control" id="pay-end" value="{{ old('pay_end', $endDay->format('Y-m-d'))}}" required>
                                {!!$errors->first('pay_end', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title">Otros datos</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="invoice-date">Fecha de emisión</label>
                                <input type="datetime-local" name="invoice_date" class="form-control" id="invoice-date" 
                                    value="{{ old('invoice_date', $now->format('Y-m-d\TH:i')) }}" required>
                                {!!$errors->first('pay_date', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="pay-period">Periodicidad de pago</label>
                                <select name="pay_period" class="custom-select" id="pay-period">
                                    <option value="01" selected>Diario</option>
                                    <option value="02" {{ old('pay_period') === '02 Semanal' ? 'selected' : '' }}>Semanal</option>
                                    <option value="03" {{ old('pay_period') === '03' ? 'selected' : '' }}>Catorcenal</option>
                                    <option value="04" {{ old('pay_period') === '04' ? 'selected' : '' }}>Quincenal</option>
                                    <option value="05" {{ old('pay_period') === '05' ? 'selected' : '' }}>Mensual</option>
                                    <option value="06" {{ old('pay_period') === '06' ? 'selected' : '' }}>Bimestral</option>
                                    <option value="07" {{ old('pay_period') === '07' ? 'selected' : '' }}>Unidad obra</option>
                                    <option value="08" {{ old('pay_period') === '08' ? 'selected' : '' }}>Comisión</option>
                                    <option value="09" {{ old('pay_period') === '09' ? 'selected' : '' }}>Precio alzado</option>
                                    <option value="10" {{ old('pay_period') === '10' ? 'selected' : '' }}>Decenal</option>
                                    <option value="99" {{ old('pay_period') === '99' ? 'selected' : '' }}>Otra Periodicidad</option>
                                </select>
                                {!!$errors->first('pay_period', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="pay-period">Periodo isr</label>
                                <select name="isr_period" class="custom-select" id="isr-period">
                                    @foreach ($isrPeriods as $period)
                                        <option value="{{ $period->id }}" {{ old("isr_period") == $period->id ? "selected":"" }} >{{ $period->name }}</option>    
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title">Carga masiva de asimilados</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" name="fel_file" id="fel-file" accept=".xlsx" required>
                                    <label class="custom-file-label" for="fel_file">Seleccione el archivo de carga masiva ...</label>
                                    {!!$errors->first('fel_file', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="mt-4 d-flex justify-content-end">
                <button name="action" value="load-payroll" type="submit" class="btn btn-primary ml-2"><i class="fa fa-file-import mr-2"></i>Vista previa</button>
            </div>
        </div>
    </form>
    <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
    <script src="/js/master-detail.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bs-custom-file-input/dist/bs-custom-file-input.js" crossorigin="anonymous"></script>
    <script type="text/javascript">
        $(function() {
            bsCustomFileInput.init();
        });
    </script>
</body>

</html>
