<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Recibos de nómina
            @endslot
        @endcomponent
        <form action="/tax-documents/download-receipts" method="GET" class="container-fluid" autocomplete="off">
            {{ csrf_field() }}
            @include('components.messages')
            <table class="table border rounded table-hover">
                <thead class="thead-light">
                    <tr>
                        <th scope="col" colspan="7">
                            <button formmethod="POST" formaction="/tax-documents/download-receipts/export" value="{{ Session::token() }}" type="submit" data-toggle="modal" class="btn btn-sm btn-success back mr-5" name="action" value="export">
                                <i class="fa fa-file-excel mr-2"></i>Descargar
                            </button>
                        </th>
                        <th scope="col" colspan="4" class="text-right">
                            Número de recibos: <strong>{{ $total }}</strong>
                        </th>
                    </tr>
                    <tr>
                        <th scope="col" colspan="11">
                            <span class="d-flex">
                                <div class="form-group mr-2">
                                    <label for="from"><small class="form-text text-muted">Emisión desde</small></label>
                                    @if (isset($from))
                                        <input type="date" class="form-control" id="from" name="from" value="{{ $from->format('Y-m-d') }}">
                                    @else
                                        <input type="date" class="form-control" id="from" name="from">
                                    @endif
                                </div>
                                <div class="form-group mr-2">
                                    <label for="to"><small class="form-text text-muted">Emisión hasta</small></label>
                                    @if (isset($to))
                                        <input type="date" class="form-control" id="to" name="to" value="{{ $to->format('Y-m-d') }}">
                                    @else
                                    <input type="date" class="form-control" id="to" name="to">
                                    @endif
                                </div>
                            </span>
                            <span class="d-flex">
                                <input type="search" name="filter" class="form-control" placeholder="Buscar ..." value="{{ old('filter', $filter) }}">
                                <button name="action" value="search" type="submit" class="btn btn-primary ml-2"><i class="fa fa-search"></i></button>
                            </span>
                        </th>
                    </tr>
                </thead>
                    
                <thead class="thead-light">
                    <tr>
                        <th scope="col" style="width: 20px;"> <input id="select-all" type="checkbox"> </th>
                        <th scope="col" style="width: 150px;">Folio</th>
                        <th scope="col">UUID</th>
                        <th scope="col">Tipo</th>
                        <th scope="col" style="width: 150px;">Fecha</th>
                        <th scope="col" >Emisor</th>
                        <th scope="col" >RFC Receptor</th>
                        <th scope="col" >Receptor</th>
                        <th scope="col" >Estado</th>
                        <th scope="col" >Total</th>
                        <th scope="col" >Descargar</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($data as $i)
                    <tr>
                        <td><input type="checkbox" name="selected[]" value="{{ $i->id }}"></td>
                        <td>{{ $i->code }}</td>
                        <td>{{ $i->uuid }}</td>
                        <td>{{ $i->type }}</td>
                        <td>{{ $i->stamped_at }}</td>
                        <td>{{ $i->emissor }}</td>
                        <td>{{ $i->rfc }}</td>
                        <td>{{ $i->receiver }}</td>
                        <td>{{ $i->status }}</td>
                        <td class="text-right">{{ '$' . number_format($i->total, 2) }}</td>      
                        <td>
                            @if ($i->type == 'AS')
                                <a href="/invoices/{{ $i->id }}/xml" class="btn btn-sm btn-success" title="Formato XML"><i class="fa fa-file-code"></i></a>
                                <a href="/invoices/{{ $i->id }}/pdf" target="_blank" class="btn btn-sm btn-danger" title="Formato pdf"><i class="fa fa-file-pdf"></i></a>                  
                            @elseif ($i->type == 'Factura')
                                <a href="/tax-documents/invoices/{{ $i->id }}/xml" class="btn btn-sm btn-success" title="Formato XML"><i class="fa fa-file-code"></i></a>
                                <a href="/tax-documents/invoices/{{ $i->id }}/pdf" target="_blank" class="btn btn-sm btn-danger" title="Formato pdf"><i class="fa fa-file-pdf"></i></a>  
                            @elseif ($i->type == 'SYS')
                                <a href="/sys/{{ $i->id }}/xml" class="btn btn-sm btn-success" title="Formato XML"><i class="fa fa-file-code"></i></a>
                                <a href="/sys/{{ $i->id }}/pdf" target="_blank" class="btn btn-sm btn-danger" title="Formato pdf"><i class="fa fa-file-pdf"></i></a>                
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="thead-light">
                    <tr>
                        <th scope="col" colspan="11">
                            <div class="btn-toolbar d-flex justify-content-end" role="toolbar">
                                <div class="btn-group" role="group">
                                    @for ($i = 0; $i < $pages && $i < 10; $i ++)
                                        <button formmethod="POST" formaction="/tax-documents/download-receipts?page={{$i}}" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-secondary {{ $i == $page ? 'active' : '' }}">{{ $i + 1 }}</button>
                                    @endfor
                                </div>
                            </div>
                        </th>
                    </tr>
                </tfoot>
            </table>
        </form>
        @include('components.footer')
        <script src="/js/master-detail.js"></script>
    </body>
</html>
