<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
@include('components.head')
<body class="bg-light">
    @component('components.nav')
        @slot('title')
            Nueva factura
        @endslot
    @endcomponent
    <form action="/tax-documents/invoices" method="POST" encType="multipart/form-data" autocomplete="off">
        @csrf
        <!-- Image and text -->
        @include('components.messages')
        <div class="container">
            <div class="card">
                <div class="card-header">
                    <table width="100%">
                        <tr>
                            <td>
                                <h5 class="card-title">Datos de facturación</h5>
                            </td>
                            <td>
                                <div class="d-flex justify-content-end">
                                    @if ($invoice->id)
                                        <a href="/tax-documents/invoices/{{ $invoice->id }}/xml" class="btn btn-sm btn-secondary mr-2" title="Formato XML"><i class="fa fa-file-code mr-2"></i>Descargar XML</a>
                                        <a href="/tax-documents/invoices/{{ $invoice->id }}/pdf" target="_blank" class="btn btn-sm btn-secondary mr-5" title="Formato pdf"><i class="fa fa-file-pdf mr-2"></i>Descargar PDF</a>
                                        @if ($invoice->isStamped() && (!$invoice->canceled_at || Auth::user()->id == 1))
                                            @if ($invoice->pay_method == 'PPD')
                                            <a href="/tax-documents/invoice-payments/create/{{ $invoice->id }}" class="btn btn-sm btn-primary mr-5" title="Generar pago">
                                                <i class="fa fa-receipt mr-2"></i>Complemento de pago</a>
                                            @endif
                                            <button type="submit" data-toggle="modal" class="btn btn-sm btn-danger back" name="action" 
                                                value="cancel-stamp" {{ $invoice->canceled_at && Auth::user()->id != 1 ? 'disabled' : '' }}>
                                                <i class="fa fa-stamp mr-2"></i>Cancelar factura
                                            </button>
                                        @elseif (!$invoice->isStamped())
                                            <button type="submit" data-toggle="modal" class="btn btn-sm btn-primary back" name="action" 
                                                value="stamp" {{ !$invoice->canStamp() || $invoice->isStamped() ? 'disabled' : '' }}>
                                                <i class="fa fa-stamp mr-2"></i>Timbrar
                                            </button>
                                        @endif
                                    @endif
                                </div>
                            </td>
                        </tr>
                    </table>
                </div>
                <input type="hidden" id="id" name="id" value="{{ $invoice->id }}">
                <div class="card-body">
                    @if ($invoice->isStamped())
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="folio">Folio</label>
                                <input type="text" class="form-control" id="folio" name="folio" value="{{ $invoice->code }}" disabled>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="uuid">UUID</label>
                                <input type="text" class="form-control" id="uuid" name="uuid" value="{{ $invoice->uuid }}" disabled>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="rfc-emissor">RFC Emisor</label>
                                <input type="text" class="form-control" id="rfc-emissor" name="uuid" value="{{ $invoice->emissor->rfc }}" disabled>
                            </div>
                        </div>
                    </div>
                    @endif
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="status">Estatus</label>
                                <input type="text" class="form-control" id="status" name="status" 
                                    value="{{ $invoice->canceled_at ? 'Cancelado' : ($invoice->isStamped() ? 'Vigente' : 'Por timbrar') }}" disabled>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                               <label for="receiver">Cliente</label>
                                <input list="receiver" name="receiver-name" class="form-control" autofocus required
                                    value="{{ old('receiver-name', $invoice->receiver ? $invoice->receiver->name : '') }}" {{ $invoice->isStamped() ? 'disabled' : '' }}>
                                <datalist id="receiver">
                                    @foreach ($receivers as $client)
                                        @if ($client->status == 'R')
                                        <option value="{{ $client->name }}">
                                        @endif
                                    @endforeach    
                                </datalist>
                            </div>                            
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="rfc">RFC</label>
                                <input type="text" class="form-control" id="rfc" name="rfc" value="{{ $invoice->receiver ? $invoice->receiver->rfc : '' }}" disabled>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="client">Emisor</label>
                                <select name="client" class="custom-select" id="client" {{ $invoice->isStamped() ? 'disabled' : '' }}>
                                    @foreach ($emitters as $emitter)
                                        <option value="{{ $emitter->id }}" {{ old("client", $invoice->emissor_id) == $emitter->id ? "selected":"" }}>{{ $emitter->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="branch">Lugar de expedición</label>
                                <select name="branch" class="custom-select" id="branch" {{ $invoice->isStamped() ? 'disabled' : '' }}>
                                </select>
                                <datalist id="available-expeditions">
                                    @foreach ($branches as $branch)
                                        <option data-client="{{ $branch->business_client_id }}" value="{{ $branch->id }}" {{ old("branch", $invoice->business_branch_id) == $branch->id ? "selected":"" }}>{{ $branch->name }}</option>
                                    @endforeach
                                </datalist>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="tax-regime">Régimen fiscal</label>
                                <select name="tax-regime" class="custom-select" id="tax-regime" {{ $invoice->isStamped() ? 'disabled' : '' }}>
                                    @foreach ($invoiceTaxRegimes as $regime)
                                        <option value="{{ $regime->id }}" {{ old("tax-regime", $invoice->invoice_tax_regime_id) == $regime->id ? "selected":"" }}>{{ $regime->description }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="invoice-use">Uso cfdi</label>
                                <select name="invoice-use" class="custom-select" id="invoice-use" {{ $invoice->isStamped() ? 'disabled' : '' }}>
                                    @foreach ($invoiceUses as $use)
                                        <option value="{{ $use->id }}" {{ old("invoice-use", $invoice->invoice_use_id) == $use->id  ? "selected":"" }}>{{ $use->description }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="invoice-type">Tipo de comprobante</label>
                                <select name="invoice-type" class="custom-select" id="invoice-type" {{ $invoice->isStamped() ? 'disabled' : '' }}>
                                    @foreach ($invoiceTypes as $type)
                                        <option value="{{ $type->id }}" {{ old("invoice-type", $invoice->invoice_type_id) == $type->id  ? "selected":"" }}>{{ $type->description }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="invoice-at">Fecha de emisión</label>
                                <input type="datetime-local" name="invoice-at" class="form-control" id="invoice-at" required
                                    value="{{ old('invoice-at', $invoice->invoice_at->format('Y-m-d\TH:i')) }}" {{ $invoice->isStamped() ? 'disabled' : '' }}>
                                {!!$errors->first('invoice-at', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="pay-method">Método de pago</label>
                                <select name="pay-method" class="custom-select" id="pay-method" {{ $invoice->isStamped() ? 'disabled' : '' }}>
                                    <option value="PUE" selected>Pago en una sola exhibición</option>
                                    <option value="PPD" {{ old('pay-method', $invoice->pay_method) === 'PPD' ? 'selected' : '' }}>Pago en parcialidades o diferido</option>
                                </select>
                                {!!$errors->first('pay_period', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="pay-type">Forma de pago</label>
                                <select name="pay-type" class="custom-select" id="pay-type" {{ $invoice->isStamped() ? 'disabled' : '' }}>
                                    @foreach ($invoicePayTypes as $payType)
                                        <option value="{{ $payType->id }}" {{ old("pay-type", $invoice->invoice_pay_type_id) == $payType->id ? "selected":"" }}>{{ $payType->description }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-2">
                            <div class="form-group">
                                <label for="subtotal">Subtotal</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="inputGroupPrepend">$</span>
                                    </div>
                                    <input type="number" class="form-control" id="subtotal" name="subtotal" value="{{ $invoice->subtotal, 2 }}" step="0.01" disabled>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-2">
                            <div class="form-group">
                                <label for="tax">Impuestos</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="inputGroupPrepend">$</span>
                                    </div>
                                    <input type="number" class="form-control" id="tax" name="tax" value="{{ $invoice->total - $invoice->subtotal }}" disabled>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                        </div>
                        <div class="col-sm-12 col-md-4">
                        </div>
                        <div class="col-sm-12 col-md-2">
                            <div class="form-group">
                                <label for="retention">Retención I.V.A.</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="inputGroupPrepend">$</span>
                                    </div>
                                    <input type="number" class="form-control" id="retention" name="retention" value="{{ old('retention', $invoice->retention) }}" step="0.01" disabled>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-2">
                            <div class="form-group">
                                <label for="total">Total</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="inputGroupPrepend">$</span>
                                    </div>
                                    <input type="number" class="form-control" id="total-neto" name="total-neto" value="{{ $invoice->calcTotalNeto() }}" disabled>
                                </div>
                            </div>
                        </div>
                    </div>
                    @if ($invoice->log)
                    <div class="row">
                        <div class="col-sm-12 col-md-12">
                            <div class="form-group">
                                <label for="serie">Log</label>
                                <textarea class="form-control" id="log" rows="3" disabled>{{ $invoice->log }}</textarea>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>

                <ul class="nav nav-tabs">
                    <li class="nav-item active"><a class="nav-link active" data-toggle="tab" href="#div-concepts">Conceptos</a></li>
                    @if ($invoice->isStamped() && $invoice->pay_method == 'PPD')
                        <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#div-payments">Complementos de pago</a></li>
                    @endif
                </ul>
                <div class="tab-content">
                    <div id="div-concepts" class="tab-pane fade show active">
                        <div class="row mt-3">
                            <div class="col-xs-12 col-md-12">
                                <div class="card mt-2">
                                    <table class="table table-sm table-striped table-hover">
                                        <thead class="thead-light">
                                            <tr>
                                                <th style="width: 100px;">Clave de unidad</th>
                                                <th style="width: 200px;">Concepto</th>
                                                <th>Descripción adicional</th>
                                                <th style="width: 100px;">Impuesto</th>
                                                <th style="width: 150px;">Total</th>
                                                <th style="width: 150px;">Subtotal</th>
                                                @if ($invoice->receiver != null && $invoice->receiver->applyRetention())
                                                <th style="width: 120px;">Retención I.V.A.</th>
                                                @endif
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @if (!!$concepts)
                                            @foreach ($concepts as $i)
                                            <tr>
                                                <td>
                                                    <input type="hidden" id="concept-id" name="concept-id[]" value="{{ $i->id }}">
                                                    <select name="concept-code[]" class="custom-select" id="concept-code" {{ $invoice->isStamped() ? 'disabled' : '' }}>
                                                        <option value="H87" {{ old('concept-code', $i->code) === 'H87' ? 'selected' : '' }}>H87</option>
                                                        <option value="EA" {{ old('concept-code', $i->code) === 'EA' ? 'selected' : '' }}>EA</option>
                                                        <option value="E48" selected>E48</option>
                                                        <option value="ACT" {{ old('concept-code', $i->code) === 'ACT' ? 'selected' : '' }}>ACT</option>
                                                        <option value="KGM" {{ old('concept-code', $i->code) === 'KGM' ? 'selected' : '' }}>KGM</option>
                                                        <option value="E51" {{ old('concept-code', $i->code) === 'E51' ? 'selected' : '' }}>E51</option>
                                                        <option value="A9" {{ old('concept-code', $i->code) === 'A9' ? 'selected' : '' }}>A9</option>
                                                        <option value="MTR" {{ old('concept-code', $i->code) === 'MTR' ? 'selected' : '' }}>MTR</option>
                                                        <option value="AB" {{ old('concept-code', $i->code) === 'AB' ? 'selected' : '' }}>AB</option>
                                                        <option value="BB" {{ old('concept-code', $i->code) === 'BB' ? 'selected' : '' }}>BB</option>
                                                        <option value="KT" {{ old('concept-code', $i->code) === 'KT' ? 'selected' : '' }}>KT</option>
                                                        <option value="SET" {{ old('concept-code', $i->code) === 'SET' ? 'selected' : '' }}>SET</option>
                                                        <option value="LTR" {{ old('concept-code', $i->code) === 'LTR' ? 'selected' : '' }}>LTR</option>
                                                        <option value="XBX" {{ old('concept-code', $i->code) === 'XBX' ? 'selected' : '' }}>XBX</option>
                                                        <option value="MON" {{ old('concept-code', $i->code) === 'MON' ? 'selected' : '' }}>MON</option>
                                                        <option value="HUR" {{ old('concept-code', $i->code) === 'HUR' ? 'selected' : '' }}>HUR</option>
                                                        <option value="MTK" {{ old('concept-code', $i->code) === 'MTK' ? 'selected' : '' }}>MTK</option>
                                                        <option value="11" {{ old('concept-code', $i->code) === '11' ? 'selected' : '' }}>11</option>
                                                        <option value="MGM" {{ old('concept-code', $i->code) === 'MGM' ? 'selected' : '' }}>MGM</option>
                                                        <option value="XPK" {{ old('concept-code', $i->code) === 'XPK' ? 'selected' : '' }}>KPK</option>
                                                    </select>
                                                </td>
                                                <td>
                                                    <select name="concept[]" class="custom-select" id="concept" {{ $invoice->isStamped() ? 'disabled' : '' }}>
                                                        @foreach ($businessConcepts as $businessConcept)
                                                            <option value="{{ $businessConcept->id }}" {{ old('concept', $i->business_client_concept_id) === $businessConcept->id ? 'selected' : '' }}>{{ $businessConcept->type == 'S' ? '*' : '' }} {{ $businessConcept->name }}</option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control" id="concept-description" name="concept-description[]" maxlength="1020"
                                                        value="{{ old('description', $i->description) }}" {{ $invoice->isStamped() ? 'disabled' : '' }}>
                                                </td>
                                                <td><input type="text" class="form-control" value="16.00 %" disabled></td>
                                                <td>
                                                    <div class="input-group">
                                                        <div class="input-group-prepend">
                                                            <span class="input-group-text" id="inputGroupPrepend">$</span>
                                                        </div>
                                                        <input type="text" class="form-control" name="concept-total[]" required
                                                            value="{{ old('concept-total', $i->total) }}" {{ $invoice->isStamped() ? 'disabled' : '' }}>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="input-group">
                                                        <div class="input-group-prepend">
                                                            <span class="input-group-text" id="inputGroupPrepend">$</span>
                                                        </div>
                                                        <input type="number" class="form-control" name="concept-subtotal[]" value="{{ old('subtotal', $i->subtotal) }}" disabled>
                                                    </div>
                                                </td>
                                                @if ($invoice->receiver != null && $invoice->receiver->applyRetention())
                                                <td>
                                                    <div class="input-group">
                                                        <div class="input-group-prepend">
                                                            <span class="input-group-text" id="inputGroupPrepend">$</span>
                                                        </div>
                                                        <input type="text" class="form-control" name="concept-retention[]" value="{{ old('concept-retention', $i->retention) }}" disabled>
                                                    </div>
                                                </td>
                                                @endif
                                                <td>
                                                    <a href="/tax-documents/invoices/concepts/{{ $i->id }}/destroy" class="btn btn-sm btn-danger back {{ $invoice->isStamped() ? 'disabled' : '' }}"><i class="fa fa-minus"></i></a>
                                                </td>
                                            </tr>
                                            @endforeach
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    @if ($invoice->isStamped() && $invoice->pay_method == 'PPD')
                    <div id="div-payments" class="tab-pane fade">
                        <div class="border rounded">
                            <table class="table table-sm table-striped table-hover">
                                <thead class="thead-light">
                                    <tr>
                                        <th>Folio</th>
                                        <th>Importe pagado</th>
                                        <th>Importe de saldo anterior</th>
                                        <th>Importe de saldo insoluto</th>
                                        <th>Numero de parcialidad</th>
                                        <th>Estado</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($payments as $payment)
                                    <tr>
                                        <th>
                                            <a href="/tax-documents/invoice-payments/{{ $payment->invoice_id }}/edit">{{ $payment->invoice->code ? $payment->invoice->code : 'TEMP' }}</a>
                                        </th>
                                        <td class="text-center">
                                            {{ '$' . number_format($payment->amount, 2) }}
                                        </td>
                                        <td class="text-center">{{ '$' . number_format($payment->last_amount, 2) }}</td>
                                        <td class="text-center">{{ '$' . number_format($payment->carried_amount, 2) }}</td>
                                        <td class="text-center">{{ $payment->parciality }}</td>
                                        <td>
                                            @if ($payment->invoice->canceled_at)
                                                <i class="text-danger mr-2">Cancelado</i>
                                            @elseif($payment->invoice->isStamped())
                                                <i class="text-success mr-2">Vigente</i>
                                            @else
                                                <i class="text-secondary mr-2">No timbrado</i>
                                            @endif
                                        </td>
                                        <td>
                                            <a href="/tax-documents/invoices/payments/{{ $payment->id }}/destroy" class="btn btn-sm btn-danger back {{ $payment->invoice->isStamped() ? 'disabled' : '' }}"><i class="fa fa-minus"></i></a>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    @endif
                </div>
                <div class="card-footer d-flex justify-content-between">
                    <span>
                        <a href="/tax-documents/invoices?status={{ $invoice->canceled_at ? 'C' : ($invoice->isStamped() ? 'D' : 'M') }}" class="btn btn-sm btn-outline-secondary mr-2"><i class="fa fa-chevron-left mr-2"></i>Regresar</a>
                        <button type="submit" data-toggle="modal" class="btn btn-sm btn-secondary back" name="action" value="add-concept" {{ $invoice->isStamped() ? 'disabled' : '' }}>
                            <i class="fa fa-plus mr-2"></i>Agregar concepto
                        </button>
                    </span>
                    <button name="action" value="store" type="submit" class="btn btn-sm btn-success ml-2" {{ $invoice->isStamped() ? 'disabled' : '' }}>
                        <i class="fa fa-check mr-2"></i>Confirmar</button>
                </div>
            </div>
        </div>
    </form>
    <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
    <script src="/js/master-detail.js"></script>
</body>

</html>
