<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
@include('components.head')
<body class="bg-light">
    @component('components.nav')
        @slot('title')
            Nuevo complemento de pago
        @endslot
    @endcomponent
    <form action="/tax-documents/invoice-payments/{{ $parent->id }}" method="POST" encType="multipart/form-data">
        @csrf
        <!-- Image and text -->
        @include('components.messages')
        <input type="hidden" id="parent-id" name="parent-id" value="{{ $parent->id }}">
        <div class="container">
            <div class="card">
                <div class="card-header">
                    <table width="100%">
                        <tr>
                            <td>
                                <h5 class="card-title">Datos de facturación</h5>
                            </td>
                            <td>
                                <div class="d-flex justify-content-end">
                                    <a href="/tax-documents/invoice-payments/{{ $invoice->id }}/xml" class="btn btn-sm btn-secondary mr-2" title="Formato XML"><i class="fa fa-file-code mr-2"></i>Descargar XML</a>
                                    <a href="/tax-documents/invoice-payments/{{ $invoice->id }}/pdf" target="_blank" class="btn btn-sm btn-secondary mr-5" title="Formato pdf"><i class="fa fa-file-pdf mr-2"></i>Descargar PDF</a>

                                    @if ($invoice->isStamped() && !$invoice->canceled_at) 
                                        <button type="submit" data-toggle="modal" class="btn btn-sm btn-danger back" name="action" 
                                            value="cancel-stamp" {{ $invoice->canceled_at ? 'disabled' : '' }}>
                                            <i class="fa fa-stamp mr-2"></i>Cancelar pago
                                        </button>
                                    @elseif (!$invoice->isStamped())
                                        <button type="submit" data-toggle="modal" class="btn btn-sm btn-primary back" name="action" 
                                            value="stamp" {{ !$invoice->canStamp() || $invoice->isStamped() ? 'disabled' : '' }}>
                                            <i class="fa fa-stamp mr-2"></i>Timbrar
                                        </button>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    </table>
                </div>
                <input type="hidden" id="id" name="id" value="{{ $invoice->id }}">
                <div class="card-body">
                    @if ($invoice->isStamped())
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="folio">Folio</label>
                                <input type="text" class="form-control" id="folio" name="folio" value="{{ $invoice->code }}" disabled>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="uuid">UUID</label>
                                <input type="text" class="form-control" id="uuid" name="uuid" value="{{ $invoice->uuid }}" disabled>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="rfc-emissor">RFC Emisor</label>
                                <input type="text" class="form-control" id="rfc-emissor" name="uuid" value="{{ $invoice->emissor->rfc }}" disabled>
                            </div>
                        </div>
                    </div>
                    @endif
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="status">Estatus</label>
                                <input type="text" class="form-control" id="status" name="status" 
                                    value="{{ $invoice->canceled_at ? 'Cancelado' : ($invoice->isStamped() ? 'Vigente' : 'Por timbrar') }}" disabled>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                               <label for="receiver">Cliente</label>
                                <input type="text" name="receiver-name" class="form-control" value="{{ old('receiver-name', $invoice->receiver ? $invoice->receiver->name : '') }}" autofocus disabled>
                            </div>                            
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="rfc">RFC</label>
                                <input type="text" class="form-control" id="rfc" name="rfc" value="{{ $invoice->receiver ? $invoice->receiver->rfc : '' }}" disabled>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="client">Emisor</label>
                                <input type="text" class="form-control" id="client" name="client" value="{{ $invoice->emissor->name }}" disabled>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="branch">Lugar de expedición</label>
                                <input type="text" class="form-control" id="branch" name="branch" value="{{ $invoice->businessBranch->name }}" disabled>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="tax-regime">Régimen fiscal</label>
                                <input type="text" class="form-control" id="branch" name="tax-regime" value="{{ $invoice->invoiceTaxRegime->description }}" disabled>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="invoice-use">Uso cfdi</label>
                                <input type="text" class="form-control" id="invoice-use" name="invoice-use" value="{{ $invoice->invoiceUse->description }}" disabled>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="invoice-type">Tipo de comprobante</label>
                                <input type="text" class="form-control" id="invoice-type" name="invoice-type" value="{{ $invoice->invoiceType->description }}" disabled>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="invoice-at">Fecha de emisión</label>
                                <input type="datetime-local" name="invoice-at" class="form-control" id="invoice-at" {{ $invoice->isStamped() ? 'disabled' : '' }}
                                    value="{{ old('invoice-at', $invoice->invoice_at->format('Y-m-d\TH:i')) }}" required>
                                {!!$errors->first('invoice-at', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="payment-at">Fecha de pago</label>
                                <div class="d-flex justify-content-between">
                                    <input type="datetime-local" name="payment-at" class="form-control" id="payment-at" {{ $invoice->isStamped() ? 'disabled' : '' }}
                                        value="{{ old('payment-at', (is_string($paymentDate) ? $paymentDate : $paymentDate->format('Y-m-d\TH:i'))) }}" required>
                                    {!!$errors->first('payment-at', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                                    <input type="number" min="0" max="59" name="payment-at-seconds" class="form-control" id="payment-at-seconds" {{ $invoice->isStamped() ? 'disabled' : '' }} value="{{ old('payment-at-seconds', (is_string($paymentDate) ? $paymentDate : $paymentDate->format('s'))) }}">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="pay-type">Forma de pago</label>
                                <select name="pay-type" class="custom-select" id="pay-type" {{ $invoice->isStamped() ? 'disabled' : '' }}>
                                    @foreach ($invoicePayTypes as $payType)
                                        <option value="{{ $payType->id }}" {{ old("pay-type", $invoice->invoice_pay_type_id) == $payType->id ? "selected":"" }}>{{ $payType->description }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-2">
                            <div class="form-group">
                                <label for="total">Total</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="inputGroupPrepend">$</span>
                                    </div>
                                    <input type="number" class="form-control" id="total" name="total" value="{{ old('total', $invoice->total) }}" step="0.01" disabled>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-2">
                            <div class="form-group">
                                <label for="serie">Subtotal</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="inputGroupPrepend">$</span>
                                    </div>
                                    <input type="number" class="form-control" id="subtotal" name="subtotal" value="{{ number_format(old('subtotal', $invoice->subtotal), 2) }}" disabled>
                                </div>
                            </div>
                        </div>
                    </div>
                    @if ($invoice->log)
                    <div class="row">
                        <div class="col-sm-12 col-md-12">
                            <div class="form-group">
                                <label for="serie">Log</label>
                                <textarea class="form-control" id="log" rows="3" disabled>{{ $invoice->log }}</textarea>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
                <div class="row mt-3">
                    <div class="col-xs-12 col-md-12">
                        <div class="card mt-2">
                            <div class="card-header d-flex justify-content-between">
                                <h5 class="card-title">Documentos</h5>
                                <button formmethod="POST" formaction="/tax-documents/invoice-payments/{{ $parent->id }}/add-document" class="btn btn-sm btn-primary" type="submit" name="_token" value="{{ Session::token() }}"> <i class="fas fa-plus"></i> </button>
                            </div>
                            <table class="table table-sm table-striped table-hover">
                                <thead class="thead-light">
                                    <tr>
                                        <th>UUID</th>
                                        <th style="width: 200px;">Método de pago</th>
                                        <th style="width: 150px;">Importe pagado</th>
                                        <th style="width: 150px;">Importe de saldo anterior</th>
                                        <th style="width: 150px;">Importe de saldo insoluto</th>
                                        <th style="width: 100px;">Numero de parcialidad</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                @for ($i = 0; $i < count($payments); $i++)
                                    <tr>
                                        <td>
                                            <input type="hidden" id="payment-id[]" name="payment-id[]" value="{{ $payments[$i]->id }}">
                                            <select name="payment-uuid[]" class="custom-select" id="payment-uuid[]">
                                                @foreach ($parents as $p)
                                                    <option value="{{ $p->id }}" {{ old("payment-uuid[]", $payments[$i]->invoice_related_id) == $p->id ? "selected":"" }}>{{ $p->uuid }}</option>    
                                                @endforeach
                                            </select>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control" id="payment-uuid" name="payment-uuid[]" value="PPD" disabled>
                                        </td>
                                        <td>
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text" id="inputGroupPrepend">$</span>
                                                </div>
                                                <input type="text" class="form-control" id="payment-amount[]" name="payment-amount[]" 
                                                    value="{{old('payment-amount[]', $payments[$i]->amount)}}" {{ $invoice->isStamped() ? 'disabled' : '' }} required>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text" id="inputGroupPrepend">$</span>
                                                </div>
                                                <input type="text" class="form-control" id="payment-last-amount[]" name="payment-last-amount[]" value="{{number_format(old('payment-last-amount[]', $payments[$i]->last_amount), 2)}}" disabled>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text" id="inputGroupPrepend">$</span>
                                                </div>
                                                <input type="text" class="form-control" id="payment-carried-amount[]" name="payment-carried-amount[]" value="{{number_format(old('payment-carried-amount[]', $payments[$i]->carried_amount), 2)}}" disabled>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group">
                                                <input type="text" class="form-control" id="payment-parciality[]" name="payment-parciality[]" value="{{old('payment-parciality[]', $payments[$i]->parciality)}}" disabled>
                                            </div>
                                        </td>
                                        <td>
                                            <button formmethod="POST" formaction="/tax-documents/invoice-payments/{{ $i }}/remove-document" class="btn btn-sm btn-danger {{ $payments[$i]->invoice && $payments[$i]->invoice->isStamped() ? 'disabled' : '' }}" type="submit" name="_token" value="{{ Session::token() }}"> <i class="fas fa-minus"></i> </button>
                                        </td>
                                    </tr>
                                    @endfor
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex justify-content-between">
                    <span>
                        <a href="/tax-documents/invoices/{{ $parent->id }}/edit" class="btn btn-sm btn-outline-secondary mr-2"><i class="fa fa-chevron-left mr-2"></i>Regresar</a>
                    </span>
                    <button name="action" value="store" type="submit" class="btn btn-sm btn-success ml-2" {{ $invoice->isStamped() ? 'disabled' : '' }}>
                        <i class="fa fa-check mr-2"></i>Confirmar
                    </button>
                </div>
            </div>
        </div>
    </form>
    <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
    <script src="/js/master-detail.js"></script>
</body>

</html>
