<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Facturas a clientes externos
            @endslot
        @endcomponent
        <form action="/tax-documents/invoices" method="POST" class="container-fluid">
            {{ csrf_field() }}
            @include('components.messages')
            <table class="table border rounded table-hover">
                <thead class="thead-light">
                    <tr>
                        <th scope="col" colspan="{{ ($status == 'D' || $status == 'C') ? 7 : 6 }}">
                            <span>
                                <a href="/tax-documents/invoices/create" class="btn btn-sm btn-primary back" role="button">
                                    <i class="fa fa-file-invoice mr-2"></i>Generar factura</a>
                                <button type="submit" data-toggle="modal" class="btn btn-sm btn-success back mr-5" name="action" value="package-invoices">
                                    <i class="fa fa-download mr-2"></i>Descargar
                                </button>
                                <button type="submit" data-toggle="modal" class="btn btn-sm btn-danger back" name="action" value="destroy" {{ $status == 'M' ? '' : 'disabled'}}>
                                    <i class="fa fa-trash mr-2"></i>Remover factura
                                </button>
                            </span>
                        </th>
                        <th scope="col" colspan="3" class="text-right">
                            Número de facturas: <strong>{{ $total }}</strong>
                        </th>
                    </tr>
                    <tr>
                        <th scope="col" colspan="{{ ($status == 'D' || $status == 'C') ? 10 : 8 }}">
                            <span class="d-flex">
                                <div class="form-group mr-4">
                                    <label for="client"><small class="form-text text-muted">Cliente</small></label>
                                    <input list="client" name="client-name" class="form-control" value="{{ old('client-name', $clientName) }}">
                                    <datalist id="client">
                                        @foreach ($clients as $client)
                                            <option value="{{ $client->name }}">
                                        @endforeach    
                                    </datalist>
                                </div>
                                <div class="form-group mr-4">
                                    <label for="status"><small class="form-text text-muted">Timbrado</small></label>
                                    <select name="status" class="custom-select" id="status">
                                        <option value="D" {{ old('status', $status) == 'D' ? "selected":"" }}>Vigentes</option>
                                        <option value="M" {{ old('status', $status) == 'M' ? "selected":"" }}>No timbrados</option>
                                        <option value="C" {{ old('status', $status) == 'C' ? "selected":"" }}>Cancelados</option>
                                    </select>
                                </div>
                                <div class="form-group mr-4">
                                    <label for="pay-method"><small class="form-text text-muted">Método de pago</small></label>
                                    <select name="pay-method" class="custom-select" id="pay-method">
                                        <option value="A" {{ old('pay-method', $payMethod) == 'A' ? 'selected':'' }}>Todos</option>
                                        <option value="PUE" {{ old('pay-method', $payMethod) == 'PUE' ? 'selected':'' }}>PUE</option>
                                        <option value="PPD" {{ old('pay-method', $payMethod) == 'PPD' ? 'selected':'' }}>PPD</option>
                                    </select>
                                </div>
                                <div class="form-group mr-2">
                                    <label for="from"><small class="form-text text-muted">Emisión desde</small></label>
                                    @if (isset($from))
                                        <input type="date" class="form-control" id="from" name="from" value="{{ $from->format('Y-m-d') }}">
                                    @else
                                        <input type="date" class="form-control" id="from" name="from">
                                    @endif
                                </div>
                                <div class="form-group mr-2">
                                    <label for="to"><small class="form-text text-muted">Emisión hasta</small></label>
                                    @if (isset($to))
                                        <input type="date" class="form-control" id="to" name="to" value="{{ $to->format('Y-m-d') }}">
                                    @else
                                    <input type="date" class="form-control" id="to" name="to">
                                    @endif
                                </div>
                                <div class="form-group mr-4">
                                    <label for="created-by"><small class="form-text text-muted">Creado por</small></label>
                                    <select name="created-by" class="custom-select" id="created-by">
                                    @foreach ($users as $user)
                                        <option value="{{ $user->id }}" {{ old('created-by', $userId) == $user->id ? 'selected':'' }}>{{ $user->user_name }}</option>
                                    @endforeach
                                        <option value="0" {{ old('created-by', $userId) == 0 ? 'selected':'' }}>Otro</option>
                                    </select>
                                </div>
                            </span>
                            <span class="d-flex">
                                <input type="search" name="filter" class="form-control" placeholder="Buscar ..." value="{{ old('filter', $filter) }}">
                                <button name="action" value="search" type="submit" class="btn btn-primary ml-2"><i class="fa fa-search"></i></button>
                            </span>
                        </th>
                    </tr>
                </thead>
                <thead class="thead-light">
                    <tr>
                        <th scope="col" style="width: 20px;"> <input id="select-all" type="checkbox"> </th>
                        @if ($status == 'D' || $status == 'C')
                            <th scope="col" style="width: 150px;">Folio</th>
                            <th scope="col">UUID</th>
                        @endif                        
                        <th scope="col" >Cliente</th>
                        <th scope="col" >Emisor</th>
                        <th scope="col" style="width: 150px;">Fecha</th>
                        <th scope="col" style="width: 100px;">Método de pago</th>
                        <th scope="col" style="width: 110px;">Total</th>
                        <th scope="col" style="width: 110px;">Importe pagado</th>
                        <th scope="col" style="width: 110px;">Saldo insoluto</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($invoices as $i)
                    <tr>
                        <td><input type="checkbox" name="selected[]" value="{{ $i->id }}"></td>
                        @if ($status == 'D' || $status == 'C')
                            <td><a href="/tax-documents/invoices/{{ $i->id }}/edit">{{ $i->code }}</a></td>
                            <td>{{ $i->uuid }}</td>
                            <td>{{ $i->receiver->name }}</td>
                        @else
                            <td><a href="/tax-documents/invoices/{{ $i->id }}/edit">{{ $i->receiver->name }}</a></td>
                        @endif 
                        <td>{{ $i->emissor->name }}</td>
                        <td>{{ $i->invoice_at->format('Y-m-d H:m') }}</td>
                        @if ($i->pay_method == 'PUE')
                            <td class="text-center">{{ $i->pay_method }}</td>
                        @else
                            <td class="text-center {{ $i->total == $i->getAmountPayed() ? 'text-success' : 'text-danger' }}">{{ $i->pay_method }}</td>
                        @endif
                        <td class="text-right">{{ '$' . number_format($i->total, 2) }}</td>
                        <td class="text-right">{{  $i->pay_method == 'PPD' ? '$ ' . number_format($i->getAmountPayed(), 2) : ''}}</td>
                        <td class="text-right">{{  $i->pay_method == 'PPD' ? '$ ' . number_format($i->getCarriedAmount(), 2) : ''}}</td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="thead-light">
                    <tr>
                        <th scope="col" colspan="{{ ($status == 'D' || $status == 'C') ? 10 : 8 }}">
                            <div class="btn-toolbar d-flex justify-content-end" role="toolbar">
                                <div class="btn-group" role="group">
                                    @foreach ($pages as $i)
                                        <button formmethod="POST" formaction="/tax-documents/invoices/list?page={{$i}}" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-secondary {{ $i === $page ? 'active' : '' }}">{{ $i + 1 }}</button>
                                    @endforeach
                                </div>
                            </div>
                        </th>
                    </tr>
                </tfoot>
            </table>
        </form>
        @include('components.footer')
        <script src="/js/master-detail.js"></script>
    </body>
</html>
