<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        {{--@include('components.menu')--}}
        <form action="/invoices" method="POST" class="container-fluid">
            {{ csrf_field() }}
            @include('components.messages')
            <table class="table border rounded table-hover">
                <thead class="thead-light">
                    <tr>
                        <th scope="col" colspan="13">
                            <div class="d-flex">
                                <input type="search" name="filter" class="form-control" placeholder="Buscar ...">
                                <button name="action" value="search" type="submit" class="btn btn-primary ml-2"><i class="fa fa-search"></i></button>
                            </div>
                        </th>
                    </tr>
                </thead>
                <thead class="thead-light">
                    <tr>
                        <th scope="col">No</th>
                        <th scope="col">Empleado</th>
                        <th scope="col">RFC</th>
                        <th scope="col">Salario diario</th>
                        <th scope="col">Dias laborados</th>
                        <th scope="col">Importe</th>
                        <th scope="col">Subsidio al empleo</th>
                        <th scope="col">Total</th>
                        <th scope="col">IMSS</th>
                        <th scope="col">ISR</th>
                        <th scope="col">INFONAVIT</th>
                        <th scope="col">TOTAL A PAGAR</th>
                        <th scope="col">Descargar</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($mapEmployees as $i)
                    <tr>
                        <td>{{$i['no']}}</td>
                        <td>{{$i['name']}}</td>
                        <td>{{$i['rfc']}}</td>
                        <td>{{'$' . number_format($i['salaryDay'], 2)}}</td>
                        <td>{{number_format($i['workDays'], 0)}}</td>
                        <td>{{'$' . number_format($i['import'], 2)}}</td>
                        <td>{{'$' . number_format($i['subsidy'], 2)}}</td>
                        <td>{{'$' . number_format($i['total'], 2)}}</td>
                        <td>{{'$' . number_format($i['imss'], 2)}}</td>
                        <td>{{'$' . number_format($i['isr'], 2)}}</td>
                        <td>{{'$' . number_format($i['infonavit'], 2)}}</td>
                        <td>{{'$' . number_format($i['totalPayed'], 2)}}</td>
                        <td>
                            <a href="/invoices/{{$i['uid']}}/xml" class="btn btn-sm btn-success"><i class="fa fa-file-code"></i></a>
                            <!--<a href="/invoices/{{$i['uid']}}/pdf" class="btn btn-sm btn-danger"><i class="fa fa-file-pdf"></i></a> -->
                            <!--<a href="/stamp/{{$i['uid']}}/{{$rfcEmisor}}" class="btn btn-sm btn-danger"><i class="fa fa-file-invoice"></i></a> -->
                        </td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="thead-light">
                    <tr>
                        <th scope="col" colspan="13">
                            <div class="btn-toolbar d-flex justify-content-end" role="toolbar">
                                <div class="btn-group" role="group">
                                </div>
                            </div>
                        </th>
                    </tr>
                </tfoot>
            </table>

            <!-- Modal -->
            <div class="modal fade" id="emailModal" tabindex="-1" role="dialog">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Envíar recibos</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="email">Dirección de email</label>
                            <input class="form-control" name="email" id="email">
                            <small id="emailHelp" class="form-text text-muted">Puede enviar varios emails, separandolos por commas (,).</small>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-times mr-2"></i>Cerrar</button>
                        <button name="action" value="send" type="submit" class="btn btn-primary"><i class="fa fa-envelope mr-2"></i>Enviar</button>
                    </div>
                    </div>
                </div>
            </div>
        </form>
        @include('components.footer')
        <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
    </body>
</html>
