<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>{{ $businessClient->name }}</title>
        <style>
            .center-title {
                text-align:center;
                font-size:14px;
            }
            .left-title {
                text-align:left;
                font-size:14px;
            }
            .right-title {
                text-align:right;
                font-size:14px;
            }
            .center-font-content {
                text-align:center;
                font-size:11px;
            }
            .right-font-content {
                text-align:right;
                font-size:11px;
            }
            .left-font-content {
                text-align:left;
                font-size:11px;
            }
            .title-table {
                background-color: #000000;
                color: #FFFFFF;
            }
        </style>
    </head>

    <body>  
        <table style="width:100%">
            <tr>
                <td style="width:50%"></td>
                <td style="width:50%;"></td>
            </tr>
            <tr>
                <td>
                    @if ($businessClient->image && strlen($businessClient->image) > 0)
                        <img src="https://bb.silifalcon.com/assets/{{ $businessClient->image }}">
                    @endif
                </td>
                <td>
                    <table style="width:100%">
                        <tr>
                            <td class="left-title"><strong>{{ 'Folio: ' . $invoice->code }}</strong></td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <table style="width:100%">
            <tr>
                <td style="width:50%"></td>
                <td style="width:50%;"></td>
            </tr>
            <tr>
                <td class="left-title">
                    <strong>Emisor</strong>
                </td>
                <td class="left-title">
                    <strong>Receptor</strong>
                </td>
            </tr>
            <tr>
                <td class="left-title">
                    <strong>RFC:</strong> {{ $invoice->emissor->rfc }}
                </td>
                <td class="left-title">
                    <strong>RFC:</strong> {{ $invoice->receiver->rfc }}
                </td>
            </tr>
            <tr>
                <td class="left-title">
                    <strong>Nombre:</strong> {{ $invoice->emissor->name }}
                </td>
                <td class="left-title">
                    <strong>Nombre:</strong> {{ $invoice->receiver->name }}
                </td>
            </tr>
            <tr>
                <td class="left-title">
                    <strong>Régimen:</strong> {{ $invoice->invoiceTaxRegime->description }}
                </td>
                <td class="left-title">
                    <strong>Uso CFDI:</strong> {{ $invoice->invoiceUse->description }}
                </td>
            </tr>
            <tr>
                <td class="left-title">
                </td>
                <td class="left-title">
                    <strong>Tipo de comprobante:</strong> {{ $invoice->invoiceType->code . ' - ' . $invoice->invoiceType->description }}
                </td>
            </tr>
            <tr>
                <td>
                </td>
                <td>
                    @if ($invoice->receiver->address) 
                        <strong>Domicilio:</strong> {{ $invoice->receiver->address }}
                    @endif
                </td>
            </tr>
        </table> 
        <table style="width:100%">
            <tr>
                <td style="width:50%"></td>
                <td style="width:50%;"></td>
            </tr>
            <tr>
                <td colspan="2" class="center-title">
                    <strong>Información del comprobante</strong>
                </td>
            </tr>
            <tr>
                <td class="left-font-content">
                    <strong>Folio Fiscal:</strong> {{ $invoice->uuid }}
                </td>
                <td class="left-font-content">
                    <strong>Forma de pago:</strong> {{  $invoice->invoicePayType->code . ' - '. $invoice->invoicePayType->description }}
                </td>
            </tr>
            <tr>
                <td class="left-font-content">
                    <strong>Número de certificado:</strong> {{ $stamp['certificadoSAT'] }}
                </td>
                <td class="left-font-content">
                    <strong>Fecha de pago:</strong> {{ $invoice->payments[0]->payment_at->format('Y-m-d\TH:i:s') }}
                </td>
            </tr>
            <tr>
                <td class="left-font-content">
                    <strong>Fecha de emisión:</strong> {{ $invoice->invoice_at->format('Y-m-d\TH:i:s') }}
                </td>
                <td class="left-font-content">
                    <strong>Moneda:</strong> MXN - Peso Mexicano
                </td>
            </tr>
            <tr>
                <td class="left-font-content">
                    <strong>Fecha de certificación:</strong> {{ $invoice->stamped_at ? $invoice->stamped_at->format('Y-m-d\TH:i:s') : '' }}
                </td>
                <td class="left-font-content">
                    <strong>Total:</strong> {{ '$ ' . number_format($invoice->total, 2) }}
                </td>
            </tr>
            <tr>
                <td class="left-font-content">
                    <strong>Lugar de expedición:</strong> {{ $invoice->businessBranch->postal_code }}
                </td>
                <td class="left-font-content">
                    
                </td>
            </tr>
        </table>
        <br>
        
        <table style="width:100%">
        @for ($i = 0; $i < count($invoice->payments); $i++)
            <tr>
                <td class="center-title" bgcolor="#000000" colspan="4">
                    <strong><font color="white">DOCUMENTO RELACIONADO {{ $i + 1 }}</font></strong>
                </td>
            </tr>
            <tr>
                <td class="left-font-content">
                    <strong>Id Documento</strong>
                </td>
                <td class="left-font-content">
                    {{ $invoice->payments[$i]->invoiceRelated->uuid }}
                </td>
                <td class="left-font-content">
                    <strong>Moneda</strong>
                </td>
                <td class="left-font-content">
                    MXN - Peso Mexicano
                </td>
            </tr>
            <tr>
                <td style="border-top: 1px solid;" colspan="4"></td>
            </tr>
            <tr>
                <td class="left-font-content">
                    <strong>Método de Pago</strong>
                </td>
                <td class="left-font-content">
                    PPD - Pago en parcialidades o diferido
                </td>
                <td class="left-font-content">
                    <strong>Num. Parcialidad</strong>
                </td>
                <td class="left-font-content">
                    {{ $invoice->payments[$i]->parciality }}
                </td>
            </tr>
            <tr>
                <td style="border-top: 1px solid;" colspan="4"></td>
            </tr>
            <tr>
                <td class="left-font-content">
                    <strong>Imp. Saldo Ant.</strong>
                </td>
                <td class="left-font-content">
                    {{ '$ ' . number_format($invoice->payments[$i]->last_amount, 2) }}
                </td>
                <td class="left-font-content">
                    <strong>Imp. Pagado</strong>
                </td>
                <td class="left-font-content">
                    {{ '$ ' . number_format($invoice->payments[$i]->amount, 2) }}
                </td>
            </tr>
            <tr>
                <td style="border-top: 1px solid;" colspan="4"></td>
            </tr>
            <tr>
                <td class="left-font-content">
                    <strong>Imp. Saldo Insoluto</strong>
                </td>
                <td class="left-font-content">
                    {{ '$ ' . number_format($invoice->payments[$i]->carried_amount, 2) }}
                </td>
                <td class="left-font-content">
                </td>
                <td class="left-font-content">                    
                </td>
            </tr>
            <tr>
                <td style="border-top: 1px solid;" colspan="4"></td>
            </tr>
        @endfor
        </table>
        
        <br>

        <table style="width:100%">
            <tr>
                <td class="center-title" bgcolor="#000000" colspan="5">
                    <strong><font color="white">CONCEPTOS</font></strong>
                </td>
            </tr>
            <tr>
                <td class="center-title" bgcolor="#000000">
                    <strong><font color="white">Cantidad</font></strong>
                </td>
                <td class="center-title" bgcolor="#000000">
                    <strong><font color="white">Unidad</font></strong>
                </td>
                <td class="center-title" bgcolor="#000000">
                    <strong><font color="white">Descripción</font></strong>
                </td>
                <td class="center-title" bgcolor="#000000">
                    <strong><font color="white">Precio Unitario</font></strong>
                </td>
                <td class="center-title" bgcolor="#000000">
                    <strong><font color="white">Importe</font></strong>
                </td>
            </tr>
            <tr>
                <td class="right-title">
                    1.00
                </td>
                <td class="center-title">
                    ACT
                </td>
                <td class="left-title">
                    Pago
                </td>
                <td class="right-title">
                    0.00
                </td>
                <td class="right-title">
                    0.00
                </td>
            </tr>
            <tr>
                <td class="left-title" colspan="2">
                </td>
                <td class="left-title" colspan="3">
                    Clave Prod - Serv - 84111506 Servicios de facturaciòn
                </td>
            </tr>
        </table>
        <br>

        <table style="width:100%">
            <tr>
                <td style="width:20%"></td>
                <td style="width:80%"></td>
            </tr>
            <tr>
                <td colspan="2" class="left-title">
                <strong>Sello digital del CFDI:</strong>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                <div style="word-wrap: break-word;" class="left-font-content">
                <font color="#114781">{{ $stamp['sello'] }} </font>
                </div>
                </td>
            </tr>
            <tr>
                <td>
                    <table style="width:100%">
                        <tr>
                            <td>
                                @if ($stamp['qrcode'])
                                    <img src="data:image/png;base64,{{ $stamp['qrcode'] }}" width="120px" height="120px">
                                @endif
                            </td>
                        </tr>
                    </table>
                </td>
                <td>
                    <table style="width:100%">
                        <tr>
                            <td colspan="2" class="left-title">
                            <strong>Sello del SAT:</strong>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                            <div style="word-wrap: break-word;" class="left-font-content">
                            <font color="#114781">{{ $stamp['selloSAT'] }} </font>
                            </div>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" class="left-title">
                            <strong>Cadena original del complemento de certificación digital del SAT:</strong>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                            <div style="word-wrap: break-word;" class="left-font-content">
                            <font color="#114781">
                                {{ $stamp['originalString'] }}
                            </font>
                            </div>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td colspan="2" class="title">
                <strong>===== Este documento es una representación impresa de un CFDI =====</strong>
                </td>
            </tr>
        </table>
    </body>
</html>
