<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>{{ $businessClient->name }}</title>
        <style>
            .center-title {
                text-align:center;
                font-size:14px;
            }
            .left-title {
                text-align:left;
                font-size:14px;
            }
            .right-title {
                text-align:right;
                font-size:14px;
            }
            .center-font-content {
                text-align:center;
                font-size:11px;
            }
            .right-font-content {
                text-align:right;
                font-size:11px;
            }
            .left-font-content {
                text-align:left;
                font-size:11px;
            }
            .title-table {
                background-color: #000000;
                color: #FFFFFF;
            }
        </style>
    </head>

    <body>  
        <table style="width:100%">
            <tr>
                <td style="width:50%"></td>
                <td style="width:50%;"></td>
            </tr>
            <tr>
                <td>
                    @if ($businessClient->image && strlen($businessClient->image) > 0)
                        <img src="https://bb.silifalcon.com/assets/{{ $businessClient->image }}">
                    @endif
                </td>
                <td>
                    <table style="width:100%">
                        <tr>
                            <td class="right-title"><strong>{{ 'Folio: ' . $invoice->code }}</strong></td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <table style="width:100%">
            <tr>
                <td style="width:50%"></td>
                <td style="width:50%;"></td>
            </tr>
            <tr>
                <td class="left-title">
                    <strong>Emisor</strong>
                </td>
                <td class="left-title">
                    <strong>Receptor</strong>
                </td>
            </tr>
            <tr>
                <td class="left-title">
                    <strong>RFC:</strong> {{ $invoice->emissor->rfc }}
                </td>
                <td class="left-title">
                    <strong>RFC:</strong> {{ $invoice->receiver->rfc }}
                </td>
            </tr>
            <tr>
                <td class="left-title">
                    <strong>Nombre:</strong> {{ $invoice->emissor->name }}
                </td>
                <td class="left-title">
                    <strong>Nombre:</strong> {{ $invoice->receiver->name }}
                </td>
            </tr>
            <tr>
                <td class="left-title">
                    <strong>Régimen:</strong> {{ $invoice->invoiceTaxRegime->description }}
                </td>
                <td class="left-title">
                    <strong>Uso CFDI:</strong> {{ $invoice->invoiceUse->description }}
                </td>
            </tr>
            <tr>
                <td class="left-title">
                </td>
                <td class="left-title">
                    @if ($invoice->receiver->address) 
                        <strong>Domicilio:</strong> {{ $invoice->receiver->address }}
                    @endif
                </td>
            </tr>
        </table> 
        <table style="width:100%">
            <tr>
                <td style="width:50%"></td>
                <td style="width:50%;"></td>
            </tr>
            <tr>
                <td colspan="2" class="center-title">
                    <strong>Información del comprobante</strong>
                </td>
            </tr>
            <tr>
                <td class="left-font-content">
                    <strong>Folio Fiscal:</strong> {{ $invoice->uuid }}
                </td>
                <td class="left-font-content">
                    <strong>Tipo de comprobante:</strong> {{ $invoice->invoiceType->code . ' - ' . $invoice->invoiceType->description }}
                </td>
            </tr>
            <tr>
                <td class="left-font-content">
                    <strong>Número de certificado:</strong> {{ $stamp['certificadoSAT'] }}
                </td>
                <td class="left-font-content">
                    <strong>Forma de pago:</strong> {{  $invoice->invoicePayType->code . ' - '. $invoice->invoicePayType->description }}
                </td>
            </tr>
            <tr>
                <td class="left-font-content">
                    <strong>Fecha de emisión:</strong> {{ $invoice->invoice_at->format('Y-m-d\TH:i:s') }}
                </td>
                <td class="left-font-content">
                    <strong>Método de pago:</strong> {{ $invoice->pay_method . ' - ' . $invoice->getPayMethodDescription() }}
                </td>
            </tr>
            <tr>
                <td class="left-font-content">
                    <strong>Fecha de certificación:</strong> {{ $invoice->stamped_at ? $invoice->stamped_at->format('Y-m-d\TH:i:s') : '' }}
                </td>
                <td class="left-font-content">
                    <strong>Moneda:</strong> MXN - Peso Mexicano
                </td>
            </tr>
            <tr>
                <td class="left-font-content">
                    <strong>Lugar de expedición:</strong> {{ $invoice->businessBranch->postal_code }}
                </td>
                <td class="left-font-content">
                </td>
            </tr>
        </table>
        <table style="width:100%">
            <tr>
                <td style="width:10%"></td>
                <td style="width:13%"></td>
                <td style="width:13%"></td>
                <td style="width:38%"></td>
                <td style="width:13%"></td>
                <td style="width:13%"></td>
            </tr>
            <tr>
                <td colspan="6" class="center-title">
                    <strong>Conceptos</strong>
                </td>
            </tr>
            <tr>
                <td class="left-font-content">
                    <strong>Cantidad</strong>
                </td>
                <td class="left-font-content">
                    <strong>Clave de producto o servicio</strong>
                </td>
                <td class="left-font-content">
                    <strong>Clave de unidad</strong>
                </td>
                <td class="left-font-content">
                    <strong>Descripción</strong>
                </td>
                <td class="left-font-content">
                    <strong>Precio unitario</strong>
                </td>
                <td class="right-font-content">
                    <strong>Importe</strong>
                </td>
            </tr>
            <tr>
                <td colspan="6" style="border-top: 1px solid;"></td>
            </tr>
            @foreach ($invoice->invoiceConcepts as $concept)
            @if ($concept->getDescription()) 
            <tr>
                <td class="left-font-content">
                    1
                </td>
                <td class="left-font-content">
                    {{ $concept->getCode() }}
                </td>
                <td class="left-font-content">
                    {{ $concept->code }}
                </td>
                <td class="left-font-content">
                    {{ $concept->getDescription() }}
                </td>
                <td class="left-font-content">
                    $ {{ number_format($concept->subtotal, 2) }}
                </td>
                <td class="right-font-content">
                    $ {{ number_format($concept->subtotal, 2) }}
                </td>
            </tr>
            @endif
            @endforeach
        </table>
        <table style="width:100%">
            <tr>
                <td style="width:20%"></td>
                <td style="width:15%"></td>
                <td style="width:15%"></td>
                <td style="width:15%"></td>
                <td style="width:15%"></td>
                <td style="width:23%"></td>
            </tr>
            <tr>
                <td></td>
                <td class="left-font-content">
                    <strong>Clave</strong>
                </td>
                <td class="left-font-content">
                    <strong>Impuesto</strong>
                </td>
                <td class="left-font-content">
                    <strong>Tasa o cuota</strong>
                </td>
                <td class="left-font-content">
                    <strong>Importe</strong>
                </td>
                <td></td>
            </tr>
            <tr>
                <td></td>
                <td colspan="4" style="border-top: 1px solid;"></td>
                <td></td>
            </tr>
            <tr>
                <td></td>
                <td class="left-font-content">
                    002
                </td>
                <td class="left-font-content">
                    IVA
                </td>
                <td class="left-font-content">
                    0.160000
                </td>
                <td class="left-font-content">
                    $ {{ number_format($invoice->total - $invoice->subtotal, 2) }}
                </td>
                <td></td>
            </tr>
        </table>
        <table style="width:100%">
            <tr>
                <td style="width:65%"></td>
                <td style="width:20%"></td>
                <td style="width:15%"></td>
            </tr>
            <tr>
                <td class="left-font-content">
                    Importe con letra: {{ $totalString }}
                </td>
                <td class="right-font-content">
                    Subtotal:
                </td>
                <td class="right-font-content">
                    $ {{ number_format($invoice->subtotal, 2) }}
                </td>
            </tr>
            <tr>
                <td class="left-font-content">
                </td>
                <td class="right-font-content">
                    Total Traslados IVA:
                </td>
                <td class="right-font-content">
                    $ {{ number_format($invoice->total - $invoice->subtotal, 2) }}
                </td>
            </tr>
            @if ($invoice->receiver->applyRetention())
            <tr>
                <td class="left-font-content">
                </td>
                <td class="right-font-content">
                    Retención I.V.A.:
                </td>
                <td class="right-font-content">
                    $ {{ number_format($invoice->retention, 2) }}
                </td>
            </tr>
            @endif
            <tr>
                <td class="left-font-content">
                </td>
                <td class="right-font-content">
                    <strong>Total:</strong>
                </td>
                <td class="right-font-content">
                    <strong>$ {{ number_format($invoice->calcTotalNeto(), 2) }}</strong>
                </td>
            </tr>
        </table>
        <br>
        <table style="width:100%">
            <tr>
                <td style="width:20%"></td>
                <td style="width:80%"></td>
            </tr>
            <tr>
                <td colspan="2" class="left-title">
                <strong>Sello digital del CFDI:</strong>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                <div style="word-wrap: break-word;" class="left-font-content">
                <font color="#114781">{{ $stamp['sello'] }} </font>
                </div>
                </td>
            </tr>
            <tr>
                <td>
                    <table style="width:100%">
                        <tr>
                            <td>
                                @if ($stamp['qrcode'])
                                    <img src="data:image/png;base64,{{ $stamp['qrcode'] }}" width="150px" height="150px">
                                @endif
                            </td>
                        </tr>
                    </table>
                </td>
                <td>
                    <table style="width:100%">
                        <tr>
                            <td colspan="2" class="left-title">
                            <strong>Sello del SAT:</strong>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                            <div style="word-wrap: break-word;" class="left-font-content">
                            <font color="#114781">{{ $stamp['selloSAT'] }} </font>
                            </div>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" class="left-title">
                            <strong>Cadena original del complemento de certificación digital del SAT:</strong>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                            <div style="word-wrap: break-word;" class="left-font-content">
                            <font color="#114781">
                                {{ $stamp['originalString'] }}
                            </font>
                            </div>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td colspan="2" class="title">
                <strong>===== Este documento es una representación impresa de un CFDI =====</strong>
                </td>
            </tr>
        </table>
    </body>
</html>
