<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>{{ $businessClient->name }}</title>
        <style>
            .title {
                text-align:center;
                font-size:14px;
            }
            .left-title {
                text-align:left;
                font-size:14px;
            }
            .right-title {
                text-align:right;
                font-size:14px;
            }
            .center-font-content {
                text-align:center;
                font-size:11px;
            }
            .right-font-content {
                text-align:right;
                font-size:11px;
            }
            .left-font-content {
                text-align:left;
                font-size:11px;
            }
            .title-table {
                background-color: #000000;
                color: #FFFFFF;
            }
        </style>
    </head>

    <body>  
        <table style="width:100%">
            <tr>
                <td style="width:40%"></td>
                <td style="width:60%;"></td>
            </tr>
            <tr>
                <td>
                    <table style="width:100%">  
                        <tr>
                            <td>
                                @if ($businessClient->image && strlen($businessClient->image) > 0)
                                    <img src="https://bb.silifalcon.com/assets/{{ $businessClient->image }}">
                                @endif
                            </td>
                        </tr>
                    </table>
                    <table>
                        <tr>
                            <td>
                                <td class="left-font-content"><strong><font color="#07641e">EMPRESA:</font></strong> <font color="#114781">{{ $businessClient->name }}</font></td>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <td class="left-font-content"><strong>RFC:</strong> <font color="#114781">{{ $payroll->payroll->rfc }}</font></td>
                            </td>
                        </tr>
                            <td>
                                <td class="left-font-content"><strong>RÉGIMEN:</strong> <font color="#114781">601 - General de Ley Personas Morales</font></td>
                            </td>
                        </tr>
                    </table>
                </td>
                <td>
                    <table style="width:100%">
                        <tr>
                            <td style="width:50%"></td>
                            <td style="width:50%;"></td>
                        </tr>   
                        <tr>
                            <td colspan="2" class="title"><strong><font color="#07641e">RECIBO DE NÓMINA.</font></strong> <font color="#ab1111">FOLIO: {{$payroll->code}}</font></td>
                        </tr>
                        <tr>
                            <td colspan="2" class="left-font-content"><strong>FOLIO FISCAL: </strong><font color="#114781">{{ $payroll->uuid }}</font></td>
                        </tr>
                        <tr>
                            <td class="left-font-content"><strong>CERTIFICADO SAT:</strong></td>
                            <td class="right-font-content"><strong>TIPO DE CONTRATO:</strong></td>
                        </tr>
                        <tr>
                            <td class="left-font-content"><font color="#114781">{{ $stamp['certificadoSAT'] }}</font></td>
                            <td class="right-font-content"><font color="#114781">99 - Otro Contrato</font></td>
                        </tr>
                        <tr>
                            <td class="left-font-content"><strong>CERTIFICADO DEL EMISOR:</strong></td>
                            <td class="right-font-content"><strong>RÉGIMEN FISCAL:</strong></td>
                        </tr>
                        <tr>
                            <td class="left-font-content"><font color="#114781">{{ $stamp['noCertificado'] }}</font></td>
                            <td class="right-font-content"><font color="#114781">11 - Asimilados Otros</font></td>
                        </tr>
                        <tr>
                            <td class="left-font-content"><strong>LUGAR DE EXPEDICIÓN:</strong></td>
                            <td class="right-font-content"><strong>USO CFDI:</strong></td>
                        </tr>
                        <tr>
                            <td class="left-font-content"><font color="#114781">{{ $payroll->payroll->postal_code }}</font></td>
                            <td class="right-font-content"><font color="#114781">P01 - Por definir</font></td>
                        </tr>
                        <tr>
                            <td class="left-font-content"><strong>FECHA HORA DE CERTIFICACIÓN:</strong></td>
                            <td class="right-font-content"><strong>FECHA HORA DE EMISION:</strong></td>
                        </tr>
                        <tr>
                            <td class="left-font-content"><font color="#114781">{{ ($payroll->stamped_at ? $payroll->stamped_at : new DateTime())->format('Y-m-d\TH:i:s') }}</font></td>
                            <td class="right-font-content"><font color="#114781"> {{ $payroll->invoice_date->format('Y-m-d\TH:i:s') }}</font></td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table> 
        <br>
        <table style="width:100%">
            <tr>
                <td class="center-font-content">
                    <font color="#c7c7c7">RECIBO DE NÓMINA VERSIÓN 1.2</font>
                </td>
                <td class="center-font-content">
                    <font color="#c7c7c7">CFDI 3.3</font>
                </td>
            <tr>
        </table>
        <br>
        <table style="width:100%">
            <tr>
                <td style="width:20%;"></td>
                <td style="width:36%"></td>
                <td style="width:20%;"></td>
                <td style="width:24%;"></td>
            </tr>   
            <tr>
                <td class="left-font-content"><strong>No. Empleado: </strong><font color="#114781">{{ $payroll->num_empleado }}</font></td>
                <td class="left-font-content"><strong>Nombre: </strong><font color="#114781">{{ $payroll->getFullName() }}</font></td>
                <td class="left-font-content"><strong>RFC: </strong><font color="#114781">{{ $payroll->rfc }}</font></td>
                <td class="right-font-content"><strong>Curp: </strong><font color="#114781">{{ $payroll->curp }}</font></td>
            </tr>
        </table>
        <br>
        <table style="width:100%">  
            <tr>
                <td class="left-font-content"><strong>Cantidad</strong></td>
                <td class="left-font-content"><strong>Clave Unidad</strong></td>
                <td class="left-font-content"><strong>Tipo de nómina:</strong></td>
                <td class="left-font-content"><strong>Concepto</strong></td>
                <td class="left-font-content"><strong>Descripción</strong></td>
            </tr>
            <tr>
                <td class="left-font-content"><font color="#114781">1</font></td>
                <td class="left-font-content"><font color="#114781">ACT</font></td>
                <td class="left-font-content"><font color="#114781">O - Ordinaria</font></td>
                <td class="left-font-content"><font color="#114781">84111505</font></td>                
                <td class="left-font-content"><font color="#114781">Pago de nómina</font></td>
            </tr>
            <tr>
                <td class="left-font-content"><strong>Valor unitario</strong></td>
                <td class="left-font-content"><strong>Descuento</strong></td>
                <td class="left-font-content"><strong>Importe</strong></td>
                <td class="left-font-content"><strong>Periodicidad de pago:</strong></td>
                <td></td>
            </tr>
                <td class="left-font-content"><font color="#114781">{{ $payroll->subtotal }}</font></td>
                <td class="left-font-content"><font color="#114781">{{ $payroll->isr }}</font></td>
                <td class="left-font-content"><font color="#114781">{{ $payroll->subtotal }}</font></td>
                <td class="left-font-content"><font color="#114781">{{ $payroll->getPeriodLegend() }}</font></td>
                <td></td>
            </tr>
        </table>
        <br>
        <table style="width:100%">
            <tr>
                <td style="width:50%;"></td>
                <td style="width:10%;"></td>
                <td style="width:40%;"></td>
            </tr>
            <tr>
                <td>
                    <table style="width:100%">  
                        <tr>
                            <td class="left-font-content"><strong>PERCEPCIONES:</strong></td>    
                        </tr>
                    </table>
                    <table style="width:100%">  
                        <tr>
                            <td style="width:20%;"></td>
                            <td style="width:60%;"></td>
                            <td style="width:20%;"></td>
                        </tr>
                        <tr>
                            <td class="left-font-content">CLAVE</td>
                            <td class="left-font-content">CONCEPTO</td>
                            <td class="right-font-content">IMPORTE</td>
                        </tr>
                        <tr>
                            <td class="left-font-content"><font color="#114781">046</font></td>
                            <td class="left-font-content"><font color="#114781">Pago</font></td>
                            <td class="right-font-content"><font color="#114781">{{ number_format($payroll->subtotal, 2) }}</font></td>
                        </tr>
                        <tr>
                            <td class="left-font-content"></td>
                            <td class="right-font-content">TOTAL DE PERCEPCIONES:</td>
                            <td class="right-font-content"><font color="#114781">{{ number_format($payroll->subtotal, 2) }}</font></td>
                        </tr>
                    </table>
                    <table style="width:100%">  
                        <tr>
                            <td class="left-font-content"><strong>DEDUCCIONES:</strong></td>    
                        </tr>
                    </table>
                    <table style="width:100%">  
                        <tr>
                            <td style="width:20%;"></td>
                            <td style="width:60%;"></td>
                            <td style="width:20%;"></td>
                        </tr>
                        <tr>
                            <td class="left-font-content">CLAVE</td>
                            <td class="left-font-content">CONCEPTO</td>
                            <td class="right-font-content">IMPORTE</td>
                        </tr>
                        <tr>
                            <td class="left-font-content"><font color="#114781">002</font></td>
                            <td class="left-font-content"><font color="#114781">Pago</font></td>
                            <td class="right-font-content"><font color="#114781">{{ number_format($payroll->isr, 2) }}</font></td>
                        </tr>
                        <tr>
                            <td class="left-font-content"></td>
                            <td class="right-font-content">TOTAL DE DEDUCCIONES:</td>
                            <td class="right-font-content"><font color="#114781">{{ number_format($payroll->isr, 2) }}</font></td>
                        </tr>
                    </table>
                </td>
                <td></td>
                <td>
                    <table style="width:100%">  
                        <tr>
                            <td style="width:50%"></td>
                            <td style="width:50%"></td>
                        </tr>
                        <tr>
                            <td class="left-font-content">Fecha de pago:</td>
                            <td class="right-font-content"><font color="#114781">{{ $payroll->pay_date->format('d/m/Y') }}</font></td>
                        </tr>
                        <tr>
                            <td class="left-font-content">Fecha inicial de pago:</td>
                            <td class="right-font-content"><font color="#114781">{{ $payroll->pay_init->format('d/m/Y') }}</font></td>
                        </tr>
                        <tr>
                            <td class="left-font-content">Fecha final de pago:</td>
                            <td class="right-font-content"><font color="#114781">{{ $payroll->pay_end->format('d/m/Y') }}</font></td>
                        </tr>
                        <tr>
                            <td class="left-font-content">Núm. de días pagados:</td>
                            <td class="right-font-content"><font color="#114781">{{ $payroll->work_days }}</font></td>
                        </tr>
                        <tr>
                            <td class="left-font-content">Total de percepciones:</td>
                            <td class="right-font-content"><font color="#114781">{{ number_format($payroll->subtotal, 2) }}</font></td>
                        </tr>
                        <tr>
                            <td class="left-font-content">Total de deducciones:</td>
                            <td class="right-font-content"><font color="#114781">{{ number_format($payroll->isr, 2) }}</font></td>
                        </tr>
                        <tr>
                            <td class="left-font-content">Neto recibido:</td>
                            <td class="right-font-content"><font color="#114781">{{ number_format($payroll->total, 2) }}</font></td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <br>
        <table style="width:100%">  
            <tr>
                <td class="left-title"><strong>CANTIDAD CON LETRA (NETO RECIBIDO):</strong></td>
            </tr>
            <tr>
                <td class="left-font-content"><font color="#114781">{{ $totalString }}</font></td>
            </tr>
        </table>
        <br>
        <table style="width:100%">  
            <tr>
                <td style="width:50%"></td>
                <td style="width:50%"></td>
            </tr>
            <tr>
                <td></td>
                <td class="left-title"><strong>Moneda: MXP - Peso Mexicano</strong></td>
            </tr>
            <tr>
                <td></td>
                <td class="left-title"><strong>Forma de pago: 99 - Por definir</strong></td>
            </tr>
            <tr>
                <td></td>
                <td class="left-title"><strong>Método de pago: PUE - Pago en una sola exhibición</strong></td>
            </tr>
        </table>
        <table style="width:100%">
            <tr>
                <td style="width:20%"></td>
                <td style="width:80%"></td>
            </tr>
            <tr>
                <td colspan="2" class="left-title">
                <strong>Sello digital del CFDI:</strong>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                <div style="word-wrap: break-word;" class="left-font-content">
                <font color="#114781">{{ $stamp['sello'] }} </font>
                </div>
                </td>
            </tr>
            <tr>
                <td>
                    <table style="width:100%">
                        <tr>
                            <td>
                                @if ($stamp['qrcode'])
                                    <img src="data:image/png;base64,{{ $stamp['qrcode'] }}" width="120px" height="120px">
                                @endif
                            </td>
                        </tr>
                    </table>
                </td>
                <td>
                    <table style="width:100%">
                        <tr>
                            <td colspan="2" class="left-title">
                            <strong>Sello del SAT:</strong>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                            <div style="word-wrap: break-word;" class="left-font-content">
                            <font color="#114781">{{ $stamp['selloSAT'] }} </font>
                            </div>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" class="left-title">
                            <strong>Cadena original del complemento de certificación digital del SAT:</strong>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                            <div style="word-wrap: break-word;" class="left-font-content">
                            <font color="#114781">
                                {{ $stamp['originalString'] }}
                            </font>
                            </div>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td colspan="2" class="title">
                <strong>===== Este documento es una representación impresa de un CFDI =====</strong>
                </td>
            </tr>
        </table>
    </body>
</html>
