<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
        <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.8.2/css/all.css" integrity="sha384-oS3vJWv+0UjzBfQzYUhtDYW+Pj2yciDJxpsK1OYPAYjqT085Qq/1cq5FLXAZQ7Ay" crossorigin="anonymous">
        <style>
            .center-title {
                text-align:center;
                font-size:14px;
            }
            .left-title {
                text-align:left;
                font-size:12px;
            }
            .right-title {
                text-align:right;
                font-size:14px;
            }
            .center-font-content {
                text-align:center;
                font-size:11px;
            }
            .right-font-content {
                text-align:right;
                font-size:11px;
            }
            .left-font-content {
                text-align:left;
                font-size:8px;
            }
            .title-table {
                background-color: #000000;
                color: #FFFFFF;
            }
        </style>
    </head>
    
    <body>
        <p>
        El usuario <strong>{{ $user->user_name }}</strong> del consorcio <strong>{{ $partnership->name }} </strong> realizo cambios bancarios
        </p>

        <table class="table">
            <thead class="thead-dark">
                <tr>
                    <th scope="col">Num. Empleado</th>
                    <th scope="col">Empleado</th>
                    <th scope="col">Banco anterior</th>
                    <th scope="col">Banco actual</th>
                    <th scope="col">No cuenta anterior</th>
                    <th scope="col">No cuenta actual</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($data as $record)
                <tr>
                    <td>{{ $record['employeeNumber'] }}</td>
                    <td>{{ $record['employee'] }}</td>
                    <td> {{ $record['previousBank'] }}</td>
                    <td>{{ $record['currentBank'] }}</td>
                    <td>{{ $record['previousAccount'] }}</td>
                    <td>{{ $record['currentAccount'] }}</td>
                </tr>    
                @endforeach
            </tbody>
        </table>

        <table style="width:100%">
            <tr>
                <td style="width:50%"></td>
                <td style="width:50%;"></td>
            </tr>
            <tr>
                <td class="center-title">
                    <img src="data:image/jpeg;base64,/9j/4AAQSkZJRgABAQEAYABgAAD/4R/URXhpZgAASUkqAAgAAAAGABoBBQABAAAAVgAAABsBBQABAAAAXgAAACgBAwABAAAAAgAAADEBAgANAAAAZgAAADIBAgAUAAAAdAAAAGmHBAABAAAAiAAAAJoAAABgAAAAAQAAAGAAAAABAAAAR0lNUCAyLjEwLjE0AAAyMDIwOjAzOjEwIDIzOjI1OjU4AAEAAaADAAEAAAABAAAAAAAAAAgAAAEEAAEAAAAAAQAAAQEEAAEAAACUAAAAAgEDAAMAAAAAAQAAAwEDAAEAAAAGAAAABgEDAAEAAAAGAAAAFQEDAAEAAAADAAAAAQIEAAEAAAAGAQAAAgIEAAEAAADFHgAAAAAAAAgACAAIAP/Y/+AAEEpGSUYAAQEAAAEAAQAA/9sAQwAIBgYHBgUIBwcHCQkICgwUDQwLCwwZEhMPFB0aHx4dGhwcICQuJyAiLCMcHCg3KSwwMTQ0NB8nOT04MjwuMzQy/9sAQwEJCQkMCwwYDQ0YMiEcITIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIy/8AAEQgAlAEAAwEiAAIRAQMRAf/EAB8AAAEFAQEBAQEBAAAAAAAAAAABAgMEBQYHCAkKC//EALUQAAIBAwMCBAMFBQQEAAABfQECAwAEEQUSITFBBhNRYQcicRQygZGhCCNCscEVUtHwJDNicoIJChYXGBkaJSYnKCkqNDU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6g4SFhoeIiYqSk5SVlpeYmZqio6Slpqeoqaqys7S1tre4ubrCw8TFxsfIycrS09TV1tfY2drh4uPk5ebn6Onq8fLz9PX29/j5+v/EAB8BAAMBAQEBAQEBAQEAAAAAAAABAgMEBQYHCAkKC//EALURAAIBAgQEAwQHBQQEAAECdwABAgMRBAUhMQYSQVEHYXETIjKBCBRCkaGxwQkjM1LwFWJy0QoWJDThJfEXGBkaJicoKSo1Njc4OTpDREVGR0hJSlNUVVZXWFlaY2RlZmdoaWpzdHV2d3h5eoKDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uLj5OXm5+jp6vLz9PX29/j5+v/aAAwDAQACEQMRAD8A9Km+IdjC4Vre4JIzwi//ABVM/wCFk2H/AD7XP/ftf/iq8r1gAXyAdPLH8zVEgV7UcBSaPKeMqJnsB+Jmng4+zXX/AH7X/wCLo/4Wbp//AD63X/ftf/i68fop/wBn0ifrtQ9g/wCFmaf/AM+t1/37X/4uj/hZmn/8+t1/37X/AOLrx+jFH9n0g+u1D2D/AIWZp/8Az63P/ftf/i6P+Fmaf/z63P8A37X/AOLrx7ApcUf2fSD67UPZE+JFgzAfZrnB/wBhf/iq0bXxnp91tAhuQW9VX1x/erwrFHQ8Unl1N7Max0z6RtbqO8j8yMMB/tf59qnA5r5tgvLqyczWcoinyGDlQcMOh5Br0vwf8QUuitnq88gmCKplkSONCwU7jnI4JHp6Vx18BOmuZao6aWNhN2eh6RRUUU8dxCkkMiujKGBUggg9KlFcPkdnmIRk1zOteMrTRb6S2mhnd0KglFBHK57sK6c14r8S+PEF2f8AppH/AOixXRhKSq1OWRhiajpw5kdn/wALJ08Y/wBGuf8Av2v/AMVSH4l6eP8Al2uv+/a//FV49RXqf2fSOD67UPYP+Fm6f/z63X/ftf8A4uj/AIWZp/8Az63X/ftf/i68ewKWl/Z9IPrtQ9g/4WZp/wDz63X/AH7X/wCLo/4WZp//AD63X/ftf/i68foxR/Z9IPrtQ9g/4Wbp/wDz63X/AH7X/wCLpR8SdPJH+jXP/ftf/iq8exRR/Z9IPrtQ9utfHen3H/LC6HIH3F/+KrcstWgv1zEkgGcfOB/jXzqBilVirqw+8hyD71nPLYte6y446S+JH0xRXi3hLx7qGm3pg1m5kms2AWERRRgRqobhjgf7Pc9K9b03VLXVLSO5tZ0dHAOAwJBIBwcHrzXn18POi7SO2jXjVV0Xu9LSA0tYG4UUUUAfOms/8f6f9ch/M1Qq/rIxfp/1yH8zVCvp4fCj56e7CiikJA6kVZItFJuX+8Pzo3r/AHh+dAC0Um9f7w/Ojev94fnQAtFJuX1H50owe9ABSqSjBkOGHekPB9feilYZ6J8P/GFxJfDStRlTyyqpAzsqYCKxOOBnoO9epowdAykFSMgg5BFfNkEz211FdQttniz5b4zjIweDx0r3nwlqL6l4ctZZCDIsaIxBHJCLk8dOteNj6ChLnjsz08FWclyvc2zXi/xO41y6P/TSP/0WK9oNeMfFD/kM3P8A11j/APRYqMv/AIxpjf4Rx1FHeivdPHCikJx1pN6/3h+dIB1FN3L/AHh+dG5f7w/OmA6im7l/vD86Ny/3h+dADqKTIPQg0tILgRuGD0rovC3i+60K+gtZMGwJZ3LFUUHbgAsRx0HeudpsiLLGUYZB7VM6cai5ZFRm4PmifSGm3keo6fBdxMhSWNX+VgwGQD1/Grlee/DXWZJdMj0+VlOyUxx8gEKsa4GMc9K9Cr5yrT9nNxPdpT54KQUUUVmaHzxr4xqaAcfuR/6EazK1PEH/ACE0/wCuI/8AQjWX3r6en8KPnp7l/R9Gu9evDa2gzsdElfI/dh+hwSM9CePSvRNP+GCw2qpc3ccsg6s9sCep/wBo1mfCCNH1DXy6hiptipIzjiTpXrA4ry8Ziqkajpxei/yPQwlCEoc73OE/4Vra/wDPWD/wFX/Gj/hW1r/z1g/8BV/xrvKK4/rNXudfsKfY4P8A4Vta/wDPWD/wFX/Gj/hWtr/z1g/8BV/xrvKOKPrNXuH1en2OD/4Vtbf89YP/AAFX/Gua8YeA5tK0uXUbaVXWI72RYwnyhCTzu9vSvYqzfEFulz4d1KJ0DhrWUAEA87D61UMVVUk7kyw9NrY+aIdUQjEqbPxzj9KvKwdQynIIyDWPrEAtdburZRtWLZgfVQaSyu3ilCu5MZ/vZOMDtXuQndJvqeVOmlextV6p8L78zaTJEd2EunQZbPRFrypSHUMDkEZr0f4UZ+yz+n22X/0WtYY5J0WVhW1VSPUgMV4z8UuNVuD/ANNo/wD0XXswNeM/FYYv5j/03j/9FV52A/jI78dpRbONNLGpmuYbaMbpZ3Eca+rE4A/M0lXdBRX8VaOGUEC9h6j/AG1r25y5YtnlRV2kd1o/wwm+zrNeXa7pFRvLeANs4yRnd71rf8K1tP8AnrB/4CL/AI13SgAAAAAcAU6vAli6sne57McNTStY4P8A4Vra/wDPWD/wEX/Gj/hWtr/z1g/8BV/xrvKKn6zV7lewp9jg/wDhWtr/AM9YP/ARf8aP+Fa2v/PWD/wEX/Gu8oo+s1e4fV6fY8r8Q/DiSGwlurKZC0EUkhjSFU3EDIGd3tXlkt5NZXT211AUlTG4b92MjPb2NfUc0aywSRuMq6lSD3BFfOXxJtYrTxrexwoqKNnAAH/LNPSu3B4mcpcsmcuJw8UuaKKUNxHOpMbZxjPB4qWuehuJIHDIfqD0NbltKJ4VfjOOceuK9SMrnnyhY6vwLeNB4ltIQzAM0jYDED/Vn/Cvc6+f/B4P/CY2OOmJP/QGr3/HGK8fMUlUVux6eBd4P1HUUUV552nzx4h51SP/AK4j/wBCNZvYfWtbxP8A8hmP/r3H/oTVk9h9a+np/Cj56fxM9C+D/wDx/eIf+3b+Ulem3t1HZWktzM22OGNpHbBOABknivMfg9/x/wDiH/t2/lJXqVzEtxbSwsSFkQqSOuCMV4eN/ju/l+R62Dv7FW8/zOdj8caK6hhergjI/cyf4U//AITXRf8An9H/AH5k/wAK8e8S6C+ia5cM0iul1cSmPByQA2eeBz8wrJ2iuyGApSipKTOZ42pFtNHu/wDwmui/8/o/78yf4Uf8Jrov/P6v/fmT/CvCNoo2iq/s6n3Yvr0+x7x/wmmjf8/i/wDfl/8ACob3xjo8thcRi8BLxMo/dP3B9q8N2D3o2D3o/s6n3Yvr0+xU8RwSXXirUbqBd8Mvl7GzjOEAPB561lSQSxjLrgfUV0XSjNdqgkrHO6rbuzO0u485XjOMoABgfX/CvaPhhZGHSHkIPzXLN1HdFryE26ees+W3oSQO3Ne8+BSg8M2wTdkhSc+uxa48wk1SsdGDSlUudPXjPxYBF3Ke3nx/+iq9kU7hk1xvj/wmfEmmxxRyhJBcLIdzYGAjD0PrXnYOpGnVTkduLg50mkeN9qtaGQPFmiZ730P/AKGtU3YJO0L/AOsXkkdP881b0U/8VXon/X9D/wChrXvVNYM8eL95I+jDwufaucfxvosd3Pam9US27mORfJk+UgkEZxz0NdKvKD6V5R8TvD/keRqscmUV5XlVm5+ZlA2jHqe5r5/DwhUnyTPZr1JQhzRO0HjXRf8An9H/AH5k/wAKP+E10X/n9H/fmT/CvCAFZQVzgjvRtFel/ZtPuzi+vT7Hu/8Awmui/wDP6v8A35k/wpR410Y/8vq/9+ZP8K8H2ijYPej+zafdh9en2PeP+E00b/n8H/fl/wDCvF/iHKmreLru7sz5sT7MNjbnEaDoeeoNZ+we9OHArSlgoUpcyZE8XOas0YDWs6DJT9RUunTeXcrC2BuJJ/L/AOtW1UNxbJOh3Fhx2rq5dbmHPpY67wJaNN4jtJlBIDSDOR/zzP8AjXuIGK8t+GKQR28efM8xZmC4xjHljr+teoivDx0m6uvQ9XCRSp6Du9FJxmlHSuQ6UfPnif8A5DMf/XuP/QmrJ7D61r+J+NZjz/z7j/0JqyM8Cvp6fwI+fn8TPQPg/wD8hDxD/wBu38pK9XNeUfB7/kIeIf8At2/lJXq5rwsd/Hfy/JHrYL+Ev66nMeNfDz65ojpbIpukx5ZYtxllzwM9h6V4neWs+n3slndI0U0bFcOCu/BI3Lnkjg819KYwK4Xxp4HTWTJfWUMYvgiqrs7/AN8k8DI6E9q1weK9m+WWxGLw7muaO55BRUs1pd2p23VpPAxGQJoyhx681ECDXtJp6o8uz6hRR9RRTEFFFFABWho+tXeh3Sz20jKqszFURWYkjHes+jocjrUyipKz2KjJxd0fQ2ka3Za3bvNZShgrlSNyk8AHsT6itJenPWvEfA/iWLQLuaK6n8q1eNmGdoG8le5x2HSvbVYNyDkV8/iaDpTt0PaoVVVj5mXqvh3TNXhaO7thIpOSDIy9sdj6GsGH4a+HbfUbS9g05Vlt5VlRvtEpwykEHG7HauzPSmlgo5IFZxrVIqybsVKlBu7Wo8DAxVLUrCHUrKS1nQOj4yCxHQg9R9KJ9Y0y1/4+dSs4ev8ArJ1Xp16mmQa1pN5JttdUspm/ux3CMf0NQlJaltp6Hh3ifRrnRdYuklt3W3Z2eOUK2xULEKCxHt+orGGfWvf9f0Cy8QafJFNEsrOqqGMjAYDBv4TXiWoeG9Z0Nwl9aTSrtDmeGJjGoJwAWIGDkfqK9zCYpVI2lujyMTh3TldbMzqKMEHBIzRXacoUUUUAFFFFADoZZbaZZ7dwky/dYjOM8HrXsfgrxlFr0E0VzK6XSMzATqkZ2AKOgPqeuK8aqzY6pPpFy11blxIyeWSiBjjIPQ/SubE4dVo+ZvQrOlLyPo/v1pwrO0vUodV06K7tpVdJM4bIOcEjtx2rRHSvnmmnZntppq6PAPFoA16L/r2H/oTVidq2/F3/ACHov+vUf+hNWJX09P4EfPz+JnoHweONR8Qj3tv5SV6z3ryX4P8A/IS8Q/W1/lJXrXevDx/8d/L8j1sF/CQHpSEHscGnUmOa4zqMPV/Cek6z89zb5l2hA+9+ADnoCPU1wmqfC902mzvnQcZC2pb1/wBr6V6vRiuiliatP4WZVMPTqbo8HbwXq6kjyrtvf7I1N/4Q3V/+fa8/8BGr3naPQUFfat/7RqmH1GmfOupaFrGm7G/sq+mQgl3+zuAgGOTwf8islb2AsymSNXQ4ZS4yp9D6V9OSQRzIySxpIjAhlZQQQeoNec+Nvhjb6tALjR47aznVmZ0gtkQylmXq2R056+tb0cxu7TVjKeBtrFnlqzwMcCaPJ/2hUgIIyDketYWoadd6VfzWdypR45GiV9wO7acE8Hikgu5YCMs8gHYsa9GNRNXRxyp2NqeBbhAjcAHNe8+CNdfXfDVpdTgLcSCQsu4EjEhUcADsB2rwWC4S4UlDnBxXo/wwv9uqyWZLCOO1dgMnGd69vxrlx8FOlfsbYSThUt3PUbq4jtbSa4lZUSJGdmZsAADJye1eNeK/ibqt14ottC0CRYlnlWAXcJScZkCANtKnO0k8Z5xXo/j93j8Ba4yEhvsNxyDgj903NfPPw0vbSHX9L+37ZZri9gWB5FLEMJMcHBx1HpXDhaMXCVSSvY9CtNppI9qj8AXOp2cJ1jVzczeWCzG0EZ3EfNwrDqfyrm/E3gvVvC2nvqXh7VZIpIjyqWQk3AsFH3icYDHtXsfbPaq99bi7s5ICoYNjhhkHBBrnjXlGVy3Ti1c5L4Yalq2q+F55NZuGnuortog7QrGdoROMKB3JrrL/AE201O2e3vIvMifG5dxGcHI6H1FVNA0o6TbXUWFHm3LzAKoGAQPT6Vq1NSV5tx0KjH3bM831f4XW0gU2N0bc8ZxC0mevq30rk5/Amq28hUG6lA/iFmRn9a90NJtB6gGt4Y6tFWvc554OlJ3PBv8AhDNXz/x73n/gI1QXPhXWbeJ3WwvpSqlgotX5wOnSvoHHsKaVB4Kgg1osxqX1IeBgfMTztA4juojbS8jZKdrAjqMHuKVbmA/8tox/wMV7l4q8Dad4hsXjit7S1umO4XC2qs+SwJOeDzg9+9eD+J/C194X1SS2nHmw4LibKj5SxUfKCT2/Wu2hjI1dHozmqYRw1RaDKwyrBh7GlzXORzyoQyyPtHYMRWxa3yXBIZdjDnHWuxSuczhZHpfwu1+X7Y2gTEC3tbZ5FckDJMin0z/Ge9etCvnLSrt9Pumnj3LIyFSyNtJGR3H0r6LVg6hh0NeLj6ajU5l1PTwMm6dn0PAvF4xr8QP/AD6j/wBCasStzxn/AMjLCP8ApzH/AKG1YYr2KXwI8ufxM7/4P/8AIS8Q/W1/lJXrXc15J8IP+Qn4g+tr/J69crxMf/Hf9dD1sH/CQUUUVyHWFFFFABRRRQAUhAI5ANLRQB438Y9Bhs7ODV40iREeR5mSMAksyAZI5PJryJWDorr91hkH1Fe+fG1UPwx1NiBvXytpx0/fR5r5/tf+PK3/AOuS/wAq9nBPmopvuefiYJSuXrO6+zyEsTtI9e9emfDgn/hJLnHH+iN/6GleVYzXrnwitjdXhvHBKyWsg3Z64kUfXtWuJlakzCjH94rHpnimwOqeFdWsVba1xZzRK2M4LIwz+tfL502Xwtr8EDv5sulzRzAgbSx4kAGCcfXmvXfHnj+Y3zeHtGnQ3Ek8cT7VkR1R05IbIGcsMVhah8Oby68Nx6yPtk9/5U0lwZLhCDs4TJPJ4HqfwriwzdKNp6JnXWbn8HQ9T8J+J7XxDpNu0bETpBEZlO4kMy9MkDPIPNdIK+VdD8Tap4c1HNtcuBHKn2mN3bYuw9MAjI68c19HeGvEdl4i0uGe3nEkwhjedVRlCsy5wNw9QfWufE4d03dbGtGspqz3Nylqnf2YvrV4PtVzb78fvLeTY4wc8H9K8e8X+IvEvhLVorZLmZ4mgErNPOznJZl/hYccCsqVJ1HZGk58quz2z60d65vwZq13rGmTT3m3esxQbc9MKe5Pqa6Ss2rOxSd9RaKKKBjSK4z4ieHk1Tw7dzRQxNdBI0UmNd3+sBPzHp1NdpUN1HHLbOkqhozjIIyOtVCTjJNEzV07nyVPEYLqe3bhopGjYehBwaYrsh3ISD04OKua2NvivxAoGFXVLkKPQbziqVfQx2ueRJWbR09lKs6CQdCD/OvpK0ybVM9ef518xeF0lvb97NMt5cJfGcfxD14719RIgjQKOgrzsxkm4nXgo2TPBPGi48Sw5/581/8AQ2rCrvfilonlXVtqsQjX5FtvvHd1dunTFcEDuUN616OGmp0k4nn1oOFSSZ3vwg/5CniD62v8nr1yvIvhCSNU8QfW1/k9eujmvHx/8Z/I9PBfwkLRSClrkOsKSjPNYieIIodU/sy4WV7gw/aAyqNuzdtx1znPtRa4m0jboopM0hi5oNArivG3jm38O2DKq3IuGYqrJGjAbWUHqferhBzdokykoq7Ob+NWprJotvpaqf8ASC4ZiOmx4zxz/SvF0XZGqf3QBV7VNTutX1K4u7iXeskzyRZUKVDHPOB9Kp9Ote5Qp+zgonmVainK4hIQZr274cxSaL8MNHuXKu7NNGQORzLIfb0rzHwh4STxbqctvcrFJbxwlwjuyfMCozleejV9AeJLJZdJihUAKswIBJ9G/wAa5cZVWlP7zbDwdnI+f/Bc73vjDS55QoZ7qLITp/rFFfTqgKm0dK+TvCl99k1PS7sbsLcoeACeHB/pX1DoOojVNHiuxu+fd94AHhiO30rLHxtJdjTDPR9zzz4ifDmO/il1e3uWD26z3TrI+ATw2AAvse9eYeGPEc/hHVWvEjjkUn94GUsejAY5H96vqPqPY9a8x+JXgOC/02TUNMihhvldnMssr9Xdc8cjpnt3pYfEpr2VTZjq0X8UNzsfCniKHxRokN9DHJH0SQOoHz7VY4wTx81eRfE6/Oq+KLaNV2g2ajkY6O5964vT9Q1Pw3qn+i3KxzQOwdlQMC+CrEbh0rufhTZWniHVINZ1SI3GpQTSQRTbim1PKzjapAP325IzzWvsPYt1OhCq+09x7nseh6UNHs3tw5bdIXznPYD0HpWpWLrniGDw8iXN4s0kDkRhYVBO45OeSOMA1rRSedGJFyFPrXmu71OxaaElFFHNTcYmea5jx3q/9meFr10TdKBGRkZXmRR6itHxBr1v4e057y6SZ0GOIlBPUDuR6ivnnxl4quPE2tzSJLJ9iGYxHJGqtgOxHT6jvXVhqDqS8jCtVUI+ZhXUpnvrq4Iw00zyEDoCTmoxSD5R7UqWtxet5dq6I4G4l+mPyPrXtbI81auyO++DGnTS+Mry9LIIJNPcKATuyJIxzxjsa+ga57wnoNv4a8OWmn28aosO8AI7MPmct1bnvXQDpXh4ir7So2tj1KUOSNhpjVh8wzXJ6n8PtFuwzwWSLMT95p5PTHr9K6+isoTlDWLsVKEZfEjk/C3g8eHLq9mRYV+0mMnZIzZ259frXWUUUTm5u8hxgoq0QoooqSgrL1vw/pfiO0S01a1+0QJIJFXzGTDAEA5Ug9Ca1KSi7WqCye54lrmhfEjw0ZJNA1CAafFjZbwW/nSY27mA3RHOWz37iuam+I/j+whaPUJb60cAjzbjTo40yeRyUHb+Rr6QZQ4KsMg1ha14L0DxBC0Wp2Hnqzbj++kXnBH8LDsa66eJiv4kbnPOi38LPnC5+IPjHUy0c3iC3ltmG10EMIO08EcJ3571kmSCN3kMsatIdzkuOT/k19AP8FfCCkm1sfIB6jzZW/nJTV+CvhNj/pFr5y+nmSr/ACkrsWMoLZW+RjKhUk9XoeCQl7tiljBNeyD/AJZ2qeY35D8fyNdf4c+HPiHWJobiW1NrbNnMd3HJG33cj+H3HftXsuifDTwp4euftGm6X5Mx6v8AaJW7EdGYjua6qOJYlCIMKBgVjVx99IIuGFS3MvQPDth4etXgsIBCruXIEjNyQB/ET6CtRkDLh+aeBgUHpXnNtu51JJKx4L47+G+pQz3V9p1qJrfj9zAJJJGUR/MAMHqR69xWD4U8Xa94Lf7LeWmp2unK6Mlu9koZVBLPy4B53Z69+1fSrRhs7hkHjFYeq+DNA1uQvqGn+cxBGfOkXqAOzD0FdsMWuXkqK6MHRad4nIW/xl0KaMHF4HIHylIsk+mN/WsvVvH/AIh8RwvYeFtN1u1unPyXdxpymAAEHJbDcFQwHHORXWp8JfBMbiRdFwwOQftU3X/vuul0/RdP0uMJZ2/lKFCgb2bgDA6k1DqUI6wT+Y1Go/iPJ4vhfqmpaQ95qZtZNXnIkeQvImWOC3yhQByW7V53feF/E2hzrI+kahPOq7lmtrR3RQSRg5UDPXt3FfVO3kcVHNaw3EZjljyp6jJqqeMnDR6oU8PF7Hk3g74l30iy23iOy1fzcmRJJLJIk2/KAM/Lznd2qpqGg3dirN8O76ysWQ5WF5POk8vGWGGD8l8Efz7V6fL4R0KYgyWGSP8Aps//AMVUll4W0bTrn7RaWflzYxu81zxkHoT7ColWgneK+XQpQfU8KuPGfxP0OV7fU21BtnJuE0xBFjGSdxjHABGfTFY178T/ABpcy7IvEUEa9CkkEIPP/AK+ldS0PT9XgaG/t/ORlZCN7LwwwehFchc/BjwVPKZU0rypD3+0THnt/HXRTxVH7cPwM3RnzXTPn+a7e6nF1e3EclwxLvICACzfeOBgcmmrPHNKI4XWWU9EjIZj+Ar3tfgv4Y3HzId6f3d8g/XfV6w+EHgrT7lLmLSP9ITOJPtM3cYPG/Hc1s8dRS0RksNJ/EzxHSfCHiHW3U22nXVvGSVElxbuqnAznO08Hsa9x8GeA7bw6JpriGE3b5QPHK5Gw7TjBwOo9K6y1sLeyt0gto/LiQAKuScADHf6VaxzXDXxUqumyOinQjDUTbjkdadRRXMbhRRRQAUUUUAFFFFABRRRQAlLRRSAKKKKGAUlFFNCFooooYwooooASkoopALRRRSQBRRRVAFLRRQAlFFFAgpaKKQwooopgf/ZAP/iArBJQ0NfUFJPRklMRQABAQAAAqBsY21zBDAAAG1udHJSR0IgWFlaIAfkAAMACwAFABgAJ2Fjc3BNU0ZUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD21gABAAAAANMtbGNtcwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADWRlc2MAAAEgAAAAQGNwcnQAAAFgAAAANnd0cHQAAAGYAAAAFGNoYWQAAAGsAAAALHJYWVoAAAHYAAAAFGJYWVoAAAHsAAAAFGdYWVoAAAIAAAAAFHJUUkMAAAIUAAAAIGdUUkMAAAIUAAAAIGJUUkMAAAIUAAAAIGNocm0AAAI0AAAAJGRtbmQAAAJYAAAAJGRtZGQAAAJ8AAAAJG1sdWMAAAAAAAAAAQAAAAxlblVTAAAAJAAAABwARwBJAE0AUAAgAGIAdQBpAGwAdAAtAGkAbgAgAHMAUgBHAEJtbHVjAAAAAAAAAAEAAAAMZW5VUwAAABoAAAAcAFAAdQBiAGwAaQBjACAARABvAG0AYQBpAG4AAFhZWiAAAAAAAAD21gABAAAAANMtc2YzMgAAAAAAAQxCAAAF3v//8yUAAAeTAAD9kP//+6H///2iAAAD3AAAwG5YWVogAAAAAAAAb6AAADj1AAADkFhZWiAAAAAAAAAknwAAD4QAALbEWFlaIAAAAAAAAGKXAAC3hwAAGNlwYXJhAAAAAAADAAAAAmZmAADypwAADVkAABPQAAAKW2Nocm0AAAAAAAMAAAAAo9cAAFR8AABMzQAAmZoAACZnAAAPXG1sdWMAAAAAAAAAAQAAAAxlblVTAAAACAAAABwARwBJAE0AUG1sdWMAAAAAAAAAAQAAAAxlblVTAAAACAAAABwAcwBSAEcAQv/bAEMAAwICAwICAwMDAwQDAwQFCAUFBAQFCgcHBggMCgwMCwoLCw0OEhANDhEOCwsQFhARExQVFRUMDxcYFhQYEhQVFP/bAEMBAwQEBQQFCQUFCRQNCw0UFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFP/CABEIADoAZAMBEQACEQEDEQH/xAAcAAACAgMBAQAAAAAAAAAAAAAHCAAGAQMFBAL/xAAaAQACAwEBAAAAAAAAAAAAAAAEBgABBQID/9oADAMBAAIQAxAAAAHpti1qvnEvfVkbI0Sbk6a0tq3r65lTfXRHyNInZOnLicPiZawTPRz14O+akeG1KW0q65K1tBM389c3virHhtalNljGITV8S2lTGqsGDeXqlrY8Zs1PfW9sWmhT2msljc3vldmHHbRTYLmEamz4mNmjtixOCzxS/CSFHD1Snjav3x0uLctcYnwlwpYeqelzfTd8THHQ3HTcrBQo20BQrv4x0W2C6hEXAf0rJQw00BAvv4zopLYo7unuMiOX3OpU5fpwh7mvMmvafj6q5BkkoMnl+nmibkvPqmsVJOCIGcf8SDowcTaoV/BI2V17PPrie/n2x/QX6gZBAIMWadmSSSpiVmTFzNTFXJJckrMuXP/EACUQAAICAgIBBAIDAAAAAAAAAAQFAwYBAgAWEBMUITMRMhUwMf/aAAgBAQABBQKW2tdZO3tudvbcjubWPNfuWjGXm9ua437e2529tyO5tY81+5aMpfBHxPBUWhEXS23DqwxXC6b43xXD8sk83xLDUGs8XSm3GFbYKxdN8b4rx2zFPw/93DyJJp35fwu7riRYIJhs06DI6AzTaIhu8iSad+X8Z3QA1dFDKNvUYMjoOMPsYr4mgTVQQnJ8U+xbDEMq4ua7McANYWikhOT4p9j3HI4y+3H+TDxkx5qanPLVSvbCjF+pm8NCc1IuuK3CeceImPqSnPLVSvajDmeplcRksBp9+v6+GZcYK+LXfXSPTD52uYE0RhCTNLcOMzIgF8Wu/Ax8CCOKUE1kxj8YkjxLoz7Kvw1Ct1h2qdC/iJnFaYivTInFjEXVtxWSSt7SJC0Bt1h2qdDwom/u/8QAJhEAAgIBAwQBBQEAAAAAAAAAAQIAAwQREjEQExQhUSIwMlJxgf/aAAgBAwEBPwE5lwPM8y75nmXfMGbcJj5osO1/XQ5l2pGs8y/5nmX/ADBm3CUZotO1vR6tzFw7mGuk8G74jYdqjUiHUTHs7tQaH8jFw7mGuk8G6PiWoNxEIMofuVhuj8mW3rQoLTz6oc6oiMytMNNlIEYbWIPyZbetIBaefVGzqiNIWUiYi7aQOj8mMgsr2tLaXpOjdcPJ2nttxLMaq06sI4rsXtmW0vSdG64eTtPbfjo3J/2DiFQw0M8Sj9ZdhJpqkZdPYlrnsho1auukZQw0IniUfrLsJANUjp69RDuUGNyf6YvA6sdFM/Nv7AO43aPAiscc7G4mpNnrjo5AUkzTcdBFG1QJbh12ndxB66P3R+EsW+3mU4wrO4xq2D70n1WDRhpEqao+uI3dA+mWLfb6Mpxu37P3/wD/xAAqEQACAgECBQQBBQEAAAAAAAABAgADBBESEBMUITEFMkFRFSAwM1Jhcf/aAAgBAgEBPwFcHHI8ToMf6nQY/wBQ+n0H4mTgGkb07jgMDHIHadBj/U6DH+ofT6D8TJwGpG5O44r7RGz6FOms/I0fcTOodtoM8zJq5NxWJ7RGz6FOms/I0fcTNpsbaDPMya+TaU4J7RKMdshiqT8bd/kHp1wM00Mzn33sYpBrBH1KcdsgkJPxt/8AkX065WBgBEzX33seCe0Suxqn3rKMhMhdy8c/EDDmp5lWVdSNEMqayphaolGQl66rxz8QMvNTz88E9oh8wEqdROsyP7zGz3122QNr2Mxa06hgfjxFusqs11gYqdVM6zI/vMb1BydtkDa+ZYuxysr9i/8ABD54opZwBC3zGPKTnjyxjouYvMT3fIhUCjVh314ICzgCagd47bmLSnPtpXb5EPfhX07/AMmolbYdHdTMnM5o2J4lV9bV8m7xFNVDbkfUyy+nIXV+zCIMZv5NRK2w6O6mZOYbRsTx+z8fq//EADoQAAIBAgIFCAgEBwAAAAAAAAECAwAEERIQITJBYQUTMTM0QlGBInFykaGisdEUFZKTIyQwUnPB8P/aAAgBAQAGPwJwLnoJGyK7V8ortXyitcyvwZBQt7pFgnOpWGy/20MPxPQSNkV2r5RXavlFY88r8GQULe6QQznZZdl/sdMvtH60sgtwobWA7YGupT9ypLiaEc0gxbK2OArFTj6qt5mOZ8MrHxI1VL7TfWlkFuFDa8HbA11KfuU9zPCOaTaKtjhWKnzFW0znFyMGPEaLn1tUTzxyMjnDMg6DWxP+mposk3poV2eFKT6Q72WrcHvZn95q5VhgyyOCPOonnjkZJDgGQb62J/01dQKkuaSJkGK78KzdK78Ktg3exf3nRd+0/wDupLeXZcdPhxoxTrq7sg2WGlLG4fGB/RjJ7h8Kz3FuC+91JU/CpLCS4iLsNgOMy8cKMU66u7INlxpSxuHzQPqjJ7p8PVovPaf6nQUljWRD3WGNdiTyxqW85Ndl5sZnt21jDhWVtTbmWrCWMuq3LIJzF05SpJ+NJDDbwCEqGhdFGrwIoxyxrIh7rDEV2JPLGpbzk12URjM9u2sYcDWVvRbcwq3mO1JGGNX3+ST6mhpuJ5urRCTjUaIM8upVA3tup+QpmYcn2EABRThzj4DX5Y1+X8osZeS5D/AuMNn/ALeK5m2uXkslt+elTPmXEk4YaLiebDm0Qkg7+FRogLy6lUDpLbqhhHRGgWpJQ728km0U6D5aGU44HwOFfyBteU4twnXLL9Qp+FBLqzfJj1aFUjHza/jS3d86S3S7CJsp96/OORmjaZutt5jgH1YUbO55Kt7GJ9uSebnMvFQu/wAxUkdlzN9ybNto0nNSDiD4+dZrRLa9X+y4AE3vDBT8KCXVo+THq1KJGvHa1/Gku711lul2ETZT7/1//8QAJxABAAECBQMFAQEBAAAAAAAAAREAITFBUWFxgaHwEJHB0fGxIDD/2gAIAQEAAT8hhagnPxW489q3HntUxEoLq43vaXxbX+KxKF0DqnxW489q3HntUxE8CKsrPZe0v7HfKj0hNYCd6qG0UBg4yr8lV0KQT1Iqxq1UJ9VdtpeYk9qRKsH9lEiCAYNzKvwVGyYTMaoZUGnk2S4/DXOkWJC9vQRL5rSYDESQTDfMn2a/G/dKXOs5o1oEiAAp61iusOFSmFsBlfTyJEkITDfMn2a/G/dWCnGiSCb60dhNYubcVbmQXCJ/fTzGtBD0jF5Dcav5jaco+svVcCRe64S0cI1inK0Qm+VE9axElDbK5NqeeStOQPxid/Vlyc/y5auzGtGHp8w+KxoiCDSiwzkgdmoZlEJhituZsM7RSm82gv8ADVg70kaBykB2zoYNJxhUG1YjrhJ0aULDOSB2am3QxaYrXNYZ2imPptv8NCfAIaperA0GrtPSaSINe1sOuFPjExvaAbrFS8UvAGaarDUq6rSR5PYxLNGhxRm8mYnGBizHp0hn4/rDrUNIOlEA3WKQKZDrBFSsKtFdZZ8VHmMVaLMMy6Jcdyg5IGCfKVMlwhm7qyu7ZQXcSSvrLEuhSt8XnEEO4FrXvOTARCAfubQsG+FLKoKy4CAWAfQxo8EkRnz4nijdiL9Nkn3bKuluuH1lxbwUEH/B/wBf/9oADAMBAAIAAwAAABBnGXXnKXCgWTIQrxLzl0D4BTJDSBfdEr83BSF/WV7wi8uuSa/NLZT/xAAnEQEAAQIEBgIDAQAAAAAAAAABABExECFBUWFxkaGx8IHhIMHx0f/aAAgBAwEBPxBQeJPeE9wRSq9pQVVvo4ABY0tPSE9ITMlH4lK+xs4qj5wOQGyzguv1FxKHGBM8pvzZ5mTH1HzKIEru/TOCdfqLQUNn+QHOO9f/ADDzIAbRyynBekcBXpAEraMtrV6q/uMMz/ZA5aO04b0ikDnwjLtEavfrnh3LNPSesUnlo6OF4gLmtwZeD3tHSmZ8xidrOie6f2Z4ILVVuGHf+UtylGpxlDT0gEdE0lNYiaqlaV7TIa55iauNpSsSITpTSCVKOrqSor+izsMTQxzil3PLkbQdAQ+YHu7O0BB1owsoUhlq84YkU5k3prBQESpSbE8/eb+oqgoc79vNJeCx1e23iP8AmqMfDquUZGmvH6+4qhQO/vxCder+TC8cHAx//8QAJhEBAAECBAYDAQEAAAAAAAAAAQARITFBUaEQYXGR4fCBscHRIP/aAAgBAgEBPxAQr7yn5s9aw6yPmV46mpNGMTlM2OdvZ7Vg1BHRlZWpqQ5cNoR+3bQr/JzXbzASKupBIIPDE6N5sz6ieu00JzXbzBzqupBLHCCNgNujfhiOREgKl7zn90OtrOsHUCAJgUOxSM5ZH1GqKmTOd3RopZ1iIwBOnYpw25BeIe0hFKOZnwyqRidmPM1lhU0sm/5E4W5WgJ75mZ7rxYHZcamvxwvp6H1MSV90eU5jvFF61zwnWkBR1DQ4Vr+F5XVVz/SWtHUlq6gG+Nq/32vWFYK5SgWSm8Qt6UJicSXupAGtoY10IhneUdDT5+phFPydPfNjR0HQx/J1mOmsQOi/9iMZqwsaBhWXFg0vNdeWH6m833tV+LEVLO9lFtmCYnvjpUkDChTuvmsFVcJQqO8aouYYblTeVS/1uv1HVne/zp/hhM5lM44ocHCHD//EACMQAQEAAgICAgIDAQAAAAAAAAERACExQRBRYYFxkSChsfD/2gAIAQEAAT8Q+EI4hB/TxVUyvtFSg/oHH9AIxHBFVdCQ6jXFhdZLeAcQIP6YeKtX3lJAf0HGl8JX0BTThKOpTCp40Spx0BRwuz6Hti86Nx37B14pCl9r5JbQ5ZYV6wTENGINmzaNPSacbspRFdHytfeM6KZWBLYTjonrh5aOmPsPBMqbLSmcxClTjl1vIlYKQJoibBicIzFIMuAuantr78SY2GmJPfqshUIgjr1auA0eRwk7j13nPgRgTcJWO9b/AHj+6C/7YTCSfHFGn/ut4WFiKoWCNBBPVq4jLvVBFZXAo3giDigfL2TnXzhMRA80r9B+/GvsM5AbKCS7s6An4xFKxf2tL08VtT2RfF97xEoC70HTRpZDsYMyF5HW0yBxEhdlyEDs33px4YSluaVw8VtHdEXHguI2KtlXOkB6BqB0PjZv8o/zP7T1yQky/erCvwAH1nfnFS1+gUYMDRHt6bLjYm9HInZ1jNeQZGXrRWKi6YHYdYgELOGuRTDbLPz4AmN2xYV+AAzbI8q3XqBUwQmiY1lEUqjYnolE7OsAERzQVj4q4FjSgekFPrF+Wf8AMfA/OIiEU+aoDtTDsZFdZfcIO1MZNF4uVqgXiKo6lN6WxaqM4G4VYFQxvZaCESECA0EEEwcJtKAARzbVUB7wbYiCU+1JB8uMeKnzHX3LguG2tCLDS9oHlFVzdegLOdY/Yawv5WA5EEdjkbPvgdpp7mh25GRylnRKRzVicOMO46EtIzIRQYFdLEBS5ASB4+zJAU3g3utH5E4A9sRkURy7wAqYCIBnLlOfBO+hpPbS5OWKvjAE7KBzVCcOMHJqCqkSYiKEBXSxIB6/gcvg5f4DnHS4ceP/2Q==">
                </td>
                <td>
                </td>
            </tr>
            <tr>
                <td class="center-title">
                    <a href="https://bb.silifalcon.io/">https://bb.silifalcon.io/</a>
                </td>
                <td>
                </td>
            </tr>
            <tr>
                <td class="center-title">
                    Puebla, Puebla, México
                </td>
                <td class="center-title">
                    
                </td>
            </tr>
        </table>
    </body>
</table>