@php
    $admin = Str::contains(Request::url(), 'admin') ? 'text-white' : 'text-secondary';
    $invoice = (Str::contains(Request::url(), 'invoice') || Str::contains(Request::url(), 'payroll')) ? 'text-white' : 'text-secondary';
    $downloads = Str::contains(Request::url(), 'downloads') || Str::contains(Request::url(), 'stampeds') ? 'text-white' : 'text-secondary';
    $requests = Str::contains(Request::url(), 'requests') ? 'text-white' : 'text-secondary';
@endphp

<div style="background-color: #2f5480 !important;">
    <div class="card-footer d-flex justify-content-between">
        <span>
            <ul class="nav nav-pills">
                <li class="nav-item">
                    <a class="navbar-brand d-flex" href="/">
                        <img src="https://bb.silifalcon.com/assets/BB_DESPACHO.jpg" width="30" height="30" class="mr-2">
                    </a>
                </li>
                @if (Auth::user())
                    @if (Auth::user()->hasCategory('Administración'))
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle {{ $admin }}" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Administración
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            @if (Auth::user()->hasAuth("INTERNAL_CUSTOMERS"))
                            <a class="dropdown-item" href="/admin/internal-business-clients">Clientes internos</a>
                            @endif
                            @if (Auth::user()->hasAuth("EXTERNAL_CUSTOMERS"))
                            <a class="dropdown-item" href="/admin/external-business-clients">Clientes externos</a>
                            @endif
                            @if (Auth::user()->hasAuth("PARTNERSHIPS"))
                            <a class="dropdown-item" href="/admin/partnerships">Consorcios</a>
                            @endif
                            @if (Auth::user()->hasAuth("EMPLOYEES"))
                            <a class="dropdown-item" href="/admin/employees">Empleados</a>
                            @endif
                            @if (Auth::user()->hasAuth("ISR_PERIODS"))
                            <a class="dropdown-item" href="/admin/isr-periods">Periodos ISR</a>
                            @endif
                            @if (Auth::user()->hasAuth("USERS"))
                            <a class="dropdown-item" href="/admin/users">Usuarios</a>
                            @endif
                        </div>
                    </li>
                    @endif
                    @if (Auth::user()->hasCategory('Facturación'))
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle {{ $invoice }}" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Facturación
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            @if (Auth::user()->hasAuth("INVOICES"))
                            <a class="dropdown-item" href="/tax-documents/invoices">Facturas</a>
                            @endif
                            @if (Auth::user()->hasAuth("ASSIMILATED_RECEIPTS"))
                            <a class="dropdown-item" href="/payroll/assimilated-employees">Nómina para asimilados</a>
                            @endif
                            @if (Auth::user()->hasAuth("SALARIED_RECEIPTS"))
                            <a class="dropdown-item disabled" href="/payroll/assimilated-employees">Nómina para sueldos y salarios</a>
                            @endif
                            @if (Auth::user()->hasAuth("DOWNLOAD_RECEIPTS"))
                            <a class="dropdown-item" href="/tax-documents/download-receipts">Recibos de nómina</a>
                            @endif
                        </div>
                    </li>
                    @endif
                    @if (Auth::user()->hasCategory('Procesos'))
                    <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle {{ $downloads }}" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Procesos
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            @if (Auth::user()->hasAuth("DOWNLOADS"))
                            <a class="dropdown-item" href="/downloads">Descargas</a>
                            @endif
                            @if (Auth::user()->hasAuth("STAMPEDS"))
                            <a class="dropdown-item" href="/stampeds">Timbres de nómina</a>
                            @endif

                            @if (Auth::user()->hasAuth("SYS_DOWNLOADS"))
                            <a class="dropdown-item" href="/sys-downloads">Descargas de SYS</a>
                            @endif
                            @if (Auth::user()->hasAuth("SYS_STAMPEDS"))
                            <a class="dropdown-item" href="/sys-stampings">Timbres de SYS</a>
                            @endif
                        </div>
                    </li>
                    @endif
                    @if (Auth::user()->hasCategory('Solicitudes'))
                    <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle {{ $requests }}" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Solicitudes de cliente
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            @if (Auth::user()->hasAuth("SCATTER_REQUESTS"))
                            <a class="dropdown-item" href="/requests/scatters">Dispersión de nómina</a>
                            @endif
                            @if (Auth::user()->hasAuth("BUSINESS_REQUESTS"))
                            <a class="dropdown-item" href="/requests/business">Alta de empresas</a>
                            @endif
                            @if (Auth::user()->hasAuth("WORKER_REQUESTS"))
                            <a class="dropdown-item" href="/requests/workers">Alta de trabajadores</a>
                            @endif
                            @if (Auth::user()->hasAuth("COLLABORATOR_REQUESTS"))
                            <a class="dropdown-item" href="/requests/collaborators">Alta de colaboradores</a>
                            @endif
                            @if (Auth::user()->hasAuth("SCATTER_REQUESTS"))
                            <a class="dropdown-item" href="/requests/approved-scatters">Solicitudes aprobadas</a>
                            @endif
                        </div>
                    </li>
                    @endif
                @endif
            </ul>
        </span>
        <span>
            <div class="d-flex justify-content-between">
                <div class="d-flex text-white mr-2">
                    {{ $title }}  
                </div>
                <form action="/logout" method="POST" class="form-inline my-2 my-lg-0">
                    {{ csrf_field() }}
                    <button type="sumbit" name="action" value="logout" class="btn btn-sm btn-outline-light my-2">
                        <i class="fa fa-sign-out-alt mr-2"></i> Salir
                    </button>
                </form>
            </div>
        </span>
    </div>
</div>