@php
    $urlTokens = explode('/', Request::path());
    $section = null;
    $module = null;

    if (count($urlTokens) >= 2) {
        $section = $urlTokens[1];

        $module = null;
        if (count($urlTokens) > 3) {
            $module = $urlTokens[3];
        }
    }
@endphp
<nav class="navbar navbar-expand-lg navbar-dark bg-dark text-light">
    <ul class="navbar-nav mr-auto">
        <li class="nav-item">
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#main-menu">
                <span class="navbar-toggler-icon"></span>
            </button>
        </li>
        @if ($section == 'requests' && isset($module))
            @if (isset($id) && strlen($id) > 0)
                <li class="nav-item {{ $module == 'edit' ? 'active' : '' }}">
                    <a class="nav-link" href="/client/requests/{{ $id }}/edit">Solicitud</a>
                </li>
                <li class="nav-item {{ $module == 'scatter' ? 'active' : '' }}">
                    <a class="nav-link" href="/client/requests/{{ $id }}/scatter">Dispersión de empleados </a>
                </li>
                <li class="nav-item {{ $module == 'summary' ? 'active' : '' }}">
                    <a class="nav-link" href="/client/requests/{{ $id }}/summary">Resumen</a>
                </li>
            @endif
        @elseif ($section == 'business')
            @if (isset($id) && strlen($id) > 0)
                <li class="nav-item {{ !$module || $module == 'edit' ? 'active' : '' }}">
                    <a class="nav-link" href="/client/business/{{ $id }}/edit">Empresa</a>
                </li>
            @else
                <li class="nav-item {{ !$module || $module == 'edit' ? 'active' : '' }}">
                    <a class="nav-link" href="/client/business/create">Empresa</a>
                </li>
            @endif
            @if ($module && isset($status) && $status == 'R')
                <li class="nav-item {{ $module == 'requests' ? 'active' : '' }}">
                    <a class="nav-link" href="/client/business/{{ $id }}/download-files">Descargar documentos</a>
                </li>
            @endif
        @endif
    </ul>
    <span class="navbar-text text-light">
        <span class="ml-1">
            <i class="fa fa-user mr-2"></i>{{ Auth::user()->name }}
        </span>
    </span>
</nav>
