@php
    $urlTokens = explode('/', Request::path());
    $section = null;

    if (count($urlTokens) >= 1) {
        $section = $urlTokens[1];
    }

    $collapsed = Session::get('collapsed', false);
    $menuStyle = $collapsed ? 'small-menu' : '';
@endphp
<nav class="navbar navbar-expand-lg navbar-light bg-light p-0 flex-column {{ $menuStyle }}">
    <ul class="collapse navbar-collapse navbar-nav flex-column p-3" id="main-menu">
        <li>
            <a href="/"><img class="mb-3" src="https://bb.silifalcon.com/assets/BB_DESPACHO.jpg" width="100px"></a>
        </li>
        <li>
            <i class="fas fa-cube mr-2"></i>{{ Auth::user()->partnership()->name }}
        </li>
        <li class="nav-item {{$section == 'requests' ? 'active' : ''}}">
            <a class="nav-link" href="/client/requests" title="Control de solicitudes">
                <i class="fas fa-file mr-2"></i>
                <span>Solicitudes</span>
            </a>
        </li>
        <li class="nav-item {{$section == 'business' ? 'active' : ''}}">
            <a class="nav-link" href="/client/business" title="Control de empresas">
                <i class="fas fa-building mr-2"></i>
                <span>Empresas</span>
            </a>
        </li>
        <li class="nav-item {{$section == 'employees' ? 'active' : ''}}">
            <a class="nav-link" href="/client/employees" title="Control de empleados">
                <i class="fas fa-users mr-2"></i>
                <span>Empleados</span>
            </a>
        </li>

        <li class="nav-item">
            <a class="nav-link" href="#" onclick="document.getElementById('logout').click();return false;" title="Salir del sistema">
                <i class="fas fa-sign-out-alt mr-2"></i>
                <span>Salir</span>
            </a>
            <form method="POST" action="/logout" class="collapse">
                @csrf
                <button id="logout" type="submit" class="p-2">
                    <i class="fas fa-sign-out-alt mr-2"></i>
                    <span>Salir</span>
                </button>
            </form>
        </li>
    </ul>
</nav>
<div class="expand-bar">
    <form method="POST" action="/toggleMenu" class="bg-light rounded-right mt-2">
        @csrf
        <button type="submit" class="p-2">
            @if ($collapsed)
            <i class="fas fa-chevron-right"></i>
            @else
            <i class="fas fa-chevron-left"></i>
            @endif
        </button>
    </form>
</div>
