<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>B&B</title>

        <link href="https://fonts.googleapis.com/css?family=Nunito:200,600" rel="stylesheet">
        <!-- Third party -->
        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
        <!-- End third party -->

        <link href="/css/style.css" rel="stylesheet">
    </head>
    <body class="d-flex bg-dark">
        @if (!!session('error'))
        <div class="alert alert-danger alert-dismissible fade show mt-2" role="alert" style="position: absolute;left: 1em;top: 1em;z-index: 99">
            <i class="fas fa-exclamation-circle mr-2"></i>
            <span>{{ session('error') }}</span>
            <audio autoplay>
                <source src="/resources/sounds/alert.ogg" type="audio/ogg">
                <source src="/resources/sounds/alert.mp3" type="audio/mpeg">
            </audio>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        @endif
        @include('common.main-menu')
        <div class="d-flex flex-column flex-grow-1 pb-5 full-panel">

            @section('menu')
            @show
            {{--
            @include('common.secondary-menu')
            --}}
            <div class="container-fluid mt-4">
                @section('content')
                @show
            </div>
        </div>
        <!-- Third party -->
        <script src="https://code.jquery.com/jquery-3.3.1.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
        <script src="https://kit.fontawesome.com/4fb1cbc53c.js" crossorigin="anonymous"></script>
        <!-- End third party -->
        <script defer src="/resources/js/utils.js"></script>
        @section('scripts')
        @show
    </body>
</html>
