@extends('client/welcome')

@section('menu')
    @component('common.secondary-menu')
    @endcomponent
@endsection

@section('content')
<form method="GET" action="requests" class="card">
    <div class="card-header d-flex align-items-center">
        <h5>Solicitudes</h5>
        <div class="form-group m-0 ml-2 d-flex flex-grow-1">
            <div class="input-group">
                <input type="search" name="search" class="form-control" value="{{ old('name', $search) }}" placeholder="Buscar ..." autofocus>
                <div class="input-group-append">
                    <button type="submit" class="input-group-text">
                        <i class="fas fa-search"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="d-flex justify-content-between mb-2">
            <div>
                <a href="/client/requests/create" class="btn btn-sm btn-primary">
                    <i class="fas fa-plus mr-2"></i>
                    <span>Agregar</span>
                </a>
            </div>
            {{--
            <div>
                <button type="submit" class="btn btn-sm btn-danger" formmethod="POST" formaction="expedients/delete" name="_token" value="{{ Session::token() }}">
                    <i class="fas fa-minus mr-2"></i>
                    <span>Eliminar</span>
                </a>
            </div>
            --}}
        </div>
        <div class="border rounded table-responsive table-scroller">
            <table class="table table-sm table-striped table-hover">
                <thead class="thead-dark">
                    <tr>
                        <th scope="col" class="selection">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="select-all">
                                <label class="custom-control-label" for="select-all"></label>
                            </div>
                        </th>
                        <th scope="col" class="content-width">
                            <button type="submit" name="sort" value="requests.id{{$sort == 'requests.id' && $sortOrientation == 'asc' ? ':desc' : ''}}" class="btn btn-sm bg-none text-light">
                                @if ($sort == 'requests.id')
                                    @if ($sortOrientation == 'asc')
                                    <i class="fas fa-sort-up"></i>
                                    @else
                                    <i class="fas fa-sort-down"></i>
                                    @endif
                                @else
                                <i class="fas fa-sort"></i>
                                @endif
                                <strong class="ml-2">#</strong>
                            </button>
                        </th>
                        <th scope="col">
                            <button type="submit" name="sort" value="business_clients.name{{$sort == 'business_clients.name' && $sortOrientation == 'asc' ? ':desc' : ''}}" class="btn btn-sm bg-none text-light">
                                @if ($sort == 'business_clients.name')
                                    @if ($sortOrientation == 'asc')
                                    <i class="fas fa-sort-up"></i>
                                    @else
                                    <i class="fas fa-sort-down"></i>
                                    @endif
                                @else
                                <i class="fas fa-sort"></i>
                                @endif
                                <strong class="ml-2">Cliente</strong>
                            </button>
                        </th>
                        <th scope="col" class="content-width">
                            <strong class="ml-2">Factura</strong>
                        </th>
                        <th scope="col" class="content-width">
                            <strong class="ml-2">IAS</strong>
                        </th>
                        <th scope="col" class="content-width">
                            <strong class="ml-2">Sys</strong>
                        </th>
                        <th scope="col" class="content-width">
                            <strong class="ml-2">Comprobantes</strong>
                        </th>
                        <th scope="col" class="content-width">
                            <strong class="ml-2">Estado</strong>
                        </th>
                        <th scope="col" class="content-width">
                            <button type="submit" name="sort" value="requests.total{{$sort == 'requests.total' && $sortOrientation == 'asc' ? ':desc' : ''}}" class="btn btn-sm bg-none text-light">
                                @if ($sort == 'requests.total')
                                    @if ($sortOrientation == 'asc')
                                    <i class="fas fa-sort-up"></i>
                                    @else
                                    <i class="fas fa-sort-down"></i>
                                    @endif
                                @else
                                <i class="fas fa-sort"></i>
                                @endif
                                <strong class="ml-2">Total</strong>
                            </button>
                        </th>
                        <th scope="col" class="content-width">
                            <button type="submit" name="sort" value="requests.updated_at{{$sort == 'requests.updated_at' && $sortOrientation == 'asc' ? ':desc' : ''}}" class="btn btn-sm bg-none text-light">
                                @if ($sort == 'requests.updated_at')
                                    @if ($sortOrientation == 'asc')
                                    <i class="fas fa-sort-up"></i>
                                    @else
                                    <i class="fas fa-sort-down"></i>
                                    @endif
                                @else
                                <i class="fas fa-sort"></i>
                                @endif
                                <strong class="ml-2">Creado</strong>
                            </button>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($data as $i)
                    <tr>
                        <td scope="selection">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" name="selected[]" value="{{$i->id}}" id="selection-{{$i->id}}">
                                <label class="custom-control-label" for="selection-{{$i->id}}"></label>
                            </div>
                        </td>
                        <td>
                            <a href="/client/requests/{{$i->id}}/edit">{{  $i->code == '' ? 'TEMP' : $i->code }}</a>
                        </td>
                        <td>{{ $i->businessClient->name }}</td>
                        <td class="text-center"> 
                            @if ( count($i->invoices) > 0 )
                                <i class="fas fa-check text-success"></i>  
                            @endif
                        </td>
                        <td> </td>
                        <td class="text-center"> 
                            @if ( $i->HasStampReceipts() )
                                <i class="fas fa-check text-success"></i>  
                            @endif
                        </td>
                        <td class="text-center"> 
                            @if ( count($i->requestFilesDeposits) > 0 )
                                <i class="fas fa-check text-success"></i>  
                            @endif
                        </td>
                        <td>
                            <div>{{ $i->getStatus() }}</div>
                        </td>
                        <td class="text-right">{{ '$' . number_format($i->total, 2) }}</td>
                        <td class="text-center">{{$i->updated_at->format('d/m/Y')}}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <div class="card-footer d-flex justify-content-between align-items-center">
        @if ($pages > 0)
        <nav>
            <ul class="pagination">
                @php
                $start = $page - 5 < 0 ? 0 : $page - 5;
                $end = $start + 10 > $pages ? $pages : $start + 10;
                @endphp
                <li class="page-item">
                    <a class="page-link" href="?page=0{{$search ? ('&search=' . $search) : ''}}">
                        <i class="fas fa-angle-double-left"></i>
                    </a>
                </li>
                @for ($i = $start; $i < $end; $i++)
                <li class="page-item {{$i == $page ? 'active' : ''}}">
                    <a class="page-link" href="?page={{$i}}{{$search ? ('&search=' . $search) : ''}}">{{$i + 1}}</a>
                </li>
                @endfor
                <li class="page-item">
                <a class="page-link" href="?page={{$pages - 1}}{{$search ? ('&search=' . $search) : ''}}">
                    <i class="fas fa-angle-double-right"></i>
                </a>
            </li>
            </ul>
        </nav>
        @endif
        <strong class="total">Total: {{$total}} solicitudes</strong>
    </div>
</form>
@endsection
