@extends('client/welcome')

@section('menu')
    @component('common.secondary-menu')
        @slot('id')
            {{ $record->id }}
        @endslot
    @endcomponent
@endsection

@section('content')
<form method="post" action="save" class="card" encType="multipart/form-data">
    @csrf
    @include('components.messages')
    <div class="card-header">
        <h5>
            @if ($record->id)
            <input type="hidden" name="id" value="{{ $record->id }}">
            @endif
            @if ($record->code == '')
                <span>Nueva solicitud</span>
            @else
                <span>Solicitud {{$record->code }}</span>
            @endif
        </h5>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-sm-12 col-md-8 mt-2">
                <div class="row">
                    <div class="col-sm-12 col-md-6">
                        <div class="form-group">
                            <label for="total">Total</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="inputGroupPrepend">$</span>
                                </div>
                                <input type="number" class="form-control" id="total" name="total" value="{{ $record->total, 2 }}" step="0.01" autofocus required {{ $record->isReleased() ? 'disabled' : '' }}>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-6">
                        <div class="form-group">
                            <label for="operation">Operación</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="inputGroupPrepend">$</span>
                                </div>
                                <input type="number" class="form-control" id="operation" name="operation" value="{{ $record->operation, 2 }}" step="0.01" required {{ $record->isReleased() ? 'disabled' : '' }}>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12 col-md-12">
                        <div class="form-group">
                            <label for="client">Cliente</label>
                            <select name="client" class="custom-select" id="client" {{ $record->isReleased() ? 'disabled' : '' }}>
                                @foreach ($partnership->businessClients as $business)
                                    @if ($business->status == 'R')
                                    <option value="{{ $business->id }}" {{ $record->business_client_id == $business->id ? 'selected' : '' }}>{{ $business->name }}</option>
                                    @endif
                                @endforeach
                            </select>
                        </div>                            
                    </div>
                </div>
            </div>
            <div class="col-sm-12 col-md-4 mt-2">
                <div class="form-group">
                    <label for="comments">Comentarios</label>
                    <textarea id="comments" name="comments" class="form-control" rows="5" {{ $record->isReleased() ? 'disabled' : '' }}>{{ old('comments', $record->comments)}}</textarea>
                </div>
            </div>
            <div class="col-sm-12 col-md-12 mt-2">
            @include('client/components/deposit')
            </div>
        </div>
    </div>
    <div class="card-footer d-flex justify-content-between">
        <a href="/client/requests" class="btn btn-sm btn-secondary">
            <i class="fas fa-chevron-left mr-2"></i>
            <span>Regresar</span>
        </a>
        <span>
            <button formmethod="POST" formaction="/client/requests/store" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-success ml-2" {{ $record->isRequestComplete() ? 'disabled' : '' }}><i class="fa fa-check mr-2"></i>Confirmar</button>
            @if ($record->canSendRequest())
            <button formmethod="POST" formaction="/client/requests/{{ $record->id }}/send-request" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-primary ml-2 mr-4" {{ !$record->canSendRequest() ? 'disabled' : '' }}><i class="fa fa-share-square mr-2"></i>Enviar solicitud</button>
            @endif
        </span>
    </div>
</form>
<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bs-custom-file-input/dist/bs-custom-file-input.js" crossorigin="anonymous"></script>
<script type="text/javascript">
    $(function() {
        bsCustomFileInput.init();
    });
</script>
@endsection