@extends('client/welcome')

@section('menu')
    @component('common.secondary-menu')
        @slot('id')
            0
        @endslot
    @endcomponent
@endsection

@section('content')
<form method="post" action="save" class="card" encType="multipart/form-data">
    @csrf
    @include('components.messages')
    <div class="card-header">
        <h5>
            @if ($record->id)
            <input type="hidden" name="id" value="{{ $record->id }}">
            @endif
            <span>Nuevo empleado</span>
        </h5>
    </div>
    
    @include('client/components/data-employee')

    <div class="card-footer d-flex justify-content-between">
        <a href="/client/employees" class="btn btn-sm btn-secondary">
            <i class="fas fa-chevron-left mr-2"></i>
            <span>Regresar</span>
        </a>
        <span>
            <button formmethod="POST" formaction="/client/employees/store" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-success ml-2" {{ $record->status && $record->status != 'O' ? 'disabled' : '' }}><i class="fa fa-check mr-2"></i>Confirmar</button>
            <button formmethod="POST" formaction="/client/employees/{{ $record->id }}/send" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-primary ml-2 mr-4" {{ !isset($record->status) || $record->status != 'O' ? 'disabled' : '' }}><i class="fa fa-share-square mr-2"></i>Enviar solicitud</button>
        </span>
    </div>
</form>
<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
<script>
    $(document).on('click', 'form button[type=submit]', function(e) {
        var accountType = $('#account-type').children("option:selected").val();
        var myLength = $('#account').val().length;
        if (myLength > 0) {
            if (accountType == 'C' && myLength != 18) {
                $('#account').addClass('border border-danger');
                $('#account').focus();
                return false;
            } else if (accountType == 'T' && myLength != 16) {
                $('#account').addClass('border border-danger');
                $('#account').focus();
                return false;
            }
        }
    });
</script>
@endsection