@php
    $urlTokens = explode('/', Request::path());
    $section = null;
    $module = null;

    if (count($urlTokens) >= 2) {
        $section = $urlTokens[1];

        $module = null;
        if (count($urlTokens) > 3) {
            $module = $urlTokens[3];
        }
    }
@endphp

@extends('client/welcome')

@section('menu')
    @component('common.secondary-menu')
        @slot('id')
            {{ $business->id }}
        @endslot
        @slot('status')
            {{ $business->status }}
        @endslot
    @endcomponent
@endsection

@section('content')
<form method="post" action="save" class="card" encType="multipart/form-data">
    @csrf
    @include('components.messages')
    <div class="card-header">
        <h5>
            @if ($business->id)
                <input type="hidden" name="id" value="{{ $business->id }}">
            @endif
            <span>Nueva empresa</span>
        </h5>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-sm-12 col-md-8 mt-2">
                <div class="row">
                    <div class="col-sm-12 col-md-6">
                        <div class="form-group">
                            <label for="total">Tipo de cliente</label>
                            <select name="type" class="custom-select" id="type" autofocus required>
                                <option value="M" {{ old('type', $business->client_type) == 'M' ? 'selected' : '' }}>Persona Moral</option>
                                <option value="F" {{ old('type', $business->client_type) == 'F' ? 'selected' : '' }}>Persona Fisica</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-6">
                        <div class="form-group">
                            <label for="operation">Nombre</label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="name" name="name" value="{{ old('name', $business->name) }}" required>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12 col-md-6">
                        <div class="form-group">
                            <label for="name">RFC</label>
                            <input class="form-control" id="rfc" name="rfc" value="{{ old('rfc', $business->rfc) }}" maxlength="13" style="text-transform:uppercase" required>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-12 col-md-4 mt-2">
                <div class="form-group">
                    <label for="address">Dirección</label>
                    <textarea id="address" name="address" class="form-control" rows="5" >{{ old('address', $business->address) }}</textarea>
                </div>
            </div>
        </div>
    <div id="div-moral-person">
        <div class="row">
            <div class="col-sm-12 col-md-4">
                <div class="form-group">      
                    <label for="rfc-file">RFC de la empresa</label>
                    <div class="input-group mb-3">                  
                        <div class="input-group-prepend">
                            <span class="input-group-text" id="inputGroupFileRfcFile">Archivo</span>
                        </div>
                        <div class="custom-file">
                            <input type="file" class="custom-file-input" id="rfc-file" name="rfc-file" aria-describedby="inputGroupFileRfcfile">
                            <label class="custom-file-label" for="inputGroupFile01">{{ $business->getRFCFile() }}</label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-12 col-md-4">
                <div class="form-group">      
                    <label for="address-file">Comprobante de domicilio</label>
                    <div class="input-group mb-3">                  
                        <div class="input-group-prepend">
                            <span class="input-group-text" id="inputGroupFileAddon01">Archivo</span>
                        </div>
                        <div class="custom-file">
                            <input type="file" class="custom-file-input" id="address-file" name="address-file" aria-describedby="inputGroupFileAddon01">
                            <label class="custom-file-label" for="inputGroupFile01">{{ $business->getAddressFile() }}</label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-12 col-md-4">
                <div class="form-group">      
                    <label for="constitutive-act-file">Acta constitutiva</label>
                    <div class="input-group mb-3">                  
                        <div class="input-group-prepend">
                            <span class="input-group-text" id="inputGroupFileAddon01">Archivo</span>
                        </div>
                        <div class="custom-file">
                            <input type="file" class="custom-file-input" id="constitutive-act-file" name="constitutive-act-file" aria-describedby="inputGroupFileAddon01">
                            <label class="custom-file-label" for="inputGroupFile01">{{ $business->getConstitutiveActFile() }}</label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 col-md-4">
                <div class="form-group">      
                    <label for="ife-file">INE del representante legal</label>
                    <div class="input-group mb-3">                  
                        <div class="input-group-prepend">
                            <span class="input-group-text" id="inputGroupFileAddon01">Archivo</span>
                        </div>
                        <div class="custom-file">
                            <input type="file" class="custom-file-input" id="ife-file" name="ife-file" aria-describedby="inputGroupFileAddon01">
                            <label class="custom-file-label" for="inputGroupFile01">{{ $business->getIFEFile() }}</label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-12 col-md-4">
                <div class="form-group">      
                    <label for="identification-card-file">Cedula de identificación fiscal</label>
                    <div class="input-group mb-3">                  
                        <div class="input-group-prepend">
                            <span class="input-group-text" id="inputGroupFileAddon01">Archivo</span>
                        </div>
                        <div class="custom-file">
                            <input type="file" class="custom-file-input" id="identification-card-file" name="identification-card-file" aria-describedby="inputGroupFileAddon01">
                            <label class="custom-file-label" for="inputGroupFile01">{{ $business->getIdentificationCardFile() }}</label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-12 col-md-4">
                <div class="form-group">      
                    <label for="main-identification-card-file">Cedula de Identificación Fiscal del representante legal</label>
                    <div class="input-group mb-3">                  
                        <div class="input-group-prepend">
                            <span class="input-group-text" id="inputGroupFileAddon01">Archivo</span>
                        </div>
                        <div class="custom-file">
                            <input type="file" class="custom-file-input" id="main-identification-card-file" name="main-identification-card-file" aria-describedby="inputGroupFileAddon01">
                            <label class="custom-file-label" for="inputGroupFile01">{{ $business->getMainIdentificationCardFile() }}</label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div id="div-physical-person">
        <div class="row">
            <div class="col-sm-12 col-md-4">
                <div class="form-group">      
                    <label for="rfc-physical-file">RFC</label>
                    <div class="input-group mb-3">                  
                        <div class="input-group-prepend">
                            <span class="input-group-text" id="inputGroupFileRfcFile">Archivo</span>
                        </div>
                        <div class="custom-file">
                            <input type="file" class="custom-file-input" id="rfc-physical-file" name="rfc-physical-file" aria-describedby="inputGroupFileRfcfile">
                            <label class="custom-file-label" for="inputGroupFile01">{{ $business->getRFCFile() }}</label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-12 col-md-4">
                <div class="form-group">      
                    <label for="address-physical-file">Comprobante de domicilio</label>
                    <div class="input-group mb-3">                  
                        <div class="input-group-prepend">
                            <span class="input-group-text" id="inputGroupFileAddon01">Archivo</span>
                        </div>
                        <div class="custom-file">
                            <input type="file" class="custom-file-input" id="address-physical-file" name="address-physical-file" aria-describedby="inputGroupFileAddon01">
                            <label class="custom-file-label" for="inputGroupFile01">{{ $business->getAddressFile() }}</label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-12 col-md-4">
                <div class="form-group">      
                    <label for="identification-physical-card-file">Cedula de identificación fiscal</label>
                    <div class="input-group mb-3">                  
                        <div class="input-group-prepend">
                            <span class="input-group-text" id="inputGroupFileAddon01">Archivo</span>
                        </div>
                        <div class="custom-file">
                            <input type="file" class="custom-file-input" id="identification-physical-card-file" name="identification-physical-card-file" aria-describedby="inputGroupFileAddon01">
                            <label class="custom-file-label" for="inputGroupFile01">{{ $business->getIdentificationCardFile() }}</label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
    <div class="card-footer d-flex justify-content-between">
        <a href="/client/business" class="btn btn-sm btn-secondary">
            <i class="fas fa-chevron-left mr-2"></i>
            <span>Regresar</span>
        </a>
        <span>
            <button formmethod="POST" formaction="/client/business/{{ $business->id }}/send" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-primary ml-2 mr-4" {{ isset($business->status) && $business->status == 'O' ? '' : 'disabled' }}><i class="fa fa-share-square mr-2"></i>Enviar Empresa</button>
            <button formmethod="POST" formaction="/client/business/store" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-success ml-2"><i class="fa fa-check mr-2"></i>Confirmar</button>
        </span>
    </div>
</form>
<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bs-custom-file-input/dist/bs-custom-file-input.js" crossorigin="anonymous"></script>
<script type="text/javascript">
    $(function() {
        bsCustomFileInput.init();
    });
</script>
<script src="/js/master-detail.js"></script>

<script>
    $('#type').change(function() {
        var value = $(this).children("option:selected").val();
        if (value == 'M') {
            document.getElementById("div-moral-person").style.display = "block";
            document.getElementById("div-physical-person").style.display = "none";
        } else {
            document.getElementById("div-physical-person").style.display = "block";
            document.getElementById("div-moral-person").style.display = "none";
        }
    }).change();
</script>
@endsection