@extends('client/welcome')

@section('menu')
    @component('common.secondary-menu')
        @slot('id')
            0
        @endslot
    @endcomponent
@endsection

@section('content')
<form method="GET" action="/client/employees" class="card">
    <div class="card-header d-flex align-items-center">
        <h5>Empleados</h5>
        <div class="form-group m-0 ml-2 d-flex flex-grow-1">
            <div class="input-group">      
                <div class="input-group-append">
                    <select name="status" class="custom-select" id="status">
                        <option value="O" {{ old('status', $status) == 'O' ? "selected":"" }}>Abierto</option>
                        <option value="P" {{ old('status', $status) == 'P' ? "selected":"" }}>Pendiente</option>
                        <option value="R" {{ old('status', $status) == 'R' ? "selected":"" }}>Liberado</option>
                        <option value="F" {{ old('status', $status) == 'F' ? "selected":"" }}>Rechazado</option>
                    </select>
                </div>
                <input type="search" name="search" class="form-control" value="{{ old('name', $search) }}" placeholder="Buscar ..." autofocus>
                <div class="input-group-append">
                    <button type="submit" class="input-group-text">
                        <i class="fas fa-search"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="d-flex justify-content-between mb-2">
            <div>
                <a href="/client/employees/create" class="btn btn-sm btn-primary">
                    <i class="fas fa-plus mr-2"></i>
                    <span>Agregar</span>
                </a>
            </div>
            {{--
            <div>
                <button type="submit" class="btn btn-sm btn-danger" formmethod="POST" formaction="expedients/delete" name="_token" value="{{ Session::token() }}">
                    <i class="fas fa-minus mr-2"></i>
                    <span>Eliminar</span>
                </a>
            </div>
            --}}
        </div>
        <div class="border rounded table-responsive table-scroller">
            <table class="table table-sm table-striped table-hover">
                <thead class="thead-dark">
                    <tr>
                        <th scope="col" class="selection">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="select-all">
                                <label class="custom-control-label" for="select-all"></label>
                            </div>
                        </th>
                        <th scope="col" class="content-width">
                            <button type="submit" name="sort" value="employees.employee_number{{$sort == 'employees.employee_number' && $sortOrientation == 'asc' ? ':desc' : ''}}" class="btn btn-sm bg-none text-light">
                                @if ($sort == 'employees.employee_number')
                                    @if ($sortOrientation == 'asc')
                                    <i class="fas fa-sort-up"></i>
                                    @else
                                    <i class="fas fa-sort-down"></i>
                                    @endif
                                @else
                                <i class="fas fa-sort"></i>
                                @endif
                                <strong class="ml-2">#</strong>
                            </button>
                        </th>
                        <th scope="col">
                            <button type="submit" name="sort" value="employees.name{{$sort == 'employees.name' && $sortOrientation == 'asc' ? ':desc' : ''}}" class="btn btn-sm bg-none text-light">
                                @if ($sort == 'employees.name')
                                    @if ($sortOrientation == 'asc')
                                    <i class="fas fa-sort-up"></i>
                                    @else
                                    <i class="fas fa-sort-down"></i>
                                    @endif
                                @else
                                <i class="fas fa-sort"></i>
                                @endif
                                <strong class="ml-2">Nombre</strong>
                            </button>
                        </th>
                        <th scope="col" class="content-width">
                            <button type="submit" name="sort" value="employees.type{{$sort == 'employees.type' && $sortOrientation == 'asc' ? ':desc' : ''}}" class="btn btn-sm bg-none text-light">
                                @if ($sort == 'employees.type')
                                    @if ($sortOrientation == 'asc')
                                    <i class="fas fa-sort-up"></i>
                                    @else
                                    <i class="fas fa-sort-down"></i>
                                    @endif
                                @else
                                <i class="fas fa-sort"></i>
                                @endif
                                <strong class="ml-2">Tipo</strong>
                            </button>
                        </th>
                        <th scope="col" class="content-width">
                            <button type="submit" name="sort" value="employees.rfc{{$sort == 'employees.rfc' && $sortOrientation == 'asc' ? ':desc' : ''}}" class="btn btn-sm bg-none text-light">
                                @if ($sort == 'employees.rfc')
                                    @if ($sortOrientation == 'asc')
                                    <i class="fas fa-sort-up"></i>
                                    @else
                                    <i class="fas fa-sort-down"></i>
                                    @endif
                                @else
                                <i class="fas fa-sort"></i>
                                @endif
                                <strong class="ml-2">RFC</strong>
                            </button>
                        </th>
                        <th scope="col" class="content-width">
                            <button type="submit" name="sort" value="employees.curp{{$sort == 'employees.curp' && $sortOrientation == 'asc' ? ':desc' : ''}}" class="btn btn-sm bg-none text-light">
                                @if ($sort == 'employees.curp')
                                    @if ($sortOrientation == 'asc')
                                    <i class="fas fa-sort-up"></i>
                                    @else
                                    <i class="fas fa-sort-down"></i>
                                    @endif
                                @else
                                <i class="fas fa-sort"></i>
                                @endif
                                <strong class="ml-2">CURP</strong>
                            </button>
                        </th>
                        <th scope="col" class="content-width">
                            <button type="submit" name="sort" value="employees.status{{$sort == 'employees.status' && $sortOrientation == 'asc' ? ':desc' : ''}}" class="btn btn-sm bg-none text-light">
                                @if ($sort == 'employees.status')
                                    @if ($sortOrientation == 'asc')
                                    <i class="fas fa-sort-up"></i>
                                    @else
                                    <i class="fas fa-sort-down"></i>
                                    @endif
                                @else
                                <i class="fas fa-sort"></i>
                                @endif
                                <strong class="ml-2">Estatus</strong>
                            </button>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($data as $i)
                    <tr>
                        <td scope="selection">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" name="selected[]" value="{{$i->id}}" id="selection-{{$i->id}}">
                                <label class="custom-control-label" for="selection-{{$i->id}}"></label>
                            </div>
                        </td>
                        <td>
                            <div>{{ $i->employee_number }}</div>
                        </td>
                        <td>
                            <a href="/client/employees/{{ $i->id }}/edit">{{ $i->full_name }}</a>
                        </td>
                        <td>
                            <div>{{ $i->getType() }}</div>
                        </td>
                        <td>
                            <div>{{ $i->rfc }}</div>
                        </td>
                        <td>
                            <div>{{ $i->curp }}</div>
                        </td>
                        <td>
                            <div>{{ $i->status_label }}</div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <div class="card-footer d-flex justify-content-between align-items-center">
        @if ($pages > 0)
        <nav>
            <ul class="pagination">
                @php
                $start = $page - 5 < 0 ? 0 : $page - 5;
                $end = $start + 10 > $pages ? $pages : $start + 10;
                @endphp
                <li class="page-item">
                    <a class="page-link" href="?page=0{{$search ? ('&search=' . $search) : ''}}">
                        <i class="fas fa-angle-double-left"></i>
                    </a>
                </li>
                @for ($i = $start; $i < $end; $i++)
                <li class="page-item {{$i == $page ? 'active' : ''}}">
                    <a class="page-link" href="?page={{$i}}{{$search ? ('&search=' . $search) : ''}}">{{$i + 1}}</a>
                </li>
                @endfor
                <li class="page-item">
                <a class="page-link" href="?page={{$pages - 1}}{{$search ? ('&search=' . $search) : ''}}">
                    <i class="fas fa-angle-double-right"></i>
                </a>
            </li>
            </ul>
        </nav>
        @endif
        <strong class="total">Total: {{$total}} empleados</strong>
    </div>
</form>
@endsection
