@extends('client/welcome')

@section('menu')
    @component('common.secondary-menu')
        @slot('id')
            {{ $record->id }}
        @endslot
    @endcomponent
@endsection

@section('content')
<form method="post" action="save" class="card" encType="multipart/form-data">
    @csrf
    @include('components.messages')
    <div class="card-header d-flex align-items-center">
        <h5>Empleados</h5>
        <div class="form-group m-0 ml-2 d-flex flex-grow-1">
            <div class="input-group">
                <input type="search" name="search" class="form-control" value="{{ old('name', $search) }}" placeholder="Buscar ..." autofocus>
                <div class="input-group-append">
                    <button formmethod="POST" formaction="/client/requests/{{ $record->id }}/scatter/store" value="{{ Session::token() }}" type="submit" class="input-group-text">
                        <i class="fas fa-search"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="d-flex justify-content-between mb-2">
            <h3>Operación: {{ '$ ' . number_format($record->operation, 2) }} - {{ '$ ' . number_format($totalScatter, 2) }}</h3>
            <div class="d-flex justify-content-end">
                <span></span>
                <button formmethod="POST" formaction="/client/requests/{{ $record->id }}/scatter/store" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-success ml-2" {{ $record->HasStampReceipts() ? 'disabled' : '' }}><i class="fa fa-check mr-2" enabled></i>Confirmar</button>
            </div>
        </div>
        <div class="border rounded table-responsive table-scroller">
            <table class="table table-sm table-striped table-hover">
                <thead class="thead-dark">
                    <tr>
                        <th scope="col" style="width: 170px;">
                            <button formmethod="POST" formaction="/client/requests/{{ $record->id }}/scatter/store" type="submit" name="sort" value="employees.rfc{{$sort == 'employees.rfc' && $sortOrientation == 'asc' ? ':desc' : ''}}" class="btn btn-sm bg-none text-light">
                                @if ($sort == 'employees.rfc')
                                    @if ($sortOrientation == 'asc')
                                    <i class="fas fa-sort-up"></i>
                                    @else
                                    <i class="fas fa-sort-down"></i>
                                    @endif
                                @else
                                <i class="fas fa-sort"></i>
                                @endif
                                <strong class="ml-2">RFC</strong>
                            </button>
                        </th>
                        <th scope="col">
                            <button formmethod="POST" formaction="/client/requests/{{ $record->id }}/scatter/store" type="submit" name="sort" value="employees.name{{$sort == 'employees.name' && $sortOrientation == 'asc' ? ':desc' : ''}}" class="btn btn-sm bg-none text-light">
                                @if ($sort == 'employees.name')
                                    @if ($sortOrientation == 'asc')
                                    <i class="fas fa-sort-up"></i>
                                    @else
                                    <i class="fas fa-sort-down"></i>
                                    @endif
                                @else
                                <i class="fas fa-sort"></i>
                                @endif
                                <strong class="ml-2">Titular</strong>
                            </button>
                        </th>
                        <th scope="col" style="width: 170px;">
                            <button formmethod="POST" formaction="/client/requests/{{ $record->id }}/scatter/store" type="submit" name="sort" value="employee_scatters.amount{{$sort == 'employee_scatters.amount' && $sortOrientation == 'asc' ? ':desc' : ''}}" class="btn btn-sm bg-none text-light">
                                @if ($sort == 'employee_scatters.amount')
                                    @if ($sortOrientation == 'asc')
                                    <i class="fas fa-sort-up"></i>
                                    @else
                                    <i class="fas fa-sort-down"></i>
                                    @endif
                                @else
                                <i class="fas fa-sort"></i>
                                @endif
                                <strong class="ml-2">Monto</strong>
                            </button>
                        </th>
                        <th scope="col" style="width: 170px;">
                            <strong class="ml-2">Banco</strong>
                        </th>
                        <th scope="col" style="width: 330px;">
                            <strong class="ml-2">No cuenta</strong>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($data as $i)
                    <tr>
                        <td>
                            {{ $i->employee->rfc }}
                            @if (!$record->HasStampReceipts() && !$i->hasSendingAmount())
                                <input type="hidden" id="employee-id[]" name="employee-id[]" value="{{ $i->employee_id }}">
                            @endif
                        </td>
                        <td>
                            {{ $i->employee->full_name }}
                            <input type="hidden" id="name[]" name="name[]" value="{{ $i->name }}">
                        </td>
                        <td>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="inputGroupPrepend">$</span>
                                </div>
                                <input type="number" class="form-control" name="amount[]" id="amount-{{ $i->employee_id }}" value="{{ old('amount[]', $i->pending_amount ) }}" {{ $record->HasStampReceipts() || $i->hasSendingAmount() ? 'disabled' : '' }} step="0.001" max="1000000" {{ $record->HasStampReceipts() ? 'disabled' : '' }}>
                            </div>
                        </td>
                        <td>
                            <div>
                                <select id="bank[]" name="bank[]" class="custom-select" {{ $record->HasStampReceipts() || $i->hasSendingAmount() ? 'disabled' : '' }}>
                                    @foreach ($banks as $bank)
                                    <option value="{{ $bank->id }}" {{ old('bank[]', $i->bank_id) == $bank->id ? 'selected' : '' }} >{{ $bank->name }}</option>    
                                    @endforeach
                                </select>
                            </div>
                        </td>                        
                        <td>
                            <div class="input-group mb-3">
                                <div class="input-group-prepend" id="button-addon3">
                                    <button id="btn-cta-{{ $i->employee_id }}" class="btn {{ !$i->HasCard() ? 'btn-primary' : 'btn-secondary' }}" type="button" {{ $record->HasStampReceipts() || $i->hasSendingAmount() ? 'disabled' : '' }} onClick="changeCta({{ $i->employee_id }})">Cta</button>
                                    <button id="btn-card-{{ $i->employee_id }}" class="btn {{ $i->HasCard() ? 'btn-primary' : 'btn-secondary' }}" type="button" {{ $record->HasStampReceipts() || $i->hasSendingAmount() ? 'disabled' : '' }} onClick="changeCard({{ $i->employee_id }})">Tarjeta</button>
                                </div>
                                <input type="number" class="form-control account" id="txt-account-{{ $i->employee_id }}" name="account[]" type="number" step="1" minlength=18 maxlength=18 value="{{ old('account[]', $i->account) }}" employee-id="{{ $i->employee_id }}" {{ $record->HasStampReceipts() || $i->hasSendingAmount() ? 'disabled' : '' }} onkeypress="return keyAccount({{ $i->employee_id }})">
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <div class="card-footer d-flex justify-content-between align-items-center">
        @if ($pages > 0)
        <nav>
            <ul class="pagination">
                @php
                $start = $page - 5 < 0 ? 0 : $page - 5;
                $end = $start + 10 > $pages ? $pages : $start + 10;
                @endphp
                <li class="page-item">
                    <button formmethod="POST" class="page-link" formaction="/client/requests/{{ $record->id }}/scatter/store?page=0" name="action" value="{{ Session::token() }}" type="submit"><i class="fas fa-angle-double-left"></i></button>
                </li>
                @for ($i = $start; $i < $end; $i++)
                <li class="page-item {{$i == $page ? 'active' : ''}}">
                    <button formmethod="POST" class="page-link" formaction="/client/requests/{{ $record->id }}/scatter/store?page={{$i}}" name="action" value="{{ Session::token() }}" type="submit">{{$i + 1}}</button>
                </li>
                @endfor
                <li class="page-item">
                <button formmethod="POST" class="page-link" formaction="/client/requests/{{ $record->id }}/scatter/store?page={{$pages - 1}}" name="action" value="{{ Session::token() }}" type="submit"><i class="fas fa-angle-double-right"></i></button>
            </li>
            </ul>
        </nav>
        @endif
        <strong class="total">Total: {{$total}} empleados</strong>
    </div>
</form>
@endsection
<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
<script>

    function changeCta(id) {
        $('#btn-cta-' + id).removeClass('btn-primary btn-secondary');
        $('#btn-card-' + id).removeClass('btn-primary btn-secondary');

        $('#btn-cta-' + id).addClass('btn-primary');
        $('#btn-card-' + id).addClass('btn-secondary');
        
        $('#txt-account-' + id).focus();
    }

    function changeCard(id) {
        $('#btn-cta-' + id).removeClass('btn-primary btn-secondary');
        $('#btn-card-' + id).removeClass('btn-primary btn-secondary');

        $('#btn-card-' + id).addClass('btn-primary');
        $('#btn-cta-' + id).addClass('btn-secondary');

        $('#txt-account-' + id).focus();
    }

    function keyAccount(id) {
        $('#txt-account-' + id).removeClass('border border-danger bg-danger');

        var myLength = $('#txt-account-' + id).val().length;
        if ($('#btn-card-' + id).hasClass('btn-primary') && myLength > 15) {
            return false;
        } else if ($('#btn-cta-' + id).hasClass('btn-primary') && myLength > 17) {
            return false;
        }
        if (e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
            return false;
        }
    }

    $(document).on('click', 'form button[type=submit]', function(e) {
        var isCorrect = true;
        $(".account" ).each(function( index ) {
            var id = $(this).attr('employee-id');
            var myLength = $(this).val().length;
            var amountLength = $('#amount-' + id).val().length;

            if (amountLength > 0 && myLength == 0 ) {
                isCorrect = false;
                $(this).addClass('border border-danger bg-danger');
                $(this).focus();
            } else if ($('#btn-card-' + id).hasClass('btn-primary') && myLength != 16 && myLength > 0) {
                isCorrect = false;
                $(this).addClass('border border-danger bg-danger');
                $(this).focus();
            } else if ($('#btn-cta-' + id).hasClass('btn-primary') && myLength != 18 && myLength > 0) {
                isCorrect = false;
                $(this).addClass('border border-danger bg-danger');
                $(this).focus();
            }
        });
        return isCorrect;
    });
</script>