@extends('client/welcome')

@section('menu')
    @component('common.secondary-menu')
        @slot('id')
            {{ $record->id }}
        @endslot
    @endcomponent
@endsection

@section('content')
<form method="post" action="save" class="card" encType="multipart/form-data">
    @csrf
    @include('components.messages')
    <div class="card-header">
        <h5>
            @if ($record->id)
            <input type="hidden" name="id" value="{{ $record->id }}">
            @endif
            <span>Facturas</span>
        </h5>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-sm-12 mt-2">
                <input type="hidden" id="edit-invoice" name="edit-invoice" value="{{ $editInvoice }}">
                <ul class="nav nav-tabs">
                    @for ($i = 0; $i < count($invoices); $i++)
                    <li class="nav-item">
                        <table>
                            <tr>
                                <td>
                                    <a class="nav-link {{ $invoices[$i]->id == $editInvoice ? 'active' : '' }}" href="/client/requests/{{ $record->id }}/invoices/{{ $invoices[$i]->id }}/edit">Factura {{ $i + 1 }} </a>
                                </td>
                                <td>
                                    @if (count($invoices) > 1)
                                    <button class="btn btn-sm btn-outline-danger border-0 ml-2" type="submit" formnovalidate formmethod="POST" formaction="/client/requests/{{$record->id}}/invoices/{{ $invoices[$i]->id > 0 ? $invoices[$i]->id : 'new'  }}/destroy" name="_token" value="{{ Session::token() }}">
                                        <i class="fas fa-times"></i>
                                    </button>
                                    @endif
                                </td>
                            </tr>
                        </table>
                    </li>
                    @endfor
                    <li class="nav-item">
                        <button class="btn btn-link nav-link" type="submit" formmethod="POST" formaction="/client/requests/{{ $record->id }}/invoices/create" name="_token" value="{{ Session::token() }}" {{ $record->status && $record->status != 'O' ? 'disabled' : '' }}>
                            Nueva factura
                        </button>
                    </li>
                </ul>
                <div class="tab-content">
                    @foreach ($invoices as $invoice)
                    @if ($invoice->id == $editInvoice)
                    <div id="div-invoice-{{ $invoice->id }}" class="tab-pane fade show active">
                        <div class="border rounded card-body">
                            <div class="row">
                                <div class="col-sm-12 col-md-12 mt-2">
                                    <div class="row">
                                        <div class="col-sm-12 col-md-4">
                                            <div class="form-group">
                                                <input type="hidden" id="invoice-id" name="invoice-id" value="{{ $invoice->id }}">
                                                <label for="invoice-emissor">Emisor de factura</label>
                                                <select name="invoice-emissor" class="custom-select" id="invoice-emissor" {{ $record->status && $record->status != 'O' ? 'disabled' : '' }}>
                                                    @foreach ($internalClients as $business)
                                                        <option value="{{ $business->id }}" {{ old('invoice-emissor', $invoice->emissor_id) === $business->id ? 'selected' : '' }}>{{ $business->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>                            
                                        </div>
                                        <div class="col-sm-12 col-md-4">
                                            <div class="form-group">     
                                                <label for="invoice-receiver">Cliente que deposita</label>
                                                <select name="invoice-receiver" class="custom-select" id="invoice-receiver" {{ $record->status && $record->status != 'O' ? 'disabled' : '' }}>
                                                    @foreach ($partnership->businessClients as $business)
                                                        @if ($business->status == 'R')
                                                        <option value="{{ $business->id }}" {{ old('invoice-receiver', $invoice->receiver_id) === $business->id ? 'selected' : '' }}>{{ $business->name }}</option>
                                                        @endif
                                                    @endforeach
                                                </select>                         
                                            </div>                           
                                        </div>
                                        <div class="col-sm-12 col-md-4">
                                            <div class="form-group">
                                                <label for="invoice-amount">Total de factura</label>
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" id="inputGroupPrepend">$</span>
                                                    </div>
                                                    <input type="number" class="form-control" id="invoice-amount" name="invoice-amount" value="{{ old('invoice-amount', $invoice->amount), 2 }}" step="0.01" disabled>
                                                </div>
                                                {!!$errors->first('invoice-amount', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                                            </div>
                                        </div>
                                    </div>
                                    @include('client/components/invoice-concept')
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    <div class="card-footer d-flex justify-content-end">
        <a href="/client/requests" class="btn btn-sm btn-secondary">
            <i class="fas fa-chevron-left mr-2"></i>
            <span>Regresar</span>
        </a>
        <button formmethod="POST" formaction="/client/requests/{{ $record->id }}/invoices/store" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-success ml-2" {{ $record->status && $record->status != 'O' ? 'disabled' : '' }}><i class="fa fa-check mr-2"></i>Confirmar</button>
    </div>
</form>
<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
<script src="/js/master-detail.js"></script>
@endsection