<div class="col-sm-12 col-md-12 mt-2">
    <ul id="deposits" class="list-group">
        <li class="list-group-item list-group-item-primary d-flex justify-content-between">
            <span>Conceptos</span>
            <button formnovalidate formmethod="POST" formaction="/client/requests/{{ $record->id }}/invoices/{{ $currentInvoice->id }}/concepts/create" class="btn btn-sm btn-primary" type="submit" name="_token" value="{{ Session::token() }}" {{ $record->isRequestComplete() ? 'disabled' : '' }}> <i class="fas fa-plus"></i> </button>
        </li>
    </ul>
    <div id="div-concepts" class="tab-pane fade show active">
        <div class="row">
            <div class="col-xs-12 col-md-12 mt-1">
                <table class="table table-sm table-striped table-hover">
                    <thead class="thead-light">
                        <tr>
                            <th >Concepto</th>
                            <th >Descripción</th>
                            <th >Importe del concepto</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($currentInvoice->concepts as $invoiceConcept)
                        <tr>
                            <td>
                                <input type="text" class="form-control" id="concept-partnership" name="concept-partnership" value="{{ $invoiceConcept->partnershipConcept->description }}" disabled>
                            </td>
                            <td>
                                <input type="text" class="form-control" id="concept-descriptions" name="concept-descriptions" value="{{ $invoiceConcept->description }}" disabled>
                            </td>
                            <td>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="inputGroupPrepend">$</span>
                                    </div>
                                    <input type="number" class="form-control" id="concept-amounts" name="concept-amounts" step="0.01" value="{{ $invoiceConcept->amount }}" disabled>
                                </div>
                            </td>
                            <td>
                                <button formnovalidate formmethod="POST" formaction="/client/requests/deposit/{{ $record->id }}/invoice/{{ $invoiceConcept->id }}/destroy" class="btn btn-sm btn-danger back" type="submit" name="_token" value="{{ Session::token() }}"> <i class="fas fa-minus"></i> </button>
                            </td>
                        </tr>
                        @endforeach

                        <tr>
                            <td>
                                <select name="concept-concept" class="custom-select" id="concept-concept" {{ $record->isRequestComplete() ? 'disabled' : '' }}>
                                    @foreach ($partnership->partnershipConcepts as $concept)
                                        @if ($concept->status == '1' && $concept->business_client_id == $currentInvoice->emissor_id)
                                            <option value="{{ $concept->id }}" {{ old('concept-concept', $currentConcept->partnership_concept_id) == $concept->id ? 'selected' : '' }}>{{ $concept->description }}</option>
                                        @endif
                                    @endforeach
                                </select>
                            </td>
                            <td>
                                <input type="text" class="form-control" id="concept-description" name="concept-description" value="{{ old('concept-description') }}" {{ $record->isRequestComplete() ? 'disabled' : '' }}>
                            </td>
                            <td>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="inputGroupPrepend">$</span>
                                    </div>
                                    <input type="number" class="form-control" id="concept-amount" name="concept-amount" step="0.01" value="{{ old('concept-amount', $currentConcept->amount) }}" {{ $record->isRequestComplete() ? 'disabled' : '' }}>
                                </div>
                            </td>
                            <td>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>