<div class="col-sm-12 col-md-12 mt-2">
    <ul id="deposits" class="list-group">
        <li class="list-group-item list-group-item-primary d-flex justify-content-between">
            <span>Depositos</span>
            <button formmethod="POST" formaction="/client/requests/add-deposit" class="btn btn-sm btn-primary" type="submit" name="_token" value="{{ Session::token() }}"> <i class="fas fa-plus"></i> </button>
        </li>
    </ul>
    <div id="div-concepts" class="tab-pane fade show active">
        <div class="row">
            <div class="col-xs-12 col-md-12 mt-1">
                <table class="table table-sm table-striped table-hover">
                    <thead class="thead-light">
                        <tr>
                            <th >Cliente que deposita</th>
                            <th >Empresa</th>
                            <th >Comprobante de pago</th>
                            <th></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($deposits as $deposit)
                        <tr>
                            <td>
                                <select name="origin-clients[]" class="custom-select" id="origin-clients[]" disabled>
                                    @foreach ($partnership->businessClients as $business)
                                        <option value="{{ $business->id }}" {{ old('origin-clients[]', $deposit->origin_id) === $business->id ? 'selected' : '' }}>{{ $business->name }}</option>
                                    @endforeach
                                </select>
                            </td>
                            <td>
                                <select class="custom-select" id="destination-clients[]" name="destination-clients[]" disabled>
                                    @foreach ($internalClients as $business)
                                        <option value="{{ $business->id }}" {{ old('destinantion-clients', $deposit->destination_id) === $business->id ? 'selected' : '' }}>{{ $business->name }}</option>
                                    @endforeach
                                </select>
                            </td>
                            <td>
                                <div class="form-group">      
                                    <div class="input-group mb-3">                  
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" id="inputGroupFileAddon01">Archivo</span>
                                        </div>
                                        <div class="custom-file">
                                            @if ($deposit->voucher_file == '')
                                                <input type="hidden" id="edit-voucher-id[]" name="edit-voucher-ids[]" value="{{ $deposit->id }}">
                                            @endif
                                            <input type="file" class="custom-file-input" id="{{ "edit-voucher-files-$deposit->id" }}" name="{{ "edit-voucher-files-$deposit->id" }}" aria-describedby="inputGroupFileAddon01" {{ $deposit->voucher_file != '' ? 'disabled' : '' }}>
                                            <label class="custom-file-label" for="voucher-files">{{ $deposit->getVoucherFile() }}</label>
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <button formnovalidate formmethod="POST" formaction="/client/requests/deposit/{{ $deposit->id }}/invoice" class="btn btn-sm btn-primary" type="submit" name="_token" value="{{ Session::token() }}"> <i class="fas fa-file-invoice"></i> </button>
                            </td>
                            <td>
                                <button formnovalidate formmethod="POST" formaction="/client/requests/remove-deposit/{{ $deposit->id }}" class="btn btn-sm btn-danger back" type="submit" name="_token" value="{{ Session::token() }}" {{ $record->status && $record->status != 'O' ? 'disabled' : '' }}> <i class="fas fa-minus"></i> </button>
                            </td>
                        </tr>
                        @endforeach
                        <input type="hidden" name="new-deposit" value="{{ $newDeposit }}">
                        <input type="hidden" id="edit-invoice" value="{{ isset($currentDeposit) ? 1 : 0 }}">
                        @if ($newDeposit == 1)
                        <tr>
                            <td>
                                <select name="origin-client" class="custom-select" id="origin-client">
                                    @foreach ($partnership->businessClients as $business)
                                        <option value="{{ $business->id }}" {{ old('origin-client') === $business->id ? 'selected' : '' }}>{{ $business->name }}</option>
                                    @endforeach
                                </select>
                            </td>
                            <td>
                                <select class="custom-select" id="destination-client" name="destination-client">
                                    @foreach ($internalClients as $business)
                                        <option value="{{ $business->id }}" {{ old('destination-client') === $business->id ? 'selected' : '' }}>{{ $business->name }}</option>
                                    @endforeach
                                </select>
                            </td>
                            <td colspan="2">
                                <div class="form-group">      
                                    <div class="input-group mb-3">                  
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" id="inputGroupFileAddon">Archivo</span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="voucher-file" name="voucher-file" aria-describedby="inputGroupFileAddon">
                                            <label class="custom-file-label" for="voucher-file"></label>
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <button formnovalidate formmethod="POST" formaction="/client/requests/remove-deposit/new" class="btn btn-sm btn-danger back" type="submit" name="_token" value="{{ Session::token() }}"> <i class="fas fa-minus"></i> </button>
                            </td>
                        </tr>
                        @endisset
                    </tbody>
                </table>
                 @include('client/components/modal-invoice')
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
<script type="text/javascript">
    $(function() {
        $( document ).ready(function() {
            $('#btnInvoice').hide();
            if ($('#edit-invoice').val() == '1') {
                $('#btnInvoice').click();
            }
        });
    });
</script>

