<div class="card-body">
    <div class="row">
        <div class="col-sm-12 col-md-8 mt-2">
            <div class="row">
                <div class="col-sm-12 col-md-4">
                    <div class="form-group">
                        <label for="type">Tipo</label>
                        <select name="type" class="custom-select" id="type" {{ $editable ? '' : 'disabled' }}>
                            <option value="W" {{ old('type', $record->type) == 'W' ? "selected":"" }}>Trabajador</option>
                            <option value="C" {{ old('type', $record->type) == 'C' ? "selected":"" }}>Colaborador</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-12 col-md-4">
                    <div class="form-group">
                        <label for="rfc">RFC</label>
                        <input class="form-control" id="rfc" name="rfc" maxlength="13" value="{{ old('rfc', $record->rfc) }}" style="text-transform:uppercase" required {{ $editable ? '' : 'disabled' }}>
                    </div>
                </div>
                <div class="col-sm-12 col-md-4">
                    <div class="form-group">
                        <label for="curp">Curp</label>
                        <input class="form-control" id="curp" name="curp" maxlength="18" value="{{ old('curp', $record->curp) }}" style="text-transform:uppercase" required {{ $editable ? '' : 'disabled' }}>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 col-md-4">
                    <div class="form-group">
                        <label for="name">Nombre</label>
                        <input class="form-control" id="name" name="name" value="{{ old('name', $record->name) }}" required {{ $editable ? '' : 'disabled' }}>
                    </div>
                </div>
                <div class="col-sm-12 col-md-4">
                    <div class="form-group">
                        <label for="last-name">A. Paterno</label>
                        <input class="form-control" id="last-name" name="last-name" value="{{ old('last-name', $record->last_name) }}" required {{ $editable ? '' : 'disabled' }}>
                    </div>
                </div>
                <div class="col-sm-12 col-md-4">
                    <div class="form-group">
                        <label for="last-name2">A. Materno</label>
                        <input class="form-control" id="last-name2" name="last-name2" value="{{ old('last-name2', $record->last_name2) }}" {{ $editable ? '' : 'disabled' }}>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 col-md-4">
                    <div class="form-group">
                        <label for="civil-status">Estado civil</label>
                        <select name="civil-status" class="custom-select" id="civil-status" {{ $editable ? '' : 'disabled' }}>
                            <option value="S" {{ old('civil-status', $record->civil_status) == 'S' ? "selected":"" }}>Soltero</option>
                            <option value="M" {{ old('civil-status', $record->civil_status) == 'M' ? "selected":"" }}>Casado</option>
                            <option value="W" {{ old('civil-status', $record->civil_status) == 'W' ? "selected":"" }}>Viudo</option>
                            <option value="D" {{ old('civil-status', $record->civil_status) == 'D' ? "selected":"" }}>Divorciado</option>
                            <option value="SE" {{ old('civil-status', $record->civil_status) == 'SE' ? "selected":"" }}>Separado</option>
                            <option value="C" {{ old('civil-status', $record->civil_status) == 'C' ? "selected":"" }}>Conviviente</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-12 col-md-4">
                    <div class="form-group">
                        <label for="invoice-at" id="lbl-invoice-at">Inicio de relación laboral</label>
                        <input type="date" name="started-at" class="form-control" id="started-at" value="{{ old('started-at', $record->started_at != null ? $record->started_at->format('Y-m-d') : null) }}" {{ $editable ? '' : 'disabled' }}>
                    </div>
                </div>
                @if ($adminFields == 1)
                    <div class="col-sm-12 col-md-4 worker">
                        <div class="form-group">
                            <label for="client">Cliente que emite recibos</label>
                            <select name="client" class="custom-select" id="client" required>
                                @foreach ($clients as $client)
                                    <option value="{{ $client->id }}" {{ old("client", $record->business_client_id) == $client->id ? "selected":"" }}>{{ $client->name }}</option>    
                                @endforeach
                            </select>
                        </div>
                    </div>
                @endif
            </div>
        </div>
        <div class="col-sm-6 col-md-4 mt-2">
            <div class="form-group">
                <label for="address">Dirección</label>
                <textarea id="address" name="address" class="form-control" rows="8" {{ $editable ? '' : 'disabled' }}>{{ old('address', $record->address)}}</textarea>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12 col-md-8 mt-2">
            <div class="row">
                <div class="col-sm-12 col-md-4">
                    <div class="form-group">
                        <label for="bank">Banco</label>
                        <select name="bank" class="custom-select" id="bank" {{ $editable ? '' : 'disabled' }}>
                        @foreach ($banks as $bank)
                            <option value="{{ $bank->id }}" {{ old('bank', $bank->id) == $record->bank_id ? "selected":"" }}>{{ $bank->name }}</option>
                        @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-sm-12 col-md-4">
                    <div class="form-group">
                        <label for="account-type">Tipo de cuenta</label>
                        <select name="account-type" class="custom-select" id="account-type" {{ $editable ? '' : 'disabled' }}>
                            <option value="C" {{ old('account-type') == 'F' ? "selected":"" }}>Cuenta bancaria</option>
                            <option value="T" {{ old('account-type') == 'P' ? "selected":"" }}>Número de tarjeta</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-12 col-md-4">
                    <div class="form-group">
                        <label for="account">Cuenta bancaria/Numero de tarjeta</label>
                        <input class="form-control" id="account" name="account" type="number" step="1" minlength=18 maxlength=18 value="{{ old('account', $record->account) }}" {{ $editable ? '' : 'disabled' }}>
                    </div>
                </div>
            </div>
            <div class="row worker">
                <div class="col-sm-12 col-md-4">
                    <div class="form-group">
                        <label for="sdi">Salario diario integrado</label>
                        <input type="number" class="form-control" id="sdi" name="sdi" value="{{ old('sdi', $record->sdi) }}" step="0.01" min="0" max="1000000" {{ $editable ? '' : 'disabled' }}>
                    </div>
                </div>
                @if ($adminFields == 1)
                <div class="col-sm-12 col-md-4">
                    <div class="form-group">
                        <label for="salary">Salario base</label>
                        <input type="number" class="form-control" id="salary" name="salary" value="{{ old('salary', $record->salary) }}" step="0.01" min="0" max="1000000" {{ $editable ? '' : 'disabled' }}>
                    </div>
                </div>
                <div class="col-sm-12 col-md-4">
                    <div class="form-group">
                        <label for="integration-factor">Factor de integración</label>
                        <input type="number" class="form-control" id="integration-factor" name="integration-factor" value="{{ old('integration-factor', $record->integration_factor) }}" step="0.00001" min="0" max="1000000" {{ $editable ? '' : 'disabled' }}>
                    </div>
                </div>
                @endif
            </div>
        </div>
        <div class="col-sm-6 col-md-4 mt-2 border worker-border">
            <div class="row worker">
                <div class="col-sm-12 col-md-12">
                    <div class="form-group">
                        <label for="infonavit-type">Fórmula para cálculo de infonavit</label>
                        <select name="infonavit-type" class="custom-select" id="infonavit-type" {{ $editable ? '' : 'disabled' }}>
                            <option value="0" {{ old('infonavit-type', $record->infonavit_type) == null ? "selected":"" }}>Seleccione una fórmula</option>
                            <option value="F" {{ old('infonavit-type', $record->infonavit_type) == 'F' ? "selected":"" }}>Factor</option>
                            <option value="P" {{ old('infonavit-type', $record->infonavit_type) == 'P' ? "selected":"" }}>Porcentaje</option>
                            <option value="C" {{ old('infonavit-type', $record->infonavit_type) == 'C' ? "selected":"" }}>Cuota fija</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="row worker">
                <div class="col-sm-12 col-md-12">
                    <div class="form-group">
                        <label for="infonavit-value">Valor</label>
                        <input type="number" class="form-control" id="infonavit-value" name="infonavit-value" value="{{ old('infonavit-value', $record->infonavit_value) }}" step="0.00001" min="0" max="1000000" {{ $editable ? '' : 'disabled' }}>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @if ($adminFields == 1)
    <div class="row mt-3">
        <div class="col-sm-12 col-md-8">
            <div class="row">
                <div class="col-sm-12 col-md-6">
                    <div class="form-group">
                        <div class="form-group">
                            <label for="federative-key">Clave entidad federativa</label>
                            <select name="federative-key" class="custom-select" id="federative-key" {{ $editable ? '' : 'disabled' }}>
                            @foreach ($federativeKeys as $federative)
                                <option value="{{ $federative['key'] }}" {{ old('federative-key', $record->federative_key) == $federative['key'] ? "selected":"" }}>{{ $federative['value'] }}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-sm-12 col-md-6">
                    <div class="form-group">
                        <div class="form-group">
                            <label for="payment-period">Periodo de pago</label>
                            <select name="payment-period" class="custom-select" id="payment-period" {{ $editable ? '' : 'disabled' }}>
                            @foreach ($paymentPeriods as $period)
                                <option value="{{ $period['key'] }}" {{ old('payment-period', $record->payment_period) == $period['key'] ? "selected":"" }}>{{ $period['value'] }}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 col-md-6">
                    <div class="form-group">
                        <div class="form-group">
                            <label for="payroll-type">Tipo de nómina</label>
                            <select name="payroll-type" class="custom-select" id="payroll-type" {{ $editable ? '' : 'disabled' }}>
                            @foreach ($payrollTypes as $payroll)
                                <option value="{{ $payroll['key'] }}" {{ old('payroll-type', $record->payroll_type) == $payroll['key'] ? "selected":"" }}>{{ $payroll['value'] }}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-sm-12 col-md-6">
                    <div class="form-group">
                        <div class="form-group">
                            <label for="contract-type">Tipo de contrato</label>
                            <select name="contract-type" class="custom-select" id="contract-type" {{ $editable ? '' : 'disabled' }}>
                            @foreach ($contractTypes as $contract)
                                <option value="{{ $contract['key'] }}" {{ old('contract-type', $record->contract_type) == $contract['key'] ? "selected":"" }}>{{ $contract['value'] }}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 col-md-6">
                    <div class="form-group">
                        <div class="form-group">
                            <label for="regime-type">Tipo de regimen</label>
                            <select name="regime-type" class="custom-select" id="regime-type" {{ $editable ? '' : 'disabled' }}>
                            @foreach ($regimeTypes as $regime)
                                <option value="{{ $regime['key'] }}" {{ old('regime-type', $record->regime_type) == $regime['key'] ? "selected":"" }}>{{ $regime['value'] }}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-sm-12 col-md-6 worker-line">
                    <div class="form-group">
                        <div class="form-group">
                            <label for="workstation-risk">Riesgo de puesto</label>
                            <select name="workstation-risk" class="custom-select" id="workstation-risk" {{ $editable ? '' : 'disabled' }}>
                            @foreach ($workstationRisks as $workstation)
                                <option value="{{ $workstation['key'] }}" {{ old('workstation-risk', $record->workstation_risk) == $workstation['key'] ? "selected":"" }}>{{ $workstation['value'] }}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>
                </div>
            </div>  
        </div>
        <div class="col-sm-6 col-md-4 mt-2 worker-line">
            <div class="form-group">
                <label for="employer-register">Registro patronal</label>
                <textarea id="employer-register" name="employer-register" class="form-control" rows="8" {{ $editable ? '' : 'disabled' }}>{{ old('employer-register', $record->employer_register)}}</textarea>
            </div>
        </div>  
    </div>
    @endif

    <div class="row worker">
        <div class="col-sm-12 col-md-4">
            <div class="form-group">
                <label for="nss">Número de seguro social</label>
                <input type="text" class="form-control" id="nss" name="nss" value="{{ old('nss', $record->nss) }}" maxlength="30" {{ $editable ? '' : 'disabled' }}>
            </div>
        </div>
        <div class="col-sm-12 col-md-4">
            <div class="form-group">
                <label for="workstation">Puesto</label>
                <input type="text" class="form-control" id="workstation" name="workstation" value="{{ old('workstation', $record->workstation) }}" {{ $editable ? '' : 'disabled' }}>
            </div>
        </div>
    </div>

    <div class="row mt-3">
        <div class="col-sm-12 col-md-4">
            <div class="form-group">      
                <label for="ine-file">INE</label>
                <div class="input-group mb-3">                  
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="inputGroupFileRfcFile">Archivo</span>
                    </div>
                    <div class="custom-file">
                        <input type="file" class="custom-file-input" id="ine-file" name="ine-file" aria-describedby="inputGroupFileRfcfile" {{ $editable ? '' : 'disabled' }}>
                        <label class="custom-file-label" for="inputGroupFile01">{{ $record->getIneFile() }}</label>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-12 col-md-4">
            <div class="form-group">      
                <label for="rfc-file">RFC</label>
                <div class="input-group mb-3">                  
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="inputGroupFileAddon01">Archivo</span>
                    </div>
                    <div class="custom-file">
                        <input type="file" class="custom-file-input" id="rfc-file" name="rfc-file" aria-describedby="inputGroupFileAddon01" {{ $editable ? '' : 'disabled' }}>
                        <label class="custom-file-label" for="inputGroupFile01">{{ $record->getRfcFile() }}</label>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-12 col-md-4">
            <div class="form-group">      
                <label for="curp-file">CURP</label>
                <div class="input-group mb-3">                  
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="inputGroupFileAddon01">Archivo</span>
                    </div>
                    <div class="custom-file">
                        <input type="file" class="custom-file-input" id="curp-file" name="curp-file" aria-describedby="inputGroupFileAddon01" {{ $editable ? '' : 'disabled' }}>
                        <label class="custom-file-label" for="inputGroupFile01">{{ $record->getCurpFile() }}</label>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row worker">
        <div class="col-sm-12 col-md-4">
            <div class="form-group">      
                <label for="infonavit-file">Comprobante domiciliario</label>
                <div class="input-group mb-3">                  
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="inputGroupFileRfcFile">Archivo</span>
                    </div>
                    <div class="custom-file">
                        <input type="file" class="custom-file-input" id="address-file" name="address-file" aria-describedby="inputGroupFileRfcfile" {{ $editable ? '' : 'disabled' }}>
                        <label class="custom-file-label" for="inputGroupFile01">{{ $record->getAddressFile() }}</label>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-12 col-md-4">
            <div class="form-group">      
                <label for="infonavit-file">Aviso de retención de infonavit</label>
                <div class="input-group mb-3">                  
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="inputGroupFileRfcFile">Archivo</span>
                    </div>
                    <div class="custom-file">
                        <input type="file" class="custom-file-input" id="infonavit-file" name="infonavit-file" aria-describedby="inputGroupFileRfcfile" {{ $editable ? '' : 'disabled' }}>
                        <label class="custom-file-label" for="inputGroupFile01">{{ $record->getInfonavitFile() }}</label>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-12 col-md-4">
            <div class="form-group">      
                <label for="nss-file">Número de seguro social</label>
                <div class="input-group mb-3">                  
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="inputGroupFileAddon01">Archivo</span>
                    </div>
                    <div class="custom-file">
                        <input type="file" class="custom-file-input" id="nss-file" name="nss-file" aria-describedby="inputGroupFileAddon01" {{ $editable ? '' : 'disabled' }}>
                        <label class="custom-file-label" for="inputGroupFile01">{{ $record->getNssFile() }}</label>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @if (isset($record->partnership) && count($record->partnership->businessClients) > 0)
        <div class="row">
            <div class="col-sm-12 col-md-12 mt-2">
                <ul id="business" class="list-group">
                    <li class="list-group-item list-group-item-info">Active las empresas donde presta sus servicios el trabajador</li>
                    @foreach ($record->partnership->businessClients as $i)
                    @if ($i->status == 'R')
                    <li class="list-group-item d-flex justify-content-between">
                        <div class="d-flex">
                            <div class="custom-control custom-checkbox mr-2">
                                <input data-domain-translation="{{$i->domain_translation ? 'on' : 'off'}}" type="checkbox" class="custom-control-input" name="business[]" value="{{$i->id}}" id="business-{{$i->id}}" {{ $record->isActive($i->id) || (isset($business) && $i->id == $business->id) ? 'checked' : '' }} {{ $editable ? '' : 'disabled' }}>
                                <label class="custom-control-label" for="business-{{$i->id}}"></label>
                            </div>
                            <span>{{ $i->name }}</span>
                        </div>
                    </li>
                    @endif
                    @endforeach
                </ul>
            </div>
        </div>
    @endif
</div>
<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bs-custom-file-input/dist/bs-custom-file-input.js" crossorigin="anonymous"></script>
<script type="text/javascript">
    $(function() {
        bsCustomFileInput.init();
    });
</script>
<script>
    $(function() {
        var length = $('#account').val().length;
        if (length == 18) {
            $("#account-type option[value='C']").attr("selected", "selected");
        } else if (length == 16) {
            $("#account-type option[value='T']").attr("selected", "selected");
        }
    });
    $('#type').change(function() {
        var value = $(this).children("option:selected").val();
        if (value == 'W') {
            $('.collaborator').css('display', 'none');
            $('.worker-border').addClass('border');
            $('.worker').css('display', 'flex');
            $('.worker-line').css('display', 'inline');

            $('#lbl-invoice-at').text('Inicio de relación laboral');
        } else {
            $('.worker-line').css('display', 'none');
            $('.worker').css('display', 'none');
            $('.worker-border').removeClass('border');
            $('.collaborator').css('display', 'flex');

            $('#lbl-invoice-at').text('Inicio de actividades');
        }
    }).change();
    $("#account").keypress(function (e) {
        $('#account').removeClass('border border-danger');

        var accountType = $('#account-type').children("option:selected").val();

        var myLength = $(this).val().length;
        if (accountType == 'C' && myLength > 17) {
            return false;
        } else if (accountType == 'T' && myLength > 15) {
            return false;
        }
        if (e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
            return false;
        }
   });
</script>