<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        <div class="container-fluid" style="height: 50px;background-color: #2f5480;">
            
        </div>
        <div class="container d-flex justify-content-center mt-4">
            <div class="col-offset-3 p-5">
                <form action="/login" method="POST" class="card shadow-sm">
                    {{ csrf_field() }}
                    <div class="card-header d-flex justify-content-between">
                        <h5 class="card-title">Iniciar sesión</h5>
                        <small>
                            @if (Route::has('password.request'))
                                <a class="btn btn-link" href="{{ route('password.request') }}">
                                    {{ __('Recuperar contraseña') }}
                                </a>
                            @endif
                        </small>
                    </div>
                    <div class="card-body d-flex justify-content-center">
                        <img src="https://bb.silifalcon.com/assets/FAC_MOD.jpg">
                    </div>
                    <div class="card-body">
                        <div class="input-group mb-3">
                            <div class="input-group-prepend">
                                <div class="input-group-text"><i class="fa fa-user"></i></div>
                            </div>
                            <input name="user_name" class="form-control" placeholder="Usuario" value="{{ old('user_name', '') }}">
                        </div>
                        <div class="input-group mb-3">
                            <div class="input-group-prepend">
                                <div class="input-group-text"><i class="fa fa-key"></i></div>
                            </div>
                            <input type="password" name="password" class="form-control" placeholder="Contraseña" value="{{ old('password', '') }}">
                        </div>
                    </div>
                    <div class="card-body">
                        @include('components.messages')
                    </div>
                    <div class="card-footer d-flex justify-content-end">
                        <button type="sumbit" name="action" value="login" class="btn btn-success" action="logout"><i class="fa fa-sign-in-alt mr-2"></i>Iniciar sesión</button>
                    </div>
                </form>
            </div>
        </div>
    </body>
</html>
