<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Usuarios
            @endslot
        @endcomponent
        <form action="/admin/users" method="POST" class="container">
            @csrf
            @include('components.messages')
            <div class="card">
                <div class="card-header">
                    <h5>Usuario</h5>
                </div>
                <input type="hidden" id="contact-id" name="contact-id" value="{{ $contactId }}">
                <input type="hidden" id="id" name="id" value="{{ $user->id }}">
                <div class="card-body">
                    <div class="form-group row">
                        <label for="user-name" class="col-md-4 col-form-label text-md-right">{{ __('Nombre de usuario') }}</label>

                        <div class="col-md-6">
                            <input id="user-name" type="text" class="form-control @error('name') is-invalid @enderror" name="user-name" value="{{ old('user-name', $user->user_name) }}" required autocomplete="user-name" autofocus>

                            @error('name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="email" class="col-md-4 col-form-label text-md-right">{{ __('Dirección E-Mail') }}</label>

                        <div class="col-md-6">
                            <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email', $user->email) }}" required autocomplete="email">

                            @error('email')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="name" class="col-md-4 col-form-label text-md-right">{{ __('Nombre') }}</label>

                        <div class="col-md-6">
                            <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name', $user->name) }}" required autocomplete="name">

                            @error('name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="last-name" class="col-md-4 col-form-label text-md-right">{{ __('Apellido paterno') }}</label>

                        <div class="col-md-6">
                            <input id="last-name" type="text" class="form-control @error('last-name') is-invalid @enderror" name="last-name" value="{{ old('last-name', $user->last_name) }}" required autocomplete="last-name">

                            @error('name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="second-last-name" class="col-md-4 col-form-label text-md-right">{{ __('Apellido materno') }}</label>

                        <div class="col-md-6">
                            <input id="second-last-name" type="text" class="form-control @error('second-last-name') is-invalid @enderror" name="second-last-name" value="{{ old('second-last-name', $user->second_last_name) }}" autocomplete="second-last-name">

                            @error('name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="password" class="col-md-4 col-form-label text-md-right">{{ __('Contraseña') }}</label>

                        <div class="col-md-6">
                            <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" autocomplete="new-password" minlength="7" required value="{{ old('password', $user->password) }}">

                            @error('password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="password-confirm" class="col-md-4 col-form-label text-md-right">{{ __('Confirmar contraseña') }}</label>

                        <div class="col-md-6">
                            <input id="password-confirm" type="password" class="form-control" name="password_confirmation" autocomplete="new-password" minlength="7" required value="{{ old('password_confirmation', $user->password) }}">
                        </div>
                    </div>

                    <div class="form-group row mb-0">
                        <div class="col-md-6 offset-md-4">
                            <button type="submit" class="btn btn-primary" name="action" value="store-contact-user">
                                {{ __('Registrar') }}
                            </button>
                        </div>
                    </div>
                </div>
        </form>
        @include('components.footer')
    </body>
</html>
