<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Usuarios
            @endslot
        @endcomponent
        <form action="/admin/users" method="POST" class="container-fluid">
            {{ csrf_field() }}
            @include('components.messages')
            <table class="table border">
                <thead class="thead-light">
                    <tr>
                        <th scope="col" colspan="3">
                            <span>
                                <button type="submit" data-toggle="modal" class="btn btn-sm btn-primary back" name="action" value="create">
                                    <i class="fa fa-plus mr-2"></i>Agregar usuario
                                </button>
                                <button type="submit" data-toggle="modal" class="btn btn-sm btn-danger back" name="action" value="destroy">
                                    <i class="fa fa-trash mr-2"></i>Dar de baja usuario
                                </button>
                            </span>
                        </th>
                        <th scope="col" colspan="2" class="text-right">
                            Número de usuarios: <strong>{{ $total }}</strong>
                        </th>
                    </tr>
                    <tr>
                        <th scope="col" colspan="5">
                            <span class="d-flex">
                                <div class="form-group mr-2">
                                    <label for="type"><small class="form-text text-muted">Perfil</small></label>
                                    <select id="type" name="type" class="form-control">
                                        <option value="A" selected>Todos</option>
                                        <option value="BI" {{ old('type', $type) == 'BI' ? 'selected' : '' }}>Facturación</option>
                                        <option value="BA" {{ old('type', $type) == 'BA' ? 'selected' : '' }}>Banco</option>
                                    </select>
                                </div>
                            </span>
                            <div class="d-flex">
                                <input type="search" name="filter" class="form-control" placeholder="Buscar ..." value="{{ old('filter', $filter) }}">
                                <button name="action" value="search" type="submit" class="btn btn-primary ml-2"><i class="fa fa-search"></i></button>
                            </div>
                        </th>
                    </tr>
                </thead>
                <thead class="thead-light">
                    <tr>
                        <th scope="col"><input id="select-all" type="checkbox"></th>
                        <th scope="col">Usuario</th>
                        <th scope="col">Nombre</th>
                        <th scope="col">E-mail</th>
                        <th scope="col">Perfil</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($users as $i)
                    <tr>
                        <th>
                            <input type="checkbox" name="selected[]" value="{{ $i->id }}">
                        </th>
                        <th scope="row">
                            <a href="/admin/users/{{ $i->id }}/edit">{{ $i->user_name }}</a>
                        </th>
                        <td>{{ $i->getFullName() }}</td>
                        <td>{{ $i->email }}</td>
                        <td>{{ $i->getType() }}</td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="thead-light">
                    <tr>
                        <th scope="col" colspan="5">
                            <div class="btn-toolbar d-flex justify-content-end" role="toolbar">
                                <div class="btn-group" role="group">
                                    @foreach ($pages as $i)
                                        <button name="action" value="search-page" type="submit" class="btn btn-secondary {{ $i === $page ? 'active' : '' }}"
                                            onclick="$('#page-index').val({{ $i }})">{{ $i + 1 }}</button>
                                    @endforeach
                                    <input type="hidden" id="page-index" name="page-index" value="{{ $page }}">
                                </div>
                            </div>
                        </th>
                    </tr>
                </tfoot>
            </table>
        </form>
        @include('components.footer')
        <script src="/js/master-detail.js"></script>
    </body>
</html>
