<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Solicitud de dispersión de nómina
            @endslot
        @endcomponent
        <form action="/requests/scatters/{{ $record->id }}" method="POST" class="container" encType="multipart/form-data">
            @include('components.messages')
            {{ csrf_field() }}

            <div class="card">
                <div class="card-header d-flex justify-content-between">                    
                    <h5>Dispersión: {{ $record->code }}</h5>
                    <a href="/requests/scatters/{{ $record->id }}/scatter" class="btn btn-sm btn-secondary mr-2"><i class="fa fa-file-excel mr-2"></i>Dispersión</a>
                </div>
                <div class="card-body">
                    <table class="table">
                        <thead>
                            <tr>
                            <th scope="col">Solicito</th>
                            <th scope="col">Total</th>
                            <th scope="col">Operación</th>
                            <th scope="col">Cliente</th>
                            <th scope="col">Comentarios</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                            <th scope="row">{{ $record->user->name }}</th>
                            <td>{{ '$ ' . number_format($record->total, 2) }}</td>
                            <td>{{ '$ ' . number_format($record->operation, 2) }}</td>
                            <td>{{ $record->businessClient->name }}</td>
                            <td>{{ $record->comments }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="card-header d-flex justify-content-between">                    
                    <h5>Depositos</h5>
                    <a href="/requests/scatters/{{ $record->id }}/download" class="btn btn-sm btn-secondary mr-2"><i class="fa fa-download mr-2"></i>Comprobantes</a>
                </div>
                <div class="card-body">
                    <table class="table">
                        <thead>
                            <tr>
                            <th scope="col">Cliente que deposita</th>
                            <th scope="col">Empresa</th>
                            <th scope="col">Archivo</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($record->deposits as $deposit)
                            <tr>
                            <th scope="row">{{ $deposit->origin->name }}</th>
                            <td>{{ $deposit->destination->name }}</td>
                            <td>{{ $deposit->getVoucherFile() }}</td>
                            </tr>    
                            @endforeach
                        </tbody>
                    </table>
                </div>

                @for ($i = 0; $i < count($record->requestInvoices); $i++)
                <div class="card-header">
                    <h5>Factura {{ $i + 1 }}</h5>
                </div>
                <div class="card-body">
                    <table class="table">
                        <thead>
                            <tr>
                            <th scope="col">Emisor</th>
                            <th scope="col">Cliente que deposita</th>
                            <th scope="col">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                            <th scope="row">{{ $record->requestInvoices[$i]->emissor->name }}</th>
                            <td>{{ $record->requestInvoices[$i]->receiver->name }}</td>
                            <td>{{ '$ ' . number_format($record->requestInvoices[$i]->amount, 2) }}</td>
                            </tr>
                        </tbody>
                    </table>
                    <table class="table">
                        <thead class="thead-light">
                            <tr>
                            <th scope="col">Concepto</th>
                            <th scope="col">Descripción</th>
                            <th scope="col">Importe</th>
                            </tr>
                        </thead>
                        <tbody>
                        @foreach ($record->requestInvoices[$i]->concepts as $concept)
                            <tr>
                            <th scope="row">{{ $concept->partnershipConcept->description }}</th>
                            <td>{{ $concept->description }}</td>
                            <td>{{ '$ ' . number_format($concept->amount, 2) }}</td>
                            </tr>
                        @endforeach                 
                        </tbody>
                    </table>
                </div>
                @endfor
                @if ($record->status == 'R')

                <div class="card-header d-flex justify-content-between">
                    <h5>Relación de facturas</h5>
                    <a href="/requests/scatters/{{ $record->id }}/invoice/download" class="btn btn-sm btn-secondary mr-2"><i class="fa fa-download mr-2"></i>Descargar facturas</a>
                </div>
                <div class="card-body">
                    <div class="col-xs-12 col-md-12">
                        <table class="table table-sm table-striped table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th>Factura</th>
                                    <th>Total</th>
                                    <th>Subtotal</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($record->invoices as $i)
                                <tr>
                                    <td>
                                        <input type="text" class="form-control" value="{{ $i->code }}" disabled>
                                    </td>
                                    <td>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text" id="inputGroupPrepend">$</span>
                                            </div>
                                            <input type="text" class="form-control" value="{{ $i->total }}" disabled>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text" id="inputGroupPrepend">$</span>
                                            </div>
                                            <input type="number" class="form-control" value="{{ $i->subtotal }}" disabled>
                                        </div>
                                    </td>
                                    <td>
                                        <button formmethod="POST" formaction="/requests/scatters/{{ $record->id }}/invoice/{{ $i->id }}/destroy" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-danger mr-2">
                                            <i class="fa fa-minus"></i>
                                        </button>
                                    </td>
                                </tr>
                                @endforeach
                                @if ($userType == 'BI')
                                <tr>
                                    <td>
                                        <input type="text" class="form-control" id="invoice-code" name="invoice-code" value="{{ old('invoice-code') }}" style="text-transform:uppercase;">
                                    </td>
                                    <td>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text" id="inputGroupPrepend">$</span>
                                            </div>
                                            <input type="text" class="form-control" disabled>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text" id="inputGroupPrepend">$</span>
                                            </div>
                                            <input type="number" class="form-control" name="invoice-subtotal[]" disabled>
                                        </div>
                                    </td>
                                    <td>
                                        <button formmethod="POST" formaction="/requests/scatters/{{ $record->id }}/invoice/store" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-success mr-2">
                                            <i class="fa fa-check"></i>
                                        </button>
                                    </td>
                                </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
                
                @include('admin/components/worker-files')
                {{--
                <div class="card-header d-flex justify-content-between">
                    <h5>Relación de Recibos de pago</h5>
                    <a href="/requests/scatters/{{ $record->id }}/voucher/download" class="btn btn-sm btn-secondary mr-2"><i class="fa fa-download mr-2"></i>Descargar recibos</a>
                </div>
                <div class="card-body">
                    <div class="col-xs-12 col-md-12">
                        <table class="table table-sm table-striped table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th>Recibo de pago</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($files as $f)
                                <tr>
                                    <td>
                                        <div class="form-group">      
                                            <div class="input-group mb-3">                  
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text" id="inputGroupFileAddon01">Archivo</span>
                                                </div>
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" id="voucher-files[]" name="voucher-files[]" aria-describedby="inputGroupFileAddon01" disabled>
                                                    <label class="custom-file-label" for="voucher-files">{{ $f->name_file }}</label>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <button formnovalidate formmethod="POST" formaction="/requests/scatters/{{ $record->id }}/voucher/{{ $f->id }}/remove" class="btn btn-sm btn-danger back" type="submit" name="_token" value="{{ Session::token() }}"> <i class="fas fa-minus"></i> </button>
                                    </td>
                                </tr>
                                @endforeach
                                <tr>
                                    <td>
                                        <div class="form-group">      
                                            <div class="input-group mb-3">                  
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text" id="inputGroupFileAddon">Archivo</span>
                                                </div>
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" id="voucher-file" name="voucher-file" aria-describedby="inputGroupFileAddon">
                                                    <label class="custom-file-label" for="voucher-file"></label>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <button formmethod="POST" formaction="/requests/scatters/{{ $record->id }}/voucher/store" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-success mr-2">
                                            <i class="fa fa-check"></i>
                                        </button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                --}}
                @endif
                <div class="card-footer d-flex justify-content-between">
                    @if ($record->status == 'R')
                        <a href="/requests/approved-scatters" class="btn btn-sm btn-outline-secondary mr-2"><i class="fa fa-chevron-left mr-2"></i>Regresar</a>
                    @else
                        <a href="/requests/scatters" class="btn btn-sm btn-outline-secondary mr-2"><i class="fa fa-chevron-left mr-2"></i>Regresar</a>
                    @endif
                    <span>
                        @if ($record->status != 'R' && $record->status != 'F')
                            <a href="/requests/scatters/{{ $record->id }}/approve" class="btn btn-sm btn-success mr-5"><i class="fa fa-check mr-2"></i>Aprobar</a>

                            <button type="button" data-toggle="modal" data-target="#emailModal" onclick="$('#email').val('{{ $record->user->email }}'); $('input[name=id-email]:hidden').val('{{ $record->id }}');"
                                class="btn btn-sm btn-danger mr-5" title="Enviar correo">
                                <i class="fa fa-trash mr-2"></i>Rechazar
                            </button>
                        @elseif ($userType == 'BI' && $record->status != 'F')
                            @if ($record->HasStampReceipts()) 
                                <a href="/requests/scatters/{{ $record->id }}/create-payrolls" class="btn btn-sm btn-primary mr-5"><i class="fa fa-money-check mr-2"></i>Ver nómina para sueldos y salarios</a>
                            @else
                                <a href="/requests/scatters/{{ $record->id }}/create" class="btn btn-sm btn-primary mr-5"><i class="fa fa-money-check mr-2"></i>Generar nómina para sueldos y salarios</a>
                            @endif
                        @endif
                    </span>
                </div>
            </div>
            @include('components.email')
        </form>
        @include('components.footer')
    </body>
</html>
