<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Consorcios
            @endslot
        @endcomponent
        <form action="/admin/partnerships" method="POST" class="container">
            @include('components.messages')
            {{ csrf_field() }}

            @if (!empty($partnership->id))
                <input type="hidden" name="id" value="{{$partnership->id}}">
            @endif
            <div class="card">
                <div class="card-header">
                    <h5>Consorcio</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="code">Código</label>
                                <input class="form-control" id="code" name="code" value="{{ old('code', $partnership->code)}}"
                                    placeholder="Código del consorcio" style="text-transform:uppercase" required>
                                {!!$errors->first('code', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-8">
                            <div class="form-group">
                                <label for="name">Nombre</label>
                                <input class="form-control" id="name" name="name" value="{{ old('name', $partnership->name)}}" placeholder="Nombre del consorcio" required>
                                {!!$errors->first('name', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="prefix">Prefijo de número de empleado</label>
                                <input class="form-control" id="prefix" name="prefix" value="{{ old('prefix', $partnership->prefix)}}" maxlength="5"
                                    placeholder="Prefijo de número de empleado" style="text-transform:uppercase" required>
                                {!!$errors->first('prefix', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                    </div>

                    @if ($partnership->id > 0)
                    <ul class="nav nav-tabs">
                        <li class="nav-item {{ $conceptTab == 'div-business-clients' ? 'active' : '' }}"><a class="nav-link {{ $conceptTab == 'div-business-clients' ? 'active' : '' }}" data-toggle="tab" href="#div-business-clients">Empresas</a></li>
                        <li class="nav-item {{ $conceptTab == 'div-contacts' ? 'active' : '' }}"><a class="nav-link {{ $conceptTab == 'div-contacts' ? 'active' : '' }}" data-toggle="tab" href="#div-contacts">Contactos</a></li>
                        <li class="nav-item {{ $conceptTab == 'div-concepts' ? 'active' : '' }}"><a class="nav-link {{ $conceptTab == 'div-concepts' ? 'active' : '' }}" data-toggle="tab" href="#div-concepts">Conceptos</a></li>
                    </ul>
                    <div class="tab-content">
                        <div id="div-business-clients" class="tab-pane fade {{ $conceptTab == 'div-business-clients' ? 'show active' : '' }}">
                            <div class="border rounded">
                                <table class="table table-sm table-striped table-hover">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>RFC</th>
                                            <th>Nombre</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($businessClients as $i)
                                        @if ($i->status == 'R')
                                        <tr>
                                            <th scope="row">
                                                <a href="/admin/external-business-clients/{{ $i->id }}/edit">{{ $i->code }}</a>
                                            </th>
                                            <td>{{ $i->name }}</td>
                                        </tr>
                                        @endif
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div id="div-contacts" class="tab-pane fade {{ $conceptTab == 'div-contacts' ? 'show active' : '' }}">
                            <div class="border rounded">
                                <table class="table table-sm table-striped table-hover">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Nombre</th>
                                            <th>Correo</th>
                                            <th>Comentarios</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($contacts as $i)
                                        <tr>
                                            <th scope="row">
                                                <a href="/admin/partnership-contacts/{{ $i->id }}/edit">{{ $i->getFullName() }}</a>
                                            </th>
                                            <td>{{ $i->email }}</td>
                                            <td>{{ $i->comments }}</td>
                                            <td class="text-right">
                                                @if ($i->user)
                                                    <a href="/admin/partnership-contacts/{{ $i->id }}/edit-contact-user"><i class="fa fa-user mr-2"></i>{{ $i->user->user_name }}</a>
                                                @else
                                                    <a href="/admin/partnership-contacts/create-user/{{$i->id}}" class="btn btn-sm btn-info"><i class="fa fa-user mr-2"></i>Crear usuario</a>
                                                @endif
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="mt-2">
                                @if ($partnership->id && $partnership->id > 0)
                                <a href="/admin/partnership-contacts/create/{{$partnership->id}}" class="btn btn-sm btn-primary"><i class="fa fa-plus mr-2"></i>Agregar contacto</a>
                                @endif
                            </div>
                        </div>
                        <div id="div-concepts" class="tab-pane fade {{ $conceptTab == 'div-concepts' ? 'show active' : '' }}">
                            @include('admin.components.partnership-concepts')
                        </div>
                    </div>
                    @endif
                </div>
                <div class="card-footer d-flex justify-content-between">
                    <a href="/admin/partnerships" class="btn btn-sm btn-outline-secondary mr-2"><i class="fa fa-chevron-left mr-2"></i>Regresar</a>
                    <span>
                        @if ($partnership->id && $partnership->id > 0)
                            <button formmethod="POST" formaction="/admin/partnerships/destroy" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-danger ml-2"><i class="fa fa-trash mr-2"></i>Eliminar cliente</button>
                        @endif
                        <button formmethod="POST" formaction="/admin/partnerships/store" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-success ml-2"><i class="fa fa-check mr-2"></i>Confirmar</button>
                    </span>
                </div>
            </div>
        </form>
        @include('components.footer')
    </body>
</html>
