<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Creando contacto
            @endslot
        @endcomponent
        <form action="/admin/partnerships" method="POST" class="container">
            @include('components.messages')
            {{ csrf_field() }}

            <input type="hidden" name="partnership-id" value="{{$partnership->id}}">
            @if (!empty($partnership->id))                
                <input type="hidden" name="contact-id" value="{{$contact->id}}">
            @endif
            <div class="card">
                <div class="card-header">
                    <table width="100%">
                        <tr>
                            <td>
                                <h5>Contacto de {{ $partnership->name }}</h5>
                            </td>
                            <td>
                                @if ($contact->id)
                                <div class="d-flex justify-content-end">
                                    @if ($partnership->id)
                                    <button name="action" value="create-user" type="submit" class="btn btn-sm btn-secondary ml-2" disabled><i class="fa fa-user mr-2"></i>Crear usuario</button>
                                    @endif
                                </div>
                                @endif
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="name">Nombre</label>
                                <input class="form-control" id="name" name="name" value="{{ old('name', $contact->name)}}" placeholder="Nombre" required>
                                {!!$errors->first('name', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="second-name">Apellido paterno</label>
                                <input class="form-control" id="second-name" name="second-name" value="{{ old('second-name', $contact->second_name)}}" placeholder="Apellido paterno" required>
                                {!!$errors->first('second-name', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="second-last-name">Apellido materno</label>
                                <input class="form-control" id="second-last-name" name="second-last-name" value="{{ old('second-last-name', $contact->second_last_name)}}" placeholder="Apellido materno">
                                {!!$errors->first('second-last-name', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="row">   
                            <div class="col-sm-12 col-md-4">
                                <div class="form-group">
                                    <label for="second-last-name">Correo</label>
                                    <input class="form-control" id="email" name="email" value="{{ old('email', $contact->email)}}" placeholder="Correo" required>
                                    {!!$errors->first('second-last-name', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                                </div>
                            </div>                    
                            <div class="col-sm-12 col-md-8">
                                <div class="form-group">
                                    <label for="comments">Comentarios</label>
                                    <textarea class="form-control" id="comments" name="comments" maxlength="500">{{ old('comments', $contact->comments)}}</textarea>
                                    {!!$errors->first('comments', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex justify-content-between">
                    <a href="/admin/partnerships/{{$partnership->id}}/edit" class="btn btn-sm btn-outline-secondary"><i class="fa fa-chevron-left mr-2"></i>Regresar</a>
                    <span>
                        @if ($partnership->id && $partnership->id > 0)
                            <button formmethod="POST" formaction="/admin/partnership-contacts/destroy" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-danger ml-2"><i class="fa fa-trash mr-2"></i>Eliminar contacto</button>
                        @endif
                        <button formmethod="POST" formaction="/admin/partnership-contacts/store" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-success ml-2"><i class="fa fa-check mr-2"></i>Confirmar</button>
                    </span>
                </div>
            </div>
        </form>
        @include('components.footer')
    </body>
</html>
