<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Periodo Isr
            @endslot
        @endcomponent
        <form action="/admin/isr-periods" method="POST" class="container">
            @include('components.messages')
            {{ csrf_field() }}

            <div class="card">
                <div class="card-header">
                    <h5>Periodo Isr</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 col-md-8">
                            <input type="hidden" id="id" name="id" value="{{ $period->id }}">
                            <div class="form-group">
                                <label for="name">Nombre</label>
                                <input class="form-control" id="name" name="name" value="{{ $period->name }}" required>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="name">Dias a aplicar</label>
                                <input type="number" class="form-control" id="days" name="days" value="{{ $period->days }}" step="1" min="1" max="31" required>
                            </div>
                        </div>
                    </div>
                </div>
                <ul class="nav nav-tabs">
                    <li class="nav-item active"><a class="nav-link active" data-toggle="tab" href="#div-isr">Tabla de amortización ISR</a></li>
                    <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#div-subsidio">Tabla de subsidio al empleo</a></li>
                </ul>
                <div class="tab-content">
                    <div id="div-isr" class="tab-pane fade show active">
                        <div id="div-details" class="tab-pane">
                            <div class="border rounded">
                                <table class="table table-sm table-striped table-hover">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Limite inferior</th>
                                            <th>Limite superior</th>
                                            <th>Cuota fija</th>
                                            <th>Porcentaje</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($details as $i)
                                        <tr>
                                            <th scope="row">
                                                <input type="hidden" id="detail-id[]" name="detail-id[]" value="{{ $i->id }}">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" id="inputGroupPrepend">$</span>
                                                    </div>
                                                    <input type="number" class="form-control" id="detail-lower-limit[]" name="detail-lower-limit[]" value="{{ $i->lower_limit }}" step="0.01" required>
                                                </div>
                                            </th>
                                            <th scope="row">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" id="inputGroupPrepend">$</span>
                                                    </div>
                                                    <input type="number" class="form-control" id="detail-uper-limit[]" name="detail-uper-limit[]" value="{{ $i->uper_limit }}" step="0.01">
                                                </div>
                                            </th>
                                            <th scope="row">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" id="inputGroupPrepend">$</span>
                                                    </div>
                                                    <input type="number" class="form-control" id="detail-fixed-fee[]" name="detail-fixed-fee[]" value="{{ $i->fixed_fee }}" step="0.01" required>
                                                </div>
                                            </th>
                                            <th scope="row">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" id="inputGroupPrepend">$</span>
                                                    </div>
                                                    <input type="number" class="form-control" id="detail-percent[]" name="detail-percent[]" value="{{ $i->percent }}" step="0.01" required>
                                                </div>
                                            </th>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div id="div-subsidio" class="tab-pane fade">
                        <div id="div-details" class="tab-pane">
                            <div class="border rounded">
                                <table class="table table-sm table-striped table-hover">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Para ingresos de</th>
                                            <th>Hasta ingresos de</th>
                                            <th>Cantidad de subsidio para el empleo diario</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($subsidies as $i)
                                        <tr>
                                            <th scope="row">
                                                <input type="hidden" id="subsidy-id[]" name="subsidy-id[]" value="{{ $i->id }}">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" id="inputGroupPrepend">$</span>
                                                    </div>
                                                    <input type="number" class="form-control" id="subsidy-lower-limit[]" name="subsidy-lower-limit[]" value="{{ $i->lower_limit }}" step="0.01" required>
                                                </div>
                                            </th>
                                            <th scope="row">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" id="inputGroupPrepend">$</span>
                                                    </div>
                                                    <input type="number" class="form-control" id="subsidy-uper-limit[]" name="subsidy-uper-limit[]" value="{{ $i->uper_limit }}" step="0.01">
                                                </div>
                                            </th>
                                            <th scope="row">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" id="inputGroupPrepend">$</span>
                                                    </div>
                                                    <input type="number" class="form-control" id="subsidy-percent[]" name="subsidy-percent[]" value="{{ $i->subsidy }}" step="0.01" required>
                                                </div>
                                            </th>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-footer d-flex justify-content-between">
                    <a href="/admin/isr-periods" class="btn btn-sm btn-outline-secondary mr-2"><i class="fa fa-chevron-left mr-2"></i>Regresar</a>
                    <button name="action" value="store" type="submit" class="btn btn-sm btn-success ml-2"><i class="fa fa-check mr-2"></i>Confirmar</button>
                </div>
            </div>
        </form>
        @include('components.footer')
    </body>
</html>
